/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.ar;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.pipe.PipeFactory;
import de.unkrig.commons.io.pipe.PipeUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.CollectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class ArArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(CollectionUtil.map(".a", "", ".ar", ""), ".a");
    private static final ArchiveFormat INSTANCE = new ArArchiveFormat();

    private ArArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "ar";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        return new ArArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return new ArArchiveInputStream((InputStream)new FileInputStream(archiveFile));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        return new ArArchiveOutputStream(os);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new ArArchiveOutputStream((OutputStream)new FileOutputStream(archiveFile));
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        PipeUtil.InputOutputStreams ios = PipeUtil.asInputOutputStreams(PipeFactory.elasticPipe());
        try {
            long count = IoUtil.writeAndCount(writeContents, ios.getOutputStream());
            ios.getOutputStream().close();
            archiveOutputStream.putArchiveEntry((ArchiveEntry)new ArArchiveEntry(name, count));
            IoUtil.copy(ios.getInputStream(), (OutputStream)archiveOutputStream);
            ios.getInputStream().close();
            archiveOutputStream.closeArchiveEntry();
        }
        finally {
            try {
                ios.getOutputStream().close();
            }
            catch (Exception exception) {}
            try {
                ios.getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) {
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        throw new UnsupportedOperationException("The AR archive format does not support directory entries");
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        ArArchiveEntry aae;
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        ArArchiveEntry arArchiveEntry = aae = archiveEntry instanceof ArArchiveEntry ? (ArArchiveEntry)archiveEntry : new ArArchiveEntry("", 0L);
        if (archiveEntry.isDirectory()) {
            return;
        }
        PipeUtil.InputOutputStreams ios = PipeUtil.asInputOutputStreams(PipeFactory.elasticPipe());
        try {
            long count = IoUtil.writeAndCount(writeContents, ios.getOutputStream());
            ios.getOutputStream().close();
            ArArchiveEntry naae = new ArArchiveEntry(name != null ? name : archiveEntry.getName(), count, aae.getUserId(), aae.getGroupId(), aae.getMode(), archiveEntry.getLastModifiedDate().getTime());
            archiveOutputStream.putArchiveEntry((ArchiveEntry)naae);
            IoUtil.copy(ios.getInputStream(), (OutputStream)archiveOutputStream);
            ios.getInputStream().close();
            archiveOutputStream.closeArchiveEntry();
        }
        finally {
            try {
                ios.getOutputStream().close();
            }
            catch (Exception exception) {}
            try {
                ios.getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return ArArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

