/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.MarkableFileInputStream;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;

public abstract class ArchiveFormatFactory {
    private static final String FORMATS_RESOURCE = "de/unkrig/commons/file/org/apache/commons/compress/archivers/formats";
    private static final String SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final Map<String, ArchiveFormat> ALL_ARCHIVE_FORMATS;

    static {
        HashMap<String, ArchiveFormat> m = new HashMap<String, ArchiveFormat>();
        try {
            ClassLoader cl = ArchiveFormatFactory.class.getClassLoader();
            Enumeration<URL> en = cl.getResources(FORMATS_RESOURCE);
            if (!en.hasMoreElements()) {
                throw new FileNotFoundException(FORMATS_RESOURCE);
            }
            ArrayList<URL> scannedResources = new ArrayList<URL>();
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), Charset.forName("ISO8859-1")));
                try {
                    String line = br.readLine();
                    while (line != null) {
                        Class<?> archiveFormatClass;
                        ArchiveFormat af;
                        if ((line = line.trim()).length() != 0 && line.charAt(0) != '#' && m.put((af = (ArchiveFormat)(archiveFormatClass = cl.loadClass(line)).getMethod("get", new Class[0]).invoke(null, new Object[0])).getName(), af) != null) {
                            throw new ExceptionInInitializerError("Scanning \"" + url + "\": Duplicate archive format name '" + af.getName() + "'. Previously scanned locations: " + scannedResources + ". Archive formats scanned so far: " + m.keySet());
                        }
                        line = br.readLine();
                    }
                    br.close();
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                scannedResources.add(url);
            }
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        ALL_ARCHIVE_FORMATS = Collections.unmodifiableMap(m);
        String packagE = ArchiveFormatFactory.class.getPackage().getName();
        String phps = System.getProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS);
        if (phps == null) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, packagE);
        } else if (!Arrays.asList(phps.split("\\|")).contains(packagE)) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, String.valueOf(phps) + '|' + packagE);
        }
    }

    private ArchiveFormatFactory() {
    }

    public static Collection<ArchiveFormat> allFormats() {
        return ALL_ARCHIVE_FORMATS.values();
    }

    @Nullable
    public static ArchiveFormat forFileName(String fileName) {
        for (ArchiveFormat af : ALL_ARCHIVE_FORMATS.values()) {
            if (!af.isArchiveFileName(fileName)) continue;
            return af;
        }
        return null;
    }

    public static ArchiveFormat forFormatName(String archiveFormatName) throws ArchiveException {
        ArchiveFormat result = ALL_ARCHIVE_FORMATS.get(archiveFormatName);
        if (result == null) {
            throw new ArchiveException(archiveFormatName);
        }
        return result;
    }

    @Nullable
    public static ArchiveFormat forContents(InputStream is) throws IOException {
        byte[] signature = new byte[512];
        is.mark(signature.length);
        int signatureLength = IOUtils.readFully((InputStream)is, (byte[])signature);
        is.reset();
        for (ArchiveFormat af : ALL_ARCHIVE_FORMATS.values()) {
            if (!af.matches(signature, signatureLength)) continue;
            return af;
        }
        return null;
    }

    @Nullable
    public static ArchiveFormat forContents(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            ArchiveFormat result = ArchiveFormatFactory.forContents(is);
            ((InputStream)is).close();
            ArchiveFormat archiveFormat = result;
            return archiveFormat;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public static ArchiveFormat forArchiveOutputStream(ArchiveOutputStream archiveOutputStream) {
        for (ArchiveFormat af : ALL_ARCHIVE_FORMATS.values()) {
            try {
                if (af.archiveOutputStream(IoUtil.NULL_OUTPUT_STREAM).getClass() != archiveOutputStream.getClass()) continue;
                return af;
            }
            catch (StreamingNotSupportedException streamingNotSupportedException) {
            }
            catch (ArchiveException archiveException) {
                // empty catch block
            }
        }
        throw new AssertionError(archiveOutputStream.getClass());
    }

    @Deprecated
    public static long getEntryCrc32(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            return ((ZipArchiveEntry)archiveEntry).getCrc();
        }
        if (archiveEntry instanceof SevenZArchiveEntry) {
            SevenZArchiveEntry szae = (SevenZArchiveEntry)archiveEntry;
            return szae.getHasCrc() ? 0xFFFFFFFFL & szae.getCrcValue() : -1L;
        }
        return -1L;
    }

    public static ArchiveInputStream archiveInputStream(InputStream inputStream) throws IOException, ArchiveException {
        ArchiveFormat af = ArchiveFormatFactory.forContents(inputStream);
        if (af == null) {
            throw new ArchiveException("Cannot determine archive format from stream contents");
        }
        return af.archiveInputStream(inputStream);
    }

    public static ArchiveInputStream open(File archiveFile) throws IOException, ArchiveException {
        MarkableFileInputStream is = new MarkableFileInputStream(archiveFile);
        try {
            ArchiveFormat af = ArchiveFormatFactory.forContents(is);
            if (af == null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ArchiveException("Cannot determine archive format from the contents of '" + archiveFile + "'");
            }
            return af.archiveInputStream(is);
        }
        catch (IOException ioe) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
        catch (RuntimeException re) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    public static String normalizeEntryName(String name) {
        while (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

