/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.doclet.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import de.unkrig.commons.doclet.Docs;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Html {
    public static final LinkMaker STANDARD_LINK_MAKER;
    private static final Pattern DOC_TAG;
    private static final String LINE_SEPARATOR;
    private final LinkMaker linkMaker;
    private static final Pattern AMPERSAND;
    private static final Pattern LESS_THAN;
    private static final Pattern GREATER_THAN;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        STANDARD_LINK_MAKER = new LinkMaker(){

            @Override
            @Nullable
            public String makeHref(Doc from, Doc to, RootDoc rootDoc) {
                if (to == from && !(to instanceof ClassDoc)) {
                    return null;
                }
                if (!to.isIncluded()) {
                    return null;
                }
                PackageDoc toPackage = Docs.packageScope(to);
                if (!$assertionsDisabled && toPackage == null) {
                    throw new AssertionError();
                }
                PackageDoc fromPackage = Docs.packageScope(from);
                StringBuilder href = new StringBuilder();
                if (fromPackage != null) {
                    String[] stringArray = fromPackage.name().split("\\.");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String component = stringArray[n2];
                        href.append("../");
                        ++n2;
                    }
                }
                href.append(toPackage.name().replace('.', '/')).append('/');
                ClassDoc toClass = Docs.classScope(to);
                if (toClass == null) {
                    href.append("index.html");
                } else {
                    href.append(toClass.name()).append(".html");
                }
                href.append(Html.fragmentIdentifier(to));
                return href.toString();
            }

            @Override
            public String makeDefaultLabel(Doc from, Doc to, RootDoc rootDoc) {
                String label;
                if (!(to instanceof MemberDoc)) {
                    return to.name();
                }
                MemberDoc toMember = (MemberDoc)to;
                String string = label = toMember.containingClass() == from || from instanceof MemberDoc && toMember.containingClass() == ((MemberDoc)from).containingClass() ? "" : String.valueOf(toMember.containingClass().name()) + '.';
                if (to.isField()) {
                    return String.valueOf(label) + to.name();
                }
                if (to.isConstructor()) {
                    ConstructorDoc toConstructorDoc = (ConstructorDoc)to;
                    return String.valueOf(label) + toConstructorDoc.containingClass().name() + this.prettyPrintParameterList((ExecutableMemberDoc)toConstructorDoc);
                }
                if (to.isMethod()) {
                    MethodDoc toMethodDoc = (MethodDoc)to;
                    return String.valueOf(label) + to.name() + this.prettyPrintParameterList((ExecutableMemberDoc)toMethodDoc);
                }
                throw new IllegalArgumentException(String.valueOf(to));
            }

            private String prettyPrintParameterList(ExecutableMemberDoc executableMemberDoc) {
                StringBuilder result = new StringBuilder().append('(');
                int i = 0;
                while (i < executableMemberDoc.parameters().length) {
                    Type pt;
                    Parameter parameter = executableMemberDoc.parameters()[i];
                    if (i > 0) {
                        result.append(", ");
                    }
                    if ((pt = parameter.type()).isPrimitive()) {
                        result.append(pt.toString());
                    } else {
                        ClassDoc cd = pt.asClassDoc();
                        if (!$assertionsDisabled && cd == null) {
                            throw new AssertionError(parameter);
                        }
                        result.append(cd.name());
                    }
                    ++i;
                }
                result.append(')');
                return result.toString();
            }
        };
        DOC_TAG = Pattern.compile("\\{(@[^\\s}]+)(?:\\s+([^\\s}][^}]*))?\\}", 34);
        LINE_SEPARATOR = System.getProperty("line.separator");
        AMPERSAND = Pattern.compile("&");
        LESS_THAN = Pattern.compile("<");
        GREATER_THAN = Pattern.compile(">");
    }

    private static String fragmentIdentifier(Doc doc) {
        if (doc.isField()) {
            return String.valueOf('#') + doc.name();
        }
        if (doc.isConstructor()) {
            ConstructorDoc constructorDoc = (ConstructorDoc)doc;
            return String.valueOf('#') + constructorDoc.containingClass().name() + Html.parameterListForFragmentIdentifier((ExecutableMemberDoc)constructorDoc);
        }
        if (doc.isMethod()) {
            MethodDoc methodDoc = (MethodDoc)doc;
            return String.valueOf('#') + doc.name() + Html.parameterListForFragmentIdentifier((ExecutableMemberDoc)methodDoc);
        }
        return "";
    }

    private static String parameterListForFragmentIdentifier(ExecutableMemberDoc executableMemberDoc) {
        StringBuilder result = new StringBuilder().append('(');
        int i = 0;
        while (i < executableMemberDoc.parameters().length) {
            Parameter parameter = executableMemberDoc.parameters()[i];
            if (i > 0) {
                result.append(", ");
            }
            result.append(parameter.type().qualifiedTypeName());
            ++i;
        }
        return result.append(')').toString();
    }

    public Html(LinkMaker linkMaker) {
        this.linkMaker = linkMaker;
    }

    public String fromTags(Tag[] tags, Doc ref, RootDoc rootDoc) throws Longjump {
        StringBuilder sb = new StringBuilder();
        Tag[] tagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            String tagText = tag.text();
            if (tagText.isEmpty()) {
                tagText = null;
            }
            sb.append(this.expandTag(ref, rootDoc, tag.name(), tagText));
            ++n2;
        }
        return sb.toString();
    }

    public String fromJavadocText(String s, Doc ref, RootDoc rootDoc) throws Longjump {
        Matcher m = DOC_TAG.matcher(s);
        if (m.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                String tagName = m.group(1).intern();
                String argument = m.group(2);
                String replacement = this.expandTag(ref, rootDoc, tagName, argument);
                m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (m.find());
            return m.appendTail(sb).toString();
        }
        return s;
    }

    protected String expandTag(Doc ref, RootDoc rootDoc, String tagName, @Nullable String argument) throws Longjump {
        if ("Text".equals(tagName)) {
            if (argument == null) {
                return "";
            }
            int idx = argument.indexOf(10);
            while (idx != -1) {
                if (idx == argument.length() - 1) {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR;
                    break;
                }
                char c = argument.charAt(idx + 1);
                if (c == '\n') {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR + argument.substring(idx + 1);
                    idx += LINE_SEPARATOR.length();
                } else if (c == ' ') {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR + argument.substring(idx + 2);
                    idx += LINE_SEPARATOR.length();
                } else {
                    argument = String.valueOf(argument.substring(0, idx)) + argument.substring(idx + 1);
                }
                idx = argument.indexOf(10, idx);
            }
            return argument;
        }
        if ("@code".equals(tagName)) {
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@code ...}' tag");
                return "";
            }
            argument = Html.escapeSgmlEntities(argument);
            return "<code>" + argument + "</code>";
        }
        if ("@value".equals(tagName)) {
            Doc doc;
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@value ...}' tag");
                return "";
            }
            Doc doc2 = doc = argument.length() == 0 ? ref : Docs.findDoc(ref, argument, rootDoc);
            if (doc == null) {
                rootDoc.printError(ref.position(), "Field '" + argument + "' not found");
                return argument;
            }
            if (!(doc instanceof FieldDoc)) {
                rootDoc.printError(doc.position(), "'" + argument + "' does not designate a field");
                return argument;
            }
            Object cv = ((FieldDoc)doc).constantValue();
            if (cv == null) {
                rootDoc.printError(doc.position(), "Field '" + argument + "' does not have a constant value");
                return argument;
            }
            return this.makeLink(ref, doc, true, cv.toString(), null, rootDoc);
        }
        if ("@link".equals(tagName) || "@linkplain".equals(tagName)) {
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@link ...}' tag");
                return "";
            }
            Matcher m = Pattern.compile("([^\\(\\s]*(?:\\([^\\)]*\\))?)(?:\\s+(.*))?").matcher(argument);
            if (!m.matches()) {
                throw new AssertionError((Object)"Regex does not match");
            }
            String targetSpec = m.group(1);
            String label = m.group(2);
            return this.makeLink(ref, targetSpec, "@linkplain".equals(tagName), label, rootDoc);
        }
        rootDoc.printError(ref.position(), "Inline tag '{" + tagName + "}' is not supported; you could " + "(A) remove it from the text, or " + "(B) improve 'Html.expandTag()' to transform it into nice HTML (if that is " + "reasonably possible)");
        return "{" + tagName + (argument == null ? "" : " " + argument) + "}";
    }

    public static Doc hrefToDoc(String href, RootDoc rootDoc, ClassDoc from) throws Longjump {
        String prefix = href.startsWith("#") ? from.qualifiedName() : String.valueOf(from.containingPackage().name()) + '.';
        while (href.startsWith("../")) {
            prefix = prefix.substring(0, prefix.lastIndexOf(46, prefix.length() - 2) + 1);
            href = href.substring(3);
        }
        Doc result = Docs.findDoc((Doc)rootDoc, String.valueOf(prefix) + href.replace('/', '.'), rootDoc);
        if (result == null) {
            throw new Longjump();
        }
        return result;
    }

    public String makeLink(Doc from, String to, boolean plain, @Nullable String label, RootDoc rootDoc) throws Longjump {
        Doc to2 = Docs.findDoc(from, to, rootDoc);
        if (to2 == null) {
            rootDoc.printError(from.position(), "Cannot resolve target \"" + to + "\" relative to \"" + from + "\"");
            return "{@link " + to + (label == null ? "}" : String.valueOf(' ') + label + '}');
        }
        return this.makeLink(from, to2, plain, label, null, rootDoc);
    }

    public String makeLink(Doc from, Doc to, boolean plain, @Nullable String label, @Nullable String target, RootDoc rootDoc) throws Longjump {
        String href;
        if (label == null) {
            label = this.linkMaker.makeDefaultLabel(from, to, rootDoc);
        }
        if (!plain) {
            label = "<code>" + label + "</code>";
        }
        if ((href = this.linkMaker.makeHref(from, to, rootDoc)) == null) {
            return label;
        }
        return "<a href=\"" + href + "\"" + (to.isOrdinaryClass() ? " title=\"class in " + ((ClassDoc)to).containingPackage().name() + "\"" : (to.isInterface() ? " title=\"interface in " + ((ClassDoc)to).containingPackage().name() + "\"" : "")) + (target == null ? "" : " target=\"" + target + "\"") + ">" + label + "</a>";
    }

    public static String escapeSgmlEntities(String text) {
        text = AMPERSAND.matcher(text).replaceAll("&amp;");
        text = LESS_THAN.matcher(text).replaceAll("&lt;");
        text = GREATER_THAN.matcher(text).replaceAll("&gt;");
        return text;
    }

    @Nullable
    public String optionalTag(Doc doc, String tagName, RootDoc rootDoc) throws Longjump {
        String s = Tags.optionalTag(doc, tagName, rootDoc);
        if (s == null) {
            return null;
        }
        return this.fromJavadocText(s, doc, rootDoc);
    }

    public String optionalTag(Doc doc, String tagName, String defaulT, RootDoc rootDoc) throws Longjump {
        String s = Tags.optionalTag(doc, tagName, defaulT, rootDoc);
        return this.fromJavadocText(s, doc, rootDoc);
    }

    /*
     * Unable to fully structure code
     */
    public String generateFor(Doc doc, RootDoc rootDoc) throws Longjump {
        htmlText = this.fromTags(doc.inlineTags(), doc, rootDoc);
        seeTags = doc.tags("@see");
        if (seeTags.length == 0) {
            return htmlText;
        }
        sb = new StringBuilder(htmlText).append("<dl><dt>See also:</dt>");
        var9_6 = seeTags;
        var8_7 = seeTags.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            seeTag = var9_6[var7_8];
            try {
                block7: {
                    block6: {
                        sb.append("<dd>");
                        text = seeTag.text();
                        if (!text.startsWith("\"")) break block6;
                        sb.append(this.fromJavadocText(text, doc, rootDoc));
                        ** GOTO lbl37
                    }
                    if (!text.startsWith("<")) break block7;
                    sb.append(this.fromJavadocText(text, doc, rootDoc));
                    ** GOTO lbl37
                }
                to = Docs.findDoc(doc, text, rootDoc);
                if (to == null) {
                    rootDoc.printError(doc.position(), "Cannot resolve '" + text + "'");
                    sb.append("<code>").append(text).append("</code>");
                } else {
                    sb.append("<code><a href=\"").append(this.linkMaker.makeHref(doc, to, rootDoc));
                    sb.append("\">").append(this.linkMaker.makeDefaultLabel(doc, to, rootDoc));
                    sb.append("</a></code>");
lbl37:
                    // 3 sources

                    sb.append("</dd>");
                }
            }
            catch (Longjump var10_11) {
                // empty catch block
            }
            ++var7_8;
        }
        sb.append("</dl>");
        return sb.toString();
    }

    public static final class ExternalJavadocsLinkMaker
    implements LinkMaker {
        private final Map<String, URL> externalJavadocs;
        private final LinkMaker delegate;

        public ExternalJavadocsLinkMaker(Map<String, URL> externalJavadocs, LinkMaker delegate) {
            this.externalJavadocs = externalJavadocs;
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public String makeHref(Doc from, Doc to, RootDoc rootDoc) throws Longjump {
            PackageDoc toPackage = Docs.packageScope(to);
            assert (toPackage != null);
            URL url = this.externalJavadocs.get(toPackage.name());
            if (url == null) {
                return this.delegate.makeHref(from, to, rootDoc);
            }
            ClassDoc toClass = Docs.classScope(to);
            if (toClass == null) {
                return String.valueOf(url.toString()) + '/' + toPackage.name().replace('.', '/') + "/index.html";
            }
            return url + toClass.qualifiedName().replace('.', '/') + ".html" + Html.fragmentIdentifier(to);
        }

        @Override
        public String makeDefaultLabel(Doc from, Doc to, RootDoc rootDoc) throws Longjump {
            PackageDoc toPackage = Docs.packageScope(to);
            assert (toPackage != null);
            if (this.externalJavadocs.containsKey(toPackage.name())) {
                return STANDARD_LINK_MAKER.makeDefaultLabel(from, to, rootDoc);
            }
            return this.delegate.makeDefaultLabel(from, to, rootDoc);
        }
    }

    public static interface LinkMaker {
        @Nullable
        public String makeHref(Doc var1, Doc var2, RootDoc var3) throws Longjump;

        public String makeDefaultLabel(Doc var1, Doc var2, RootDoc var3) throws Longjump;
    }
}

