
/*
 * de.unkrig.commons - A general-purpose Java class library
 *
 * Copyright (c) 2014, Arno Unkrig
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *       following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *       following disclaimer in the documentation and/or other materials provided with the distribution.
 *    3. The name of the author may not be used to endorse or promote products derived from this software without
 *       specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * A replacement for {@link org.apache.commons.compress.archivers.ArchiveStreamFactory}, with several
 * improvements.
 * <ul>
 *   <li>
 *     Additional archive formats can be 'plugged in' at runtime (see {@link
 *     de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory ArchiverUtil}).
 *   </li>
 *   <li>
 *     {@link de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory#allFormats()
 *     ArchiverUtil.allArchiveFormats()} tells you which archive formats are currently available.
 *   </li>
 *   <li>
 *     You can read, write and even copy entries from one format to another without knowing them at compile time.
 *   </li>
 *   <li>
 *     Archive formats can be determined from
 *     <ul>
 *       <li>
 *         The {@link
 *         de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory#forContents contents}
 *         (i.e. the 'magic number' at the beginning of an archive which is characteristical for the archive format)
 *       </li>
 *       <li>
 *         A {@link
 *         de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory#forFileName file
 *         name} (e.g. 'dir/file.zip')
 *       </li>
 *       <li>
 *         The {@link
 *         de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory#forFormatName
 *         format name} ('zip', 'tar', ...)
 *       </li>
 *     </ul>
 *   </li>
 * </ul>
 */
@de.unkrig.commons.nullanalysis.NotNullByDefault
package de.unkrig.commons.file.org.apache.commons.compress.archivers;
