/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.time;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Duration {
    private static final Pattern TI_X = Pattern.compile("\\d++(?:\\.\\d*)?");
    private static final Pattern TI_MS = Pattern.compile("(\\d+)ms(?:ecs?)?");
    private static final Pattern TI_S = Pattern.compile("(\\d+)(\\.\\d*)?s(?:ecs?)?");
    private static final Pattern TI_M = Pattern.compile("(\\d+)mins?");
    private static final Pattern TI_X_X = Pattern.compile("(?:\\d+):(?:\\d+)");
    private static final Pattern TI_M_S__1 = Pattern.compile("(\\d+)mins? (\\d+)(\\.\\d*)?s(?:ecs?)?");
    private static final Pattern TI_M_S__2 = Pattern.compile("(\\d+):(\\d+)(\\.\\d*)?(?:mins?)?");
    private static final Pattern TI_H = Pattern.compile("(\\d++)h(?:ours?)?");
    private static final Pattern TI_H_M__1 = Pattern.compile("(\\d+):(\\d+)h(?:ours?)?");
    private static final Pattern TI_H_M__2 = Pattern.compile("(\\d+)h(?:ours?)? (\\d+)mins?");
    private static final Pattern TI_H_M_S__1 = Pattern.compile("(\\d+):(\\d+):(\\d+)(\\.\\d*)?");
    private static final Pattern TI_H_M_S__2 = Pattern.compile("(\\d+)h(?:ours?)? (\\d+)mins? (\\d+)(\\.\\d*)?s(?:ecs?)?");
    private static final Pattern TI_D = Pattern.compile("(\\d++)d(?:ays?)?");
    private static final Pattern TI_D_H = Pattern.compile("(\\d+)d(?:ays?)? (\\d+)h(?:ours?)?");
    private static final Pattern TI_D_H_M__1 = Pattern.compile("(\\d+)d(?:ays?)? (\\d+):(\\d+)");
    private static final Pattern TI_D_H_M__2 = Pattern.compile("(\\d+)d(?:ays?)? (\\d+)h(?:ours?)? (\\d+)mins?");
    private static final Pattern TI_D_H_M_S__1 = Pattern.compile("(\\d+)d(?:ays?)? (\\d+):(\\d+):(\\d+)(\\.\\d*)?");
    private static final Pattern TI_D_H_M_S__2 = Pattern.compile("(\\d+)d(?:ays?)? (\\d+)h(?:ours?)? (\\d+)mins? (\\d+)(\\.\\d*)?s(?:ecs?)?");
    private static final Pattern TI_W = Pattern.compile("(\\d++)w(?:eeks?)?");
    private static final Pattern TI_W_D = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)?");
    private static final Pattern TI_W_D_H = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)? (\\d+)h(?:ours?)?");
    private static final Pattern TI_W_D_H_M__1 = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)? (\\d+):(\\d+)");
    private static final Pattern TI_W_D_H_M__2 = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)? (\\d+)h(?:ours?)? (\\d+)mins?");
    private static final Pattern TI_W_D_H_M_S__1 = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)? (\\d+):(\\d+):(\\d+)(\\.\\d*)?");
    private static final Pattern TI_W_D_H_M_S__2 = Pattern.compile("(\\d+)w(?:eeks?)? (\\d+)d(?:ays?)? (\\d+)h(?:ours?)? (\\d+)mins? (\\d+)(\\.\\d*)?s(?:ecs?)?");
    private final long ms;

    public Duration(long ms) {
        this.ms = ms;
    }

    public Duration(double seconds) {
        this.ms = (long)(1000.0 * seconds);
    }

    public Duration(String s) {
        Matcher m = TI_X.matcher(s);
        if (m.matches()) {
            throw new IllegalArgumentException("'" + s + "' could mean weeks, days, hours, minutes, seconds or milliseconds; please write '" + s + "w, " + s + "d, " + s + "h, " + s + "min, " + s + "s, " + s + "ms, " + s + ":00:00', '0:" + s + ":00' or '0:0:" + s + "'");
        }
        m = TI_MS.matcher(s);
        if (m.matches()) {
            this.ms = Duration.milliseconds(m.group(1));
            return;
        }
        m = TI_S.matcher(s);
        if (m.matches()) {
            this.ms = Duration.seconds(m.group(1)) + Duration.sfrac(m.group(2));
            return;
        }
        m = TI_M.matcher(s);
        if (m.matches()) {
            this.ms = Duration.minutes(m.group(1));
            return;
        }
        m = TI_X_X.matcher(s);
        if (m.matches()) {
            throw new IllegalArgumentException("'" + s + "' could mean 'hh:mm' or 'mm:ss'; please use either '" + s + ":00' or '0:" + s + "'");
        }
        m = TI_M_S__1.matcher(s);
        if (m.matches() || (m = TI_M_S__2.matcher(s)).matches()) {
            this.ms = Duration.minutes(m.group(1)) + Duration.seconds(m.group(2)) + Duration.sfrac(m.group(3));
            return;
        }
        m = TI_H.matcher(s);
        if (m.matches()) {
            this.ms = Duration.hours(m.group(1));
            return;
        }
        m = TI_H_M__1.matcher(s);
        if (m.matches() || (m = TI_H_M__2.matcher(s)).matches()) {
            this.ms = Duration.hours(m.group(1)) + Duration.minutes(m.group(2));
            return;
        }
        m = TI_H_M_S__1.matcher(s);
        if (m.matches() || (m = TI_H_M_S__2.matcher(s)).matches()) {
            this.ms = 0L + Duration.hours(m.group(1)) + Duration.minutes(m.group(2)) + Duration.seconds(m.group(3)) + Duration.sfrac(m.group(4));
            return;
        }
        m = TI_D.matcher(s);
        if (m.matches()) {
            this.ms = Duration.days(m.group(1));
            return;
        }
        m = TI_D_H.matcher(s);
        if (m.matches()) {
            this.ms = 0L + Duration.days(m.group(1)) + Duration.hours(m.group(2));
            return;
        }
        m = TI_D_H_M__1.matcher(s);
        if (m.matches() || (m = TI_D_H_M__2.matcher(s)).matches()) {
            this.ms = 0L + Duration.days(m.group(1)) + Duration.hours(m.group(2)) + Duration.minutes(m.group(3));
            return;
        }
        m = TI_D_H_M_S__1.matcher(s);
        if (m.matches() || (m = TI_D_H_M_S__2.matcher(s)).matches()) {
            this.ms = 0L + Duration.days(m.group(1)) + Duration.hours(m.group(2)) + Duration.minutes(m.group(3)) + Duration.seconds(m.group(4)) + Duration.sfrac(m.group(5));
            return;
        }
        m = TI_W.matcher(s);
        if (m.matches()) {
            this.ms = Duration.weeks(m.group(1));
            return;
        }
        m = TI_W_D.matcher(s);
        if (m.matches()) {
            this.ms = 0L + Duration.weeks(m.group(1)) + Duration.days(m.group(2));
            return;
        }
        m = TI_W_D_H.matcher(s);
        if (m.matches()) {
            this.ms = 0L + Duration.weeks(m.group(1)) + Duration.days(m.group(2)) + Duration.hours(m.group(3));
            return;
        }
        m = TI_W_D_H_M__1.matcher(s);
        if (m.matches() || (m = TI_W_D_H_M__2.matcher(s)).matches()) {
            this.ms = 0L + Duration.weeks(m.group(1)) + Duration.days(m.group(2)) + Duration.hours(m.group(3)) + Duration.minutes(m.group(4));
            return;
        }
        m = TI_W_D_H_M_S__1.matcher(s);
        if (m.matches() || (m = TI_W_D_H_M_S__2.matcher(s)).matches()) {
            this.ms = 0L + Duration.weeks(m.group(1)) + Duration.days(m.group(2)) + Duration.hours(m.group(3)) + Duration.minutes(m.group(4)) + Duration.seconds(m.group(5)) + Duration.sfrac(m.group(6));
            return;
        }
        throw new IllegalArgumentException("Time interval '" + s + "' cannot be parsed");
    }

    private static long weeks(String s) {
        return Long.parseLong(s) * 604800000L;
    }

    private static long days(String s) {
        return Long.parseLong(s) * 86400000L;
    }

    private static long hours(String s) {
        return Long.parseLong(s) * 3600000L;
    }

    private static long minutes(String s) {
        return Long.parseLong(s) * 60000L;
    }

    private static long seconds(String s) {
        return Long.parseLong(s) * 1000L;
    }

    private static long milliseconds(String s) {
        return Long.parseLong(s);
    }

    private static long sfrac(@Nullable String s) {
        if (s == null) {
            return 0L;
        }
        int l = s.length();
        int result = 0;
        if (l >= 2) {
            result += Character.digit(s.charAt(1), 10) * 100;
            if (l >= 3) {
                result += Character.digit(s.charAt(2), 10) * 10;
                if (l >= 4) {
                    result += Character.digit(s.charAt(3), 10);
                }
            }
        }
        return result;
    }

    public long milliseconds() {
        return this.ms;
    }

    public double toSeconds() {
        return (double)this.ms / 1000.0;
    }

    public String toString() {
        return this.ms < 1000L ? this.ms + "ms" : (this.ms < 60000L ? Duration.msToString(this.ms, false) + 's' : (this.ms < 86400000L ? String.format(Locale.US, "%d:%02d:%s", this.ms / 3600000L, this.ms / 60000L % 60L, Duration.msToString(this.ms % 60000L, true)) : (this.ms < 604800000L ? String.format(Locale.US, "%dd %d:%02d:%s", this.ms / 86400000L, this.ms / 3600000L % 24L, this.ms / 60000L % 60L, Duration.msToString(this.ms % 60000L, true)) : String.format(Locale.US, "%dw %dd %d:%02d:%s", this.ms / 604800000L, this.ms / 86400000L % 7L, this.ms / 3600000L % 24L, this.ms / 60000L % 60L, Duration.msToString(this.ms % 60000L, true)))));
    }

    private static String msToString(long t, boolean twoDigits) {
        StringBuilder sb = new StringBuilder();
        long s = (int)(t / 1000L);
        if (twoDigits && s <= 9L) {
            sb.append('0');
        }
        sb.append(s);
        int ms = (int)(t % 1000L);
        if (ms != 0) {
            sb.append('.').append(Character.forDigit(ms / 100, 10));
            if (ms % 100 != 0) {
                sb.append(Character.forDigit(ms / 10 % 10, 10));
                if (ms % 10 != 0) {
                    sb.append(Character.forDigit(ms % 10, 10));
                }
            }
        }
        return sb.toString();
    }

    public Duration add(Duration other) {
        return new Duration(this.ms + other.ms);
    }

    public Duration multiply(double factor) {
        return new Duration((long)((double)this.ms * factor));
    }

    public Duration divide(double divisor) {
        return new Duration((long)((double)this.ms / divisor));
    }

    public boolean isZero() {
        return this.ms == 0L;
    }

    public int hashCode() {
        return (int)(this.ms ^ this.ms >>> 32);
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof Duration && ((Duration)obj).ms == this.ms;
    }
}

