/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.handler;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.logging.handler.AbstractStreamHandler;
import java.io.OutputStream;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;

public class StreamHandler
extends AbstractStreamHandler {
    public StreamHandler() throws ParseException, EvaluationException {
        this(null);
    }

    public StreamHandler(@Nullable String propertyNamePrefix) throws ParseException, EvaluationException {
        super(propertyNamePrefix);
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        try {
            this.init(LogUtil.getLoggingProperty(propertyNamePrefix + ".outputStream", OutputStream.class));
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw pe;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
            throw ee;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public StreamHandler(OutputStream outputStream, boolean autoFlush, Level level, Filter filter, Formatter formatter, String encoding) {
        super(autoFlush, level, filter, formatter, encoding);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }
}

