/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.handler;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class ProxyHandler
extends Handler {
    @Nullable
    private Handler delegate;

    public ProxyHandler() {
        this.delegate = null;
    }

    public ProxyHandler(@Nullable Handler delegate) {
        this.delegate = delegate;
    }

    public void setDelegate(@Nullable Handler delegate) {
        this.delegate = delegate;
    }

    @Override
    public Formatter getFormatter() {
        return this.delegate != null ? this.delegate.getFormatter() : null;
    }

    @Override
    public String getEncoding() {
        return this.delegate != null ? this.delegate.getEncoding() : null;
    }

    @Override
    public Filter getFilter() {
        return this.delegate != null ? this.delegate.getFilter() : null;
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.delegate != null ? this.delegate.getErrorManager() : null;
    }

    @Override
    public Level getLevel() {
        return this.delegate != null ? this.delegate.getLevel() : null;
    }

    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        if (this.delegate != null) {
            this.delegate.setFormatter(formatter);
        }
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        if (this.delegate != null) {
            this.delegate.setEncoding(encoding);
        }
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        if (this.delegate != null) {
            this.delegate.setFilter(newFilter);
        }
    }

    @Override
    public void setErrorManager(ErrorManager errorManager) {
        if (this.delegate != null) {
            this.delegate.setErrorManager(errorManager);
        }
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
        if (this.delegate != null) {
            this.delegate.setLevel(level);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.delegate != null ? this.delegate.isLoggable(record) : false;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.delegate != null) {
            this.delegate.publish(record);
        }
    }

    @Override
    public void flush() {
        if (this.delegate != null) {
            this.delegate.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

