/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    public static final Iterator AT_END = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private IteratorUtil() {
    }

    public static <T> Iterator<T> atEnd() {
        return AT_END;
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> delegate, final PredicateWhichThrows<? super T, ? extends RuntimeException> qualifies) {
        return new Iterator<T>(){
            @Nullable
            T lookahead;

            @Override
            public boolean hasNext() {
                Object tmp;
                if (this.lookahead != null) {
                    return true;
                }
                do {
                    if (delegate.hasNext()) continue;
                    return false;
                } while (!qualifies.evaluate(tmp = delegate.next()));
                this.lookahead = tmp;
                return true;
            }

            @Override
            public T next() {
                Object tmp;
                if (this.lookahead != null) {
                    Object tmp2 = this.lookahead;
                    this.lookahead = null;
                    return tmp2;
                }
                while (!qualifies.evaluate(tmp = delegate.next())) {
                }
                return tmp;
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <I, O> Iterator<O> transform(final Iterator<? extends I> delegate, final Transformer<? super I, ? extends O> transform) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public O next() {
                return transform.transform(delegate.next());
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <T> Iterator<T> repeat(final T value) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> repeat(final int n, final T value) {
        return new Iterator<T>(){
            int count;

            @Override
            public boolean hasNext() {
                return this.count < n;
            }

            @Override
            public T next() {
                if (this.count >= n) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> ArrayIterator<T> iterator(final T[] array) {
        return new ArrayIterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                if (this.index >= array.length) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public int index() {
                return this.index;
            }
        };
    }

    public static int elementCount(Iterator<Integer> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static interface ArrayIterator<T>
    extends Iterator<T> {
        public int index();
    }
}

