/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.logging.formatter.PrintfFormatter;
import de.unkrig.commons.util.logging.formatter.SelectiveFormatter;
import de.unkrig.commons.util.logging.handler.ProxyHandler;
import de.unkrig.commons.util.logging.handler.StderrHandler;
import de.unkrig.commons.util.logging.handler.StdoutHandler;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogging {
    private static final Handler DEBUG_HANDLER;
    private static final ProxyHandler OUT_HANDLER;
    private static final Handler STDERR_HANDLER;
    private static final Formatter DEFAULT_DEBUG_FORMATTER;
    private static final Formatter DEFAULT_OUT_FORMATTER;
    private static final Formatter DEFAULT_STDERR_FORMATTER;
    private static final ExpressionEvaluator HANDLER_INSTANTIATOR;
    private static final ExpressionEvaluator FORMATTER_INSTANTIATOR;

    private SimpleLogging() {
    }

    public static void init() {
    }

    public static synchronized void setLevel(Level level) {
        LogUtil.ROOT_LOGGER.setLevel(level);
    }

    public static Level getLevel() {
        return LogUtil.ROOT_LOGGER.getLevel();
    }

    public static void setFormatter(String spec) throws ParseException, EvaluationException {
        Formatter formatter = (Formatter)FORMATTER_INSTANTIATOR.evaluateTo(spec, Formatter.class, new Object[0]);
        if (formatter == null) {
            DEBUG_HANDLER.setFormatter(DEFAULT_DEBUG_FORMATTER);
            OUT_HANDLER.setFormatter(DEFAULT_OUT_FORMATTER);
            STDERR_HANDLER.setFormatter(DEFAULT_STDERR_FORMATTER);
        } else {
            SimpleLogging.setFormatter(formatter);
        }
    }

    public static void setFormatter(Formatter formatter) {
        DEBUG_HANDLER.setFormatter(formatter);
        OUT_HANDLER.setFormatter(formatter);
        STDERR_HANDLER.setFormatter(formatter);
    }

    public static void setNoError() {
        SimpleLogging.setLevel(LogUtil.SEVERE_PLUS_1);
    }

    public static void setNoWarn() {
        SimpleLogging.setLevel(LogUtil.WARNING_PLUS_1);
    }

    public static void setQuiet() {
        SimpleLogging.setLevel(LogUtil.INFO_PLUS_1);
    }

    public static void setNormal() {
        SimpleLogging.setLevel(Level.INFO);
    }

    public static void setVerbose() {
        SimpleLogging.setLevel(Level.CONFIG);
    }

    public static void setDebug() {
        Level l = SimpleLogging.getLevel();
        SimpleLogging.setLevel(l == Level.FINER ? Level.FINEST : (l == Level.FINE ? Level.FINER : Level.FINE));
    }

    public static void setStdout() {
        SimpleLogging.setOut(new StdoutHandler());
    }

    public static void setOut(File value) throws IOException {
        SimpleLogging.setOut(new FileHandler(value.getPath()));
    }

    public static synchronized void setOut(@Nullable Handler handler) {
        OUT_HANDLER.close();
        OUT_HANDLER.setDelegate(handler == null ? new StdoutHandler() : handler);
        OUT_HANDLER.setFilter(LogUtil.LESS_THAN_WARNING);
        OUT_HANDLER.setLevel(Level.INFO);
        OUT_HANDLER.setFormatter(DEFAULT_OUT_FORMATTER);
    }

    public static void configureLoggers(String spec) {
        Formatter formatter;
        Handler handler;
        Logger[] loggers;
        String[] args = new String[5];
        String[] sa = spec.split(":", 5);
        for (int i = 0; i < args.length && i < sa.length; ++i) {
            String s = sa[i].trim();
            if ("".equals(s)) continue;
            args[i] = s;
        }
        Level level = args[0] != null ? Level.parse(args[0]) : null;
        if (args[1] != null) {
            String loggerNames = args[1];
            String[] tmp = loggerNames.split(",");
            loggers = new Logger[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                loggers[i] = Logger.getLogger(tmp[i]);
            }
        } else {
            loggers = new Logger[]{LogUtil.ROOT_LOGGER};
        }
        if (args[2] != null) {
            String handlerSpec = args[2];
            try {
                handler = (Handler)HANDLER_INSTANTIATOR.evaluateTo(handlerSpec, Handler.class, new Object[0]);
            }
            catch (Exception e) {
                throw (RuntimeException)ExceptionUtil.wrap((String)(handlerSpec + ": " + e.getMessage()), (Throwable)e, RuntimeException.class);
            }
        } else {
            handler = null;
        }
        if (args[3] != null) {
            String formatterSpec = args[3];
            try {
                formatter = (Formatter)FORMATTER_INSTANTIATOR.evaluateTo(formatterSpec, Formatter.class, new Object[0]);
            }
            catch (Exception e) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Evaluating formatter spec \"" + formatterSpec + "\": " + e.getMessage()), (Throwable)e, RuntimeException.class);
            }
        } else {
            formatter = PrintfFormatter.MESSAGE_AND_EXCEPTION;
        }
        boolean useParentHandlers = true;
        if (args[4] != null) {
            useParentHandlers = Boolean.parseBoolean(args[4]);
        }
        if (handler != null) {
            if (level != null) {
                handler.setLevel(level);
            }
            handler.setFormatter(formatter);
        }
        for (Logger logger : loggers) {
            if (handler != null) {
                logger.addHandler(handler);
            }
            if (level != null && !logger.isLoggable(level)) {
                logger.setLevel(level);
            }
            logger.setUseParentHandlers(useParentHandlers);
        }
    }

    static {
        DEFAULT_DEBUG_FORMATTER = new PrintfFormatter("%10$27s::%7$-15s %8$s%9$s%n");
        DEFAULT_STDERR_FORMATTER = DEFAULT_OUT_FORMATTER = SelectiveFormatter.loggerLevelGreaterThan(Level.FINE, PrintfFormatter.MESSAGE_AND_EXCEPTION, PrintfFormatter.MESSAGE_AND_STACK_TRACE);
        DEBUG_HANDLER = new StderrHandler();
        DEBUG_HANDLER.setFilter(LogUtil.LESS_THAN_CONFIG);
        DEBUG_HANDLER.setLevel(Level.ALL);
        DEBUG_HANDLER.setFormatter(DEFAULT_DEBUG_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(DEBUG_HANDLER);
        OUT_HANDLER = new ProxyHandler(new StdoutHandler());
        OUT_HANDLER.setFilter(LogUtil.LESS_THAN_WARNING);
        OUT_HANDLER.setLevel(Level.CONFIG);
        OUT_HANDLER.setFormatter(DEFAULT_OUT_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(OUT_HANDLER);
        STDERR_HANDLER = new StderrHandler();
        STDERR_HANDLER.setLevel(Level.WARNING);
        STDERR_HANDLER.setFormatter(DEFAULT_STDERR_FORMATTER);
        LogUtil.ROOT_LOGGER.addHandler(STDERR_HANDLER);
        for (Handler handler : LogUtil.ROOT_LOGGER.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.close();
            LogUtil.ROOT_LOGGER.removeHandler(handler);
        }
        SimpleLogging.setNormal();
        HANDLER_INSTANTIATOR = new ExpressionEvaluator(new String[0]).addOnDemandImports(new String[]{"java.util.logging", "de.unkrig.commons.util.logging.handler"});
        FORMATTER_INSTANTIATOR = new ExpressionEvaluator(new String[0]).addOnDemandImports(new String[]{"java.util.logging", "de.unkrig.commons.util.logging.formatter"});
    }
}

