/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.StatefulScanner;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class TimeTable {
    public static final TimeTable NEVER = new TimeTable(){

        @Override
        public Date next(Date previous) {
            return MAX_DATE;
        }

        @Override
        public String toString() {
            return "NEVER";
        }
    };
    public static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    public static final Date MIN_DATE = new Date(Long.MIN_VALUE);

    TimeTable() {
    }

    public abstract Date next(Date var1);

    public static TimeTable once(final Date date) {
        return new TimeTable(){

            @Override
            public Date next(Date previous) {
                return date.compareTo(previous) > 0 ? date : MAX_DATE;
            }

            @Override
            public String toString() {
                return date.toString();
            }
        };
    }

    public static TimeTable parse(String s) throws ParseException {
        StatefulScanner scanner = new StatefulScanner(ScannerState.class);
        scanner.addRule("(?=[^ ]*:)", (Enum)TokenType.BEFORE_TIME_PATTERN).goTo((Enum)ScannerState.IN_TIME_PATTERN);
        scanner.addRule("\\d+", (Enum)TokenType.INTEGER);
        scanner.addRule((Enum)ScannerState.IN_TIME_PATTERN, "\\d+", (Enum)TokenType.INTEGER).goTo((Enum)ScannerState.IN_TIME_PATTERN);
        scanner.addRule("[:\\-/\\*(),]", (Enum)TokenType.OPERATOR);
        scanner.addRule((Enum)ScannerState.IN_TIME_PATTERN, "[:\\-/\\*(),]", (Enum)TokenType.OPERATOR).goTo((Enum)ScannerState.IN_TIME_PATTERN);
        scanner.addRule(scanner.ANY_STATE, "\\w+", (Enum)TokenType.IDENTIFIER);
        scanner.addRule(scanner.ANY_STATE, " +", (Enum)TokenType.SPACE);
        scanner.setInput((CharSequence)s);
        try {
            return new Parser((AbstractScanner<TokenType>)scanner).parse();
        }
        catch (ParseException pe) {
            throw (ParseException)ExceptionUtil.wrap((String)("\"" + s + "\" at offset " + scanner.getPreviousTokenOffset()), (Throwable)pe);
        }
    }

    public abstract String toString();

    private static final class Parser
    extends AbstractParser<TokenType> {
        private static final Map<String, Integer> WEEKDAY_DISPLAY_NAMES;
        protected static final String[] WEEKDAY_NAMES;

        Parser(AbstractScanner<TokenType> scanner) {
            super(scanner);
        }

        public TimeTable parse() throws ParseException {
            return this.parsePatternSequence();
        }

        private TimeTable parsePatternSequence() throws ParseException {
            TimeTable tt = this.parsePattern();
            while (this.peekRead(",")) {
                final TimeTable lhs = tt;
                final TimeTable rhs = this.parsePattern();
                tt = new TimeTable(){

                    @Override
                    public Date next(Date previous) {
                        Date d2;
                        Date d1 = lhs.next(previous);
                        return d1.compareTo(d2 = rhs.next(previous)) < 0 ? d1 : d2;
                    }

                    @Override
                    public String toString() {
                        return lhs + "," + rhs;
                    }
                };
            }
            this.eoi();
            return tt;
        }

        private TimeTable parsePattern() throws ParseException {
            IntegerPattern hour;
            IntegerPattern minute;
            IntegerPattern second;
            IntegerPattern dayOfWeek;
            IntegerPattern year;
            IntegerPattern month;
            IntegerPattern dayOfMonth;
            block3: {
                block6: {
                    block4: {
                        block5: {
                            block1: {
                                block2: {
                                    block0: {
                                        if (this.peek(TokenType.BEFORE_TIME_PATTERN) == null && this.peek(TokenType.IDENTIFIER) == null) break block0;
                                        month = dayOfMonth = IntegerPattern.ANY;
                                        year = dayOfMonth;
                                        break block1;
                                    }
                                    year = this.parseYearPattern();
                                    this.read("-");
                                    month = this.parseMonthPattern();
                                    this.read("-");
                                    dayOfMonth = this.parseDayOfMonthPattern();
                                    if (this.peek() != null) break block2;
                                    dayOfWeek = IntegerPattern.ANY;
                                    minute = second = IntegerPattern.ZERO;
                                    hour = second;
                                    break block3;
                                }
                                this.read(TokenType.SPACE);
                            }
                            if (this.peek(TokenType.IDENTIFIER) == null) break block4;
                            dayOfWeek = this.parseDayOfWeekPattern();
                            if (this.peek() != null) break block5;
                            minute = second = IntegerPattern.ZERO;
                            hour = second;
                            break block3;
                        }
                        this.read(TokenType.SPACE);
                        break block6;
                    }
                    dayOfWeek = IntegerPattern.ANY;
                }
                this.read(TokenType.BEFORE_TIME_PATTERN);
                hour = this.parseHourPattern();
                this.read(":");
                minute = this.parseMinutePattern();
                second = this.peekRead(":") ? this.parseSecondPattern() : IntegerPattern.ZERO;
            }
            return new TimeTable(){

                @Override
                public Date next(Date previous) {
                    int mo;
                    int yy;
                    int hh;
                    int mm;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(previous);
                    cal.add(13, 1);
                    int ss = second.getConstant();
                    if (ss == -1) {
                        while (!second.matches(cal.get(13))) {
                            cal.add(13, 1);
                        }
                    } else {
                        if (cal.get(13) > ss) {
                            cal.add(12, 1);
                        }
                        cal.set(13, ss);
                    }
                    if ((mm = minute.getConstant()) == -1) {
                        while (!minute.matches(cal.get(12))) {
                            cal.add(12, 1);
                        }
                    } else {
                        if (cal.get(12) > mm) {
                            cal.add(11, 1);
                        }
                        cal.set(12, mm);
                    }
                    if ((hh = hour.getConstant()) == -1) {
                        while (!hour.matches(cal.get(11))) {
                            cal.add(11, 1);
                        }
                    } else {
                        if (cal.get(11) > hh) {
                            cal.add(11, 1);
                        }
                        cal.set(11, hh);
                    }
                    if ((yy = year.getConstant()) == -1) {
                        if (!year.matches(cal.get(1))) {
                            cal.set(5, 1);
                            cal.set(2, 0);
                            do {
                                cal.add(1, 1);
                            } while (!year.matches(cal.get(1)));
                        }
                    } else {
                        if (cal.get(1) > yy) {
                            return MAX_DATE;
                        }
                        if (yy > cal.get(1)) {
                            cal.set(5, 1);
                            cal.set(2, 0);
                            cal.set(1, yy);
                        }
                    }
                    if ((mo = month.getConstant()) == -1) {
                        if (!month.matches(cal.get(2) + 1)) {
                            cal.set(5, 1);
                            do {
                                cal.add(2, 1);
                            } while (!month.matches(cal.get(2) + 1) || !year.matches(cal.get(1)));
                        }
                    } else {
                        if (cal.get(2) + 1 > mo) {
                            do {
                                cal.add(1, 1);
                            } while (!year.matches(cal.get(1)));
                        }
                        cal.set(2, mo - 1);
                    }
                    while (!(dayOfMonth.matches(cal.get(5)) && dayOfWeek.matches(cal.get(7)) && month.matches(cal.get(2) + 1) && year.matches(cal.get(1)))) {
                        cal.add(5, 1);
                    }
                    return cal.getTime();
                }

                @Override
                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    if (year != IntegerPattern.ANY || month != IntegerPattern.ANY || dayOfMonth != IntegerPattern.ANY) {
                        sb.append(year).append('-').append(month).append('-').append(dayOfMonth);
                    }
                    if (dayOfWeek != IntegerPattern.ANY) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(dayOfWeek);
                    }
                    if (sb.length() == 0 || hour.getConstant() != 0 || minute.getConstant() != 0 || second.getConstant() != 0) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(hour).append(':').append(minute);
                        if (second.getConstant() != 0) {
                            sb.append(':').append(second);
                        }
                    }
                    return sb.toString();
                }
            };
        }

        private IntegerPattern parseDayOfWeekPattern() throws ParseException {
            IntegerPattern ip = this.parseWeekdayRange();
            while (this.peekRead(",")) {
                final IntegerPattern lhs = ip;
                final IntegerPattern rhs = this.parseWeekdayRange();
                ip = new IntegerPattern(){

                    @Override
                    public boolean matches(int subject) {
                        return lhs.matches(subject) || rhs.matches(subject);
                    }

                    @Override
                    public int getConstant() {
                        return -1;
                    }

                    public String toString() {
                        return lhs + "," + rhs;
                    }
                };
            }
            return ip;
        }

        private IntegerPattern parseWeekdayRange() throws ParseException {
            final int from = this.scanWeekday();
            if (!this.peekRead("-")) {
                return new ConstantIntegerPattern(from){

                    @Override
                    public String toString() {
                        return WEEKDAY_NAMES[from];
                    }
                };
            }
            final int to = this.scanWeekday();
            return new RangeIntegerPattern(from, to){

                @Override
                public String toString() {
                    return WEEKDAY_NAMES[from] + '-' + WEEKDAY_NAMES[to];
                }
            };
        }

        private IntegerPattern parseYearPattern() throws ParseException {
            return this.parseIntegerPattern(0, 3000, false);
        }

        private IntegerPattern parseMonthPattern() throws ParseException {
            return this.parseIntegerPattern(1, 12, false);
        }

        private IntegerPattern parseDayOfMonthPattern() throws ParseException {
            return this.parseIntegerPattern(1, 31, false);
        }

        private IntegerPattern parseHourPattern() throws ParseException {
            return this.parseIntegerPattern(0, 23, true);
        }

        private IntegerPattern parseMinutePattern() throws ParseException {
            return this.parseIntegerPattern(0, 59, true);
        }

        private IntegerPattern parseSecondPattern() throws ParseException {
            return this.parseIntegerPattern(0, 59, true);
        }

        private IntegerPattern parseIntegerPattern(int min, int max, boolean allowUnparenthesizedRange) throws ParseException {
            if (this.peekRead("*")) {
                if (this.peekRead("/")) {
                    return new StepIntegerPattern(IntegerPattern.ANY, this.parseInteger(min, max));
                }
                return IntegerPattern.ANY;
            }
            if (this.peekRead("(")) {
                IntegerPattern ip = this.parseIntegerRange(min, max);
                while (this.peekRead(",")) {
                    final IntegerPattern lhs = ip;
                    final IntegerPattern rhs = this.parseIntegerRange(min, max);
                    ip = new IntegerPattern(){

                        @Override
                        public boolean matches(int subject) {
                            return lhs.matches(subject) || rhs.matches(subject);
                        }

                        @Override
                        public int getConstant() {
                            return -1;
                        }

                        public String toString() {
                            return lhs + "," + rhs;
                        }
                    };
                }
                this.read(")");
                final IntegerPattern fip = ip;
                return new IntegerPattern(){

                    @Override
                    public boolean matches(int subject) {
                        return fip.matches(subject);
                    }

                    @Override
                    public int getConstant() {
                        return fip.getConstant();
                    }

                    public String toString() {
                        return '(' + fip.toString() + ')';
                    }
                };
            }
            return allowUnparenthesizedRange ? this.parseIntegerRange(min, max) : new ConstantIntegerPattern(this.parseInteger(min, max));
        }

        private IntegerPattern parseIntegerRange(int min, int max) throws ParseException {
            int from = this.parseInteger(min, max);
            if (this.peekRead("-")) {
                int to = this.parseInteger(min, max);
                IntegerPattern result = new RangeIntegerPattern(from, to);
                if (this.peekRead("/")) {
                    result = new StepIntegerPattern(result, this.parseInteger(min, max));
                }
                return result;
            }
            return new ConstantIntegerPattern(from);
        }

        private int parseInteger(int min, int max) throws ParseException {
            int result = this.scanInteger();
            if (result < min) {
                throw new ParseException("Value '" + result + "' is too small - must be '" + min + "' or greater");
            }
            if (result > max) {
                throw new ParseException("Value '" + result + "' is too large - mus be '" + max + "' or less");
            }
            return result;
        }

        private int scanInteger() throws ParseException {
            return Integer.parseInt(this.read(TokenType.INTEGER));
        }

        private int scanWeekday() throws ParseException {
            String word = this.read(TokenType.IDENTIFIER);
            Integer wd = WEEKDAY_DISPLAY_NAMES.get(word);
            if (wd == null) {
                throw new ParseException("Invalid weekday '" + word + "' - valid weekdays are " + WEEKDAY_DISPLAY_NAMES);
            }
            return wd;
        }

        static {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put("Sun", 1);
            m.put("Mon", 2);
            m.put("Tue", 3);
            m.put("Wed", 4);
            m.put("Thu", 5);
            m.put("Fri", 6);
            m.put("Sat", 7);
            WEEKDAY_DISPLAY_NAMES = Collections.unmodifiableMap(m);
            WEEKDAY_NAMES = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        }

        static class StepIntegerPattern
        implements IntegerPattern {
            private final IntegerPattern delegate;
            private final int step;

            StepIntegerPattern(IntegerPattern delegate, int step) {
                this.delegate = delegate;
                this.step = step;
            }

            @Override
            public boolean matches(int subject) {
                return this.delegate.matches(subject) && subject % this.step == 0;
            }

            @Override
            public int getConstant() {
                return -1;
            }

            public String toString() {
                return this.delegate + "/" + this.step;
            }
        }

        static class RangeIntegerPattern
        implements IntegerPattern {
            private final int from;
            private final int to;

            RangeIntegerPattern(int from, int to) {
                this.from = from;
                this.to = to;
            }

            @Override
            public boolean matches(int subject) {
                return this.from <= this.to ? subject >= this.from && subject <= this.to : subject >= this.to || subject <= this.from;
            }

            @Override
            public int getConstant() {
                return -1;
            }

            public String toString() {
                return this.from + "-" + this.to;
            }
        }

        static class ConstantIntegerPattern
        implements IntegerPattern {
            private final int constantValue;

            ConstantIntegerPattern(int constantValue) {
                this.constantValue = constantValue;
            }

            @Override
            public boolean matches(int subject) {
                return subject == this.constantValue;
            }

            @Override
            public int getConstant() {
                return this.constantValue;
            }

            public String toString() {
                return String.valueOf(this.constantValue);
            }
        }

        static interface IntegerPattern {
            public static final IntegerPattern ANY = new IntegerPattern(){

                @Override
                public boolean matches(int subject) {
                    return true;
                }

                @Override
                public int getConstant() {
                    return -1;
                }

                public String toString() {
                    return "*";
                }
            };
            public static final IntegerPattern ZERO = new ConstantIntegerPattern(0);

            public boolean matches(int var1);

            public int getConstant();
        }
    }

    private static enum ScannerState {
        IN_TIME_PATTERN;

    }

    private static enum TokenType {
        INTEGER,
        IDENTIFIER,
        OPERATOR,
        SPACE,
        BEFORE_TIME_PATTERN;

    }
}

