/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.AssertionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class MavenUtil {
    private MavenUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMavenArtifactVersion(String groupId, String artifactId) throws IOException {
        Properties p;
        String resourceName = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new IllegalStateException("Resource \"" + resourceName + "\" not found - cannot determine maven version");
        }
        try {
            p = new Properties();
            p.load(is);
            is.close();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        String version = p.getProperty("version");
        if (version == null) {
            throw new IllegalStateException("Version property missing from resource \"" + resourceName + "\"");
        }
        return version;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

