/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ActiveSocketOutputStream
extends OutputStream {
    private final InetSocketAddress remoteAddress;
    @Nullable
    private final InetSocketAddress localAddress;
    @Nullable
    private Socket socket;
    @Nullable
    private OutputStream socketOutputStream;
    @Nullable
    private Runnable reconnector = RunnableUtil.sparingRunnable((Runnable)new Runnable(){

        @Override
        public void run() {
            ActiveSocketOutputStream.this.reconnect();
        }
    }, (Producer)ProducerUtil.every((long)10000L));
    private static final long RECONNECT_INTERVAL = 10000L;
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int SO_TIMEOUT = 1000;

    public ActiveSocketOutputStream(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public ActiveSocketOutputStream(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public ActiveSocketOutputStream(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = null;
        this.reconnect();
    }

    public ActiveSocketOutputStream(InetSocketAddress remoteAddress, @Nullable InetSocketAddress localAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.reconnect();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(@Nullable byte[] b, int off, int len) throws IOException {
        Runnable r = this.reconnector;
        if (r == null) {
            throw new IOException("closed");
        }
        r.run();
        if (this.socketOutputStream != null) {
            try {
                this.socketOutputStream.write(b, off, len);
            }
            catch (IOException e) {
                Socket s = this.socket;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.socketOutputStream = null;
                this.socket = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socketOutputStream = null;
        this.socket = null;
        this.reconnector = null;
    }

    private void reconnect() {
        if (this.socket == null) {
            OutputStream socketOutputStream;
            Socket socket;
            try {
                socket = new Socket();
                socket.setReuseAddress(true);
                socket.setSoTimeout(1000);
                if (this.localAddress != null) {
                    socket.bind(this.localAddress);
                }
                socket.connect(new InetSocketAddress(this.remoteAddress.getAddress(), this.remoteAddress.getPort()), 1000);
                socketOutputStream = socket.getOutputStream();
            }
            catch (IOException e) {
                return;
            }
            this.socket = socket;
            this.socketOutputStream = socketOutputStream;
        }
    }
}

