/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.LinearMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class MapUtil {
    public static final SortedMap EMPTY_SORTED_MAP = new EmptySortedMap();

    private MapUtil() {
    }

    public static <K, V> Map<K, V> map(Object ... keyValuePairs) {
        int n = keyValuePairs.length;
        if ((n & 1) == 1) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            return Collections.emptyMap();
        }
        if (n == 2) {
            return Collections.singletonMap(keyValuePairs[0], keyValuePairs[1]);
        }
        AbstractMap result = n <= 8 ? new LinearMap(n / 2) : new HashMap(n);
        int i = 0;
        while (i < n) {
            if (result.put(keyValuePairs[i++], keyValuePairs[i++]) == null) continue;
            throw new IllegalArgumentException("Duplicate key '" + keyValuePairs[i - 2]);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        int n = keys.length;
        assert (n == values.length);
        if (n == 0) {
            return Collections.emptyMap();
        }
        if (n == 1) {
            return Collections.singletonMap(keys[0], values[0]);
        }
        AbstractMap result = n <= 4 ? new LinearMap(n) : new HashMap(2 * n);
        for (int i = 0; i < n; ++i) {
            if (result.put(keys[i], values[i]) == null) continue;
            throw new IllegalArgumentException("Duplicate key '" + keys[i]);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> HashMap<K, V> hashMapOf(Map.Entry<? extends K, ? extends V> ... entries) {
        return MapUtil.putAll(new HashMap(4 * entries.length / 3), entries);
    }

    public static <K, V> HashMap<K, V> hashMapOf(int initialCapacity, Map.Entry<? extends K, ? extends V> ... entries) {
        return MapUtil.putAll(new HashMap(initialCapacity), entries);
    }

    public static <K, V> TreeMap<K, V> treeMapOf(Map.Entry<? extends K, ? extends V> ... entries) {
        return MapUtil.putAll(new TreeMap(), entries);
    }

    public static <K, V, M extends Map<K, V>> M putAll(M subject, Map.Entry<? extends K, ? extends V> ... entries) {
        int size = subject.size();
        for (Map.Entry<K, V> entry : entries) {
            K key = entry.getKey();
            V value = entry.getValue();
            V previousValue = subject.put(key, value);
            if (subject.size() <= size) {
                throw new IllegalArgumentException("Duplicate key \"" + key + "\" (offending values are \"" + previousValue + "\" and \"" + value + "\")");
            }
            ++size;
        }
        return subject;
    }

    public static <K, V, M extends Map<K, V>> M putAll(M subject, boolean allowDuplicateKeys, Map.Entry<? extends K, ? extends V> ... entries) {
        if (allowDuplicateKeys) {
            for (Map.Entry<K, V> entry : entries) {
                subject.put(entry.getKey(), entry.getValue());
            }
        } else {
            MapUtil.putAll(subject, entries);
        }
        return subject;
    }

    public static <K, V> Map.Entry<K, V> entry(final K key, final V initialValue) {
        return new Map.Entry<K, V>(){
            @Nullable
            V value;
            {
                this.value = initialValue;
            }

            @Override
            @Nullable
            public K getKey() {
                return key;
            }

            @Override
            @Nullable
            public V getValue() {
                return this.value;
            }

            @Override
            @Nullable
            public V setValue(@Nullable V value) {
                Object result = this.value;
                this.value = value;
                return result;
            }

            public String toString() {
                return key + " => " + this.value;
            }
        };
    }

    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return EMPTY_SORTED_MAP;
    }

    @NotNullByDefault(value=false)
    public static <K, V> Map<K, V> combine(final Map<K, V> map1, final Map<? extends K, ? extends V> map2) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public boolean containsKey(Object key) {
                return map1.containsKey(key) || map2.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map1.containsValue(value) || map2.containsValue(value);
            }

            @Override
            public V get(Object key) {
                Object value = map1.get(key);
                return value != null || map1.containsKey(key) ? value : map2.get(key);
            }

            @Override
            public boolean isEmpty() {
                return map1.isEmpty() && map2.isEmpty();
            }

            @Override
            public V put(K key, V value) {
                return map1.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                map1.putAll(map);
            }

            @Override
            public int size() {
                int result = map1.size();
                for (Object key : map2.keySet()) {
                    if (map1.containsKey(key)) continue;
                    ++result;
                }
                return result;
            }
        };
    }

    @NotNullByDefault(value=false)
    public static <K, V> Map<K, V> augment(final Map<K, V> delegate, final K extraKey, final V extraValue) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("put");
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                throw new UnsupportedOperationException("putAll");
            }

            @Override
            public boolean containsKey(Object key) {
                return MapUtil.equal(key, extraKey) || delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return delegate.containsValue(value) || !delegate.containsKey(extraKey) && ObjectUtil.equals((Object)value, (Object)extraValue);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                return delegate.containsKey(extraKey) ? delegate.size() : delegate.size() + 1;
            }

            @Override
            public V get(Object key) {
                return delegate.containsKey(key) ? delegate.get(key) : (ObjectUtil.equals((Object)key, (Object)extraKey) ? extraValue : null);
            }
        };
    }

    @NotNullByDefault(value=false)
    public static <K, V> Map<K, V> override(final Map<K, V> delegate, final K extraKey, final V extraValue) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("put");
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                throw new UnsupportedOperationException("putAll");
            }

            @Override
            public boolean containsKey(Object key) {
                return MapUtil.equal(key, extraKey) || delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                if (ObjectUtil.equals((Object)value, (Object)extraValue)) {
                    return true;
                }
                for (Map.Entry e : delegate.entrySet()) {
                    if (!ObjectUtil.equals(e.getValue(), (Object)value) || ObjectUtil.equals(e.getKey(), (Object)extraKey)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                return delegate.containsKey(extraKey) ? delegate.size() : delegate.size() + 1;
            }

            @Override
            public V get(Object key) {
                return ObjectUtil.equals((Object)key, (Object)extraKey) ? extraValue : delegate.get(key);
            }
        };
    }

    @Deprecated
    public static boolean equal(@Nullable Object o1, @Nullable Object o2) {
        return ObjectUtil.equals((Object)o1, (Object)o2);
    }

    @Deprecated
    public static <K, V> Map<K, V> fromMappings(Object ... keysAndValues) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            m.put(keysAndValues[i++], keysAndValues[i++]);
        }
        return Collections.unmodifiableMap(m);
    }

    public static <K, V, I> Map<K, V> lazyMap(final Map<K, Function<I, V>> valueGetters, final @Nullable I in) {
        return new AbstractMap<K, V>(){
            @Nullable
            private Set<K> keySet;
            @Nullable
            private Collection<V> values;
            @Nullable
            private Set<Map.Entry<K, V>> entrySet;

            @Override
            public int size() {
                return valueGetters.size();
            }

            @Override
            public Set<K> keySet() {
                Set result = this.keySet;
                return result != null ? result : (this.keySet = this.keySet2());
            }

            @Override
            public boolean isEmpty() {
                return valueGetters.isEmpty();
            }

            @Override
            @NotNullByDefault(value=false)
            public V get(Object key) {
                Function valueGetter = (Function)valueGetters.get(key);
                if (valueGetter == null) {
                    return null;
                }
                return valueGetter.call(in);
            }

            @Override
            public Collection<V> values() {
                Collection result = this.values;
                return result != null ? result : (this.values = this.values2());
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                Set result = this.entrySet;
                return result != null ? result : (this.entrySet = this.entrySet2());
            }

            private Set<K> keySet2() {
                return valueGetters.keySet();
            }

            private Collection<V> values2() {
                return new AbstractCollection<V>(){

                    @Override
                    public int size() {
                        return valueGetters.size();
                    }

                    @Override
                    public Iterator<V> iterator() {
                        return new Iterator<V>(){
                            final Iterator<Function<I, V>> it;
                            {
                                this.it = valueGetters.values().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            @NotNullByDefault(value=false)
                            public V next() {
                                return this.it.next().call(in);
                            }

                            @Override
                            public void remove() {
                                this.it.remove();
                            }
                        };
                    }
                };
            }

            private Set<Map.Entry<K, V>> entrySet2() {
                return new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public int size() {
                        return valueGetters.size();
                    }

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            final Iterator<Map.Entry<K, Function<I, V>>> it;
                            {
                                this.it = valueGetters.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                final Map.Entry e = this.it.next();
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public K getKey() {
                                        return e.getKey();
                                    }

                                    @Override
                                    @NotNullByDefault(value=false)
                                    public V getValue() {
                                        return ((Function)e.getValue()).call(in);
                                    }

                                    @Override
                                    @NotNullByDefault(value=false)
                                    public V setValue(Object value) {
                                        throw new UnsupportedOperationException("setValue");
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                this.it.remove();
                            }
                        };
                    }
                };
            }

            @Override
            @NotNullByDefault(value=false)
            public boolean containsValue(Object value) {
                for (Function valueGetter : valueGetters.values()) {
                    if (!ObjectUtil.equals((Object)value, (Object)valueGetter.call(in))) continue;
                    return true;
                }
                return false;
            }

            @Override
            @NotNullByDefault(value=false)
            public boolean containsKey(Object key) {
                return valueGetters.containsKey(key);
            }

            @Override
            @NotNullByDefault(value=false)
            public V put(K key, V value) {
                throw new UnsupportedOperationException("put");
            }

            @Override
            @NotNullByDefault(value=false)
            public void putAll(Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException("putAll");
            }

            @Override
            @NotNullByDefault(value=false)
            public V remove(Object key) {
                Function valueGetter = (Function)valueGetters.remove(key);
                if (valueGetter == null) {
                    return null;
                }
                return valueGetter.call(in);
            }

            @Override
            public void clear() {
                valueGetters.clear();
            }
        };
    }

    @NotNullByDefault(value=false)
    private static class EmptySortedMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return EMPTY_SORTED_MAP;
        }

        public SortedMap headMap(Object toKey) {
            return EMPTY_SORTED_MAP;
        }

        public SortedMap tailMap(Object fromKey) {
            return EMPTY_SORTED_MAP;
        }

        public Object firstKey() {
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Collection values() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SortedMap && ((SortedMap)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

