/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;

public class ThreadBenchmark {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final MessageFormat FORMAT1 = new MessageFormat("Real={0}ms Cpu={1}ns User={2}ns");
    private static final MessageFormat FORMAT2 = new MessageFormat("{0}ms");
    private final long realTime = System.currentTimeMillis();
    private long cpuTime;
    private long userTime;

    public ThreadBenchmark() {
        if (THREAD_MX_BEAN.isCurrentThreadCpuTimeSupported()) {
            this.cpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
            this.userTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
        }
    }

    public double getRealTime() {
        return 0.001 * (double)(System.currentTimeMillis() - this.realTime);
    }

    public double getCpuTime() {
        return 1.0E-9 * (double)(THREAD_MX_BEAN.getCurrentThreadCpuTime() - this.cpuTime);
    }

    public double getUserTime() {
        return 1.0E-9 * (double)(THREAD_MX_BEAN.getCurrentThreadUserTime() - this.userTime);
    }

    public String getMessage() {
        if (THREAD_MX_BEAN.isCurrentThreadCpuTimeSupported()) {
            return FORMAT1.format(new Object[]{System.currentTimeMillis() - this.realTime, THREAD_MX_BEAN.getCurrentThreadCpuTime() - this.cpuTime, THREAD_MX_BEAN.getCurrentThreadUserTime() - this.userTime});
        }
        return FORMAT2.format(System.currentTimeMillis() - this.realTime);
    }
}

