/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatelessScanner<TT extends Enum<TT>>
extends AbstractScanner<TT> {
    private final List<Rule<TT>> rules = new ArrayList<Rule<TT>>();

    public void addRule(String regex, TT tokenType) {
        this.rules.add(new Rule<TT>(regex, tokenType));
    }

    @Override
    @Nullable
    public AbstractScanner.Token<TT> produce() throws ScanException {
        int length = this.cs.length();
        if (this.offset == length) {
            return null;
        }
        for (Rule<TT> rule : this.rules) {
            Matcher matcher = rule.regex.matcher(this.cs);
            matcher.useTransparentBounds(true);
            matcher.region(this.offset, length);
            if (!matcher.lookingAt()) continue;
            this.previousTokenOffset = this.offset;
            this.offset = matcher.end();
            int gc = matcher.groupCount();
            String[] captured = new String[gc];
            for (int i = 0; i < gc; ++i) {
                captured[i] = matcher.group(i + 1);
            }
            return new AbstractScanner.Token(rule.tokenType, matcher.group(), captured);
        }
        throw new ScanException("Unexpected character \"" + this.cs.charAt(this.offset) + "\" at offset " + this.offset + " of input string " + (this.cs.length() > 100 ? "\"" + this.cs.subSequence(0, 100) + "\"..." : "\"" + this.cs + "\""));
    }

    private static class Rule<TT extends Enum<TT>> {
        final TT tokenType;
        final Pattern regex;

        Rule(String regex, TT tokenType) {
            this.regex = Pattern.compile(regex);
            this.tokenType = tokenType;
        }
    }
}

