/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Substitutor<EX extends Throwable>
implements TransformerWhichThrows<CharSequence, CharSequence, EX> {
    public static final int DEFAULT_LOOKBEHIND_LIMIT = 10;
    private final Pattern pattern;
    private final FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer;
    private final int lookBehindLimit;
    StringBuilder buffer = new StringBuilder();
    int start;
    private int substitutionCount;
    private int offsetDelta;

    @Deprecated
    public Substitutor(Pattern pattern, FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer) {
        this(pattern, matchReplacer, 10);
    }

    @Deprecated
    public Substitutor(Pattern pattern, FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer, int lookBehindLimit) {
        this.pattern = pattern;
        this.matchReplacer = matchReplacer;
        this.lookBehindLimit = lookBehindLimit;
    }

    public static <EX extends Throwable> Substitutor<EX> create(Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer) {
        return Substitutor.create(pattern, matchReplacer, 10);
    }

    public static <EX extends Throwable> Substitutor<EX> create(Pattern pattern, final FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer, int lookBehindLimit) {
        Substitutor[] s;
        Substitutor<EX> result = new Substitutor<EX>(pattern, new FunctionWhichThrows<Matcher, CharSequence, EX>(){

            @Nullable
            public CharSequence call(final @Nullable Matcher m) throws Throwable {
                assert (m != null);
                return (CharSequence)matchReplacer.call((Object)new MatchResult(){

                    @Override
                    public int start(int group) {
                        return m.start(group) + s[0].offsetDelta;
                    }

                    @Override
                    public int start() {
                        return m.start() + s[0].offsetDelta;
                    }

                    @Override
                    public int groupCount() {
                        return m.groupCount();
                    }

                    @Override
                    public String group(int group) {
                        return m.group(group);
                    }

                    @Override
                    public String group() {
                        return m.group();
                    }

                    @Override
                    public int end(int group) {
                        return m.end(group) + s[0].offsetDelta;
                    }

                    @Override
                    public int end() {
                        return m.end() + s[0].offsetDelta;
                    }

                    public String toString() {
                        String s = "[match(" + m.start() + '-' + m.end() + ")=" + this.group();
                        for (int i = 1; i <= this.groupCount(); ++i) {
                            s = s + ", group#" + i + '(' + m.start(i) + '-' + m.end(i) + ")=" + m.group(i);
                        }
                        s = s + ']';
                        return s;
                    }
                });
            }
        }, lookBehindLimit);
        s = new Substitutor[]{result};
        return result;
    }

    public CharSequence transform(CharSequence in) throws EX {
        if (in.length() == 0) {
            return this.flush();
        }
        this.buffer.append(in);
        StringBuilder result = new StringBuilder();
        Matcher m = this.pattern.matcher(this.buffer);
        m.useTransparentBounds(true);
        m.useAnchoringBounds(false);
        while (true) {
            m.region(this.start, this.buffer.length());
            if (m.lookingAt()) {
                if (m.hitEnd()) break;
                CharSequence replacement = (CharSequence)this.matchReplacer.call((Object)m);
                if (replacement == null) {
                    result.append(this.buffer.charAt(this.start++));
                    continue;
                }
                result.append(replacement);
                ++this.substitutionCount;
                if (m.end() == m.start()) {
                    result.append(this.buffer.charAt(this.start++));
                    continue;
                }
                this.start = m.end();
                continue;
            }
            if (m.hitEnd() || this.start == this.buffer.length()) break;
            result.append(this.buffer.charAt(this.start++));
        }
        if (this.start > this.lookBehindLimit) {
            this.buffer.delete(0, this.start - this.lookBehindLimit);
            this.start = this.lookBehindLimit;
        }
        if (this.buffer.capacity() > 10 * this.buffer.length()) {
            this.buffer.trimToSize();
        }
        return result.toString();
    }

    public int substitutionCount() {
        return this.substitutionCount;
    }

    private CharSequence flush() throws EX {
        if (this.buffer.length() == 0) {
            return "";
        }
        Matcher m = this.pattern.matcher(this.buffer);
        m.useTransparentBounds(true);
        m.useAnchoringBounds(false);
        m.region(this.start, this.buffer.length());
        if (!m.find(this.start)) {
            String result = this.buffer.substring(this.start);
            this.buffer.setLength(0);
            this.start = 0;
            return result;
        }
        StringBuilder result = new StringBuilder();
        do {
            CharSequence replacement;
            if ((replacement = (CharSequence)this.matchReplacer.call((Object)m)) != null) {
                result.append(this.buffer, this.start, m.start()).append(replacement);
                this.start = m.end();
                ++this.substitutionCount;
            }
            if (m.start() != m.end()) continue;
            if (this.start == this.buffer.length()) break;
            result.append(this.buffer.charAt(this.start++));
        } while (m.find(this.start));
        result.append(this.buffer, this.start, this.buffer.length());
        this.buffer.setLength(0);
        this.start = 0;
        return result.toString();
    }
}

