/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.TransformingFilterReader;
import de.unkrig.commons.io.TransformingFilterWriter;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Substitutor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternUtil {
    public static final Function<MatchResult, String> SYSTEM_PROPERTY_MATCH_REPLACER = new Function<MatchResult, String>(){

        @Nullable
        public String call(@Nullable MatchResult matchResult) {
            assert (matchResult != null);
            return System.getProperty(matchResult.group(1));
        }
    };

    private PatternUtil() {
    }

    @Deprecated
    public static Function<MatchResult, String> constantReplacer(@Nullable String string) {
        return PatternUtil.constantMatchReplacer(string);
    }

    public static Function<MatchResult, String> constantMatchReplacer(final @Nullable String string) {
        return new Function<MatchResult, String>(){

            @Nullable
            public String call(@Nullable MatchResult matchResult) {
                return string;
            }
        };
    }

    @Deprecated
    public static <EX extends Throwable> FunctionWhichThrows<MatchResult, String, ? extends EX> replacementStringReplacer(String replacementString) {
        return PatternUtil.replacementStringMatchReplacer(replacementString);
    }

    public static <EX extends Throwable> FunctionWhichThrows<MatchResult, String, ? extends EX> replacementStringMatchReplacer(final String replacementString) {
        return new FunctionWhichThrows<MatchResult, String, EX>(){

            @Nullable
            public String call(@Nullable MatchResult matchResult) {
                assert (matchResult != null);
                StringBuffer result = new StringBuffer();
                int idx = 0;
                while (idx < replacementString.length()) {
                    char c = replacementString.charAt(idx);
                    if (c == '\\') {
                        result.append(replacementString.charAt(++idx));
                        ++idx;
                        continue;
                    }
                    if (c == '$') {
                        String group;
                        int nextDigit;
                        int referenceNumber;
                        if ((referenceNumber = replacementString.charAt(++idx) - 48) < 0 || referenceNumber > 9) {
                            throw new IllegalArgumentException("Illegal group reference");
                        }
                        ++idx;
                        while (idx < replacementString.length() && (nextDigit = replacementString.charAt(idx) - 48) >= 0 && nextDigit <= 9) {
                            int newRefNum = referenceNumber * 10 + nextDigit;
                            if (matchResult.groupCount() < newRefNum) break;
                            referenceNumber = newRefNum;
                            ++idx;
                        }
                        if ((group = matchResult.group(referenceNumber)) == null) continue;
                        result.append(group);
                        continue;
                    }
                    result.append(c);
                    ++idx;
                }
                return result.toString();
            }
        };
    }

    @Deprecated
    public static Function<MatchResult, String> systemPropertyReplacer() {
        return SYSTEM_PROPERTY_MATCH_REPLACER;
    }

    public static long replaceAll(Reader in, Pattern pattern, String replacementString, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, pattern, PatternUtil.replacementStringMatchReplacer(replacementString), out, 8192);
    }

    public static long replaceSystemProperties(Reader in, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, Pattern.compile("\\$\\{([^}]+)}", 8), SYSTEM_PROPERTY_MATCH_REPLACER, out, 4096);
    }

    public static <EX extends Throwable> String replaceSome(Matcher matcher, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer) throws EX {
        matcher.reset();
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            CharSequence replacement = (CharSequence)matchReplacer.call((Object)matcher);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement.toString()));
            }
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static <EX extends Throwable> int replaceSome(Reader in, Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer, Appendable out, int bufferCapacity) throws IOException, EX {
        Substitutor<EX> substitutor = Substitutor.create(pattern, matchReplacer);
        IoUtil.copyAndTransform((Reader)in, substitutor, (Appendable)out, (int)bufferCapacity);
        return substitutor.substitutionCount();
    }

    public static Reader replaceAllFilterReader(Reader delegate, Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer) {
        return TransformingFilterReader.create((Reader)delegate, Substitutor.create(pattern, matchReplacer));
    }

    public static Writer replaceAllFilterWriter(Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer, Appendable delegate) {
        return TransformingFilterWriter.create(Substitutor.create(pattern, matchReplacer), (Appendable)delegate);
    }

    public static <EX extends Throwable> Substitutor<EX> substitutor(Pattern pattern, String replacementString) {
        return Substitutor.create(pattern, PatternUtil.replacementStringMatchReplacer(replacementString));
    }

    public static String[] constantPrefix(String regex) {
        StringBuilder result = new StringBuilder();
        int state = 0;
        int offset = 0;
        int beforeChar1 = -1;
        int beforeChar2 = -1;
        block16: while (true) {
            char c;
            char c2 = c = offset < regex.length() ? regex.charAt(offset) : (char)'\u0000';
            if (state == 0 && "?*+{".indexOf(c) != -1) {
                if (beforeChar1 == -1) {
                    throw new PatternSyntaxException("Regex starts with quantifier", regex, offset);
                }
                offset = beforeChar1;
                result.delete(beforeChar2, Integer.MAX_VALUE);
                break;
            }
            if (state == 0 || state == 2) {
                beforeChar1 = offset;
                beforeChar2 = result.length();
            }
            switch (state) {
                case 0: {
                    if (c == '\u0000') break block16;
                    if (c == '\\') {
                        state = 1;
                        break;
                    }
                    if ("[.^$|(".indexOf(c) != -1) break block16;
                    result.append(c);
                    break;
                }
                case 1: {
                    if (c == '\u0000') {
                        throw new PatternSyntaxException("Trailing backslash", regex, offset);
                    }
                    if ("\\[.^$?*+{|(".indexOf(c) != -1) {
                        result.append(c);
                        state = 0;
                        break;
                    }
                    if (c == '0') {
                        state = 4;
                        break;
                    }
                    if (c == 'x') {
                        state = 7;
                        break;
                    }
                    if (c == 'u') {
                        state = 9;
                        break;
                    }
                    if (c == 'N') break block16;
                    if ("tnrfae".indexOf(c) != -1) {
                        result.append("\t\n\r\f\u0007\u001b".charAt("tnrfae".indexOf(c)));
                        break;
                    }
                    if (c == 'c') {
                        state = 15;
                        break;
                    }
                    if (c != 'Q') break block16;
                    state = 2;
                    break;
                }
                case 2: {
                    if (c == '\u0000') break block16;
                    if (c == '\\') {
                        state = 3;
                        break;
                    }
                    result.append(c);
                    break;
                }
                case 3: {
                    if (c == '\u0000') {
                        result.append('\\');
                        break block16;
                    }
                    if (c == 'E') {
                        state = 0;
                        break;
                    }
                    result.append('\\');
                    result.append(c);
                    state = 2;
                    break;
                }
                case 4: {
                    if (Character.digit(c, 8) == -1) {
                        throw new PatternSyntaxException("Octal literal does not start with an ocatal digit", regex, offset);
                    }
                    state = 5;
                    break;
                }
                case 5: {
                    if (Character.digit(c, 8) != -1) {
                        state = 6;
                        break;
                    }
                    result.append((char)Integer.parseInt(regex.substring(offset - 1, offset), 8));
                    state = 0;
                    --offset;
                    break;
                }
                case 6: {
                    if (Character.digit(c, 8) != -1 && "0123".indexOf(regex.charAt(offset - 2)) != -1) {
                        result.append((char)Integer.parseInt(regex.substring(offset - 2, offset + 1), 8));
                        state = 0;
                        break;
                    }
                    result.append((char)Integer.parseInt(regex.substring(offset - 2, offset), 8));
                    state = 0;
                    --offset;
                    break;
                }
                case 7: {
                    if (c == '{') {
                        state = 13;
                        break;
                    }
                    if (Character.digit(c, 16) != -1) {
                        state = 8;
                        break;
                    }
                    throw new PatternSyntaxException("Hex literal does not start with \"{\" or hex digit", regex, offset);
                }
                case 8: {
                    if (Character.digit(c, 16) == -1) {
                        throw new PatternSyntaxException("2-digit hex literal lacks second hex digit", regex, offset);
                    }
                    result.append((char)Integer.parseInt(regex.substring(offset - 1, offset + 1), 16));
                    state = 0;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    if (Character.digit(c, 16) == -1) {
                        throw new PatternSyntaxException("4-digit hex literal lacks hex digit", regex, offset);
                    }
                    ++state;
                    break;
                }
                case 12: {
                    if (Character.digit(c, 16) == -1) {
                        throw new PatternSyntaxException("4-digit hex literal lacks fourth hex digit", regex, offset);
                    }
                    result.append((char)Integer.parseInt(regex.substring(offset - 3, offset + 1), 16));
                    state = 0;
                    break;
                }
                case 13: {
                    if (Character.digit(c, 16) == -1) {
                        throw new PatternSyntaxException("Multi-digit hex literal lacks first hex digit", regex, offset);
                    }
                    state = 14;
                    break;
                }
                case 14: {
                    if (Character.digit(c, 16) != -1) break;
                    if (c == '}') {
                        int cp = Integer.parseInt(regex.substring(regex.lastIndexOf(123, offset) + 1, offset), 16);
                        result.append((char)(55296 + (cp >> 10 & 0x3FF)));
                        result.append((char)(60416 + (cp & 0x3FF)));
                        state = 0;
                        break;
                    }
                    throw new PatternSyntaxException("Unexpected character in multi-digit hex literal", regex, offset);
                }
                case 15: {
                    if (c == '\u0000') {
                        throw new PatternSyntaxException("Control character missing control character literal", regex, offset);
                    }
                    result.append((char)(c & 0x1F));
                    state = 0;
                    break;
                }
                default: {
                    throw new AssertionError(state);
                }
            }
            ++offset;
        }
        return new String[]{result.toString(), regex.substring(offset)};
    }
}

