/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.expression;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.ScannerUtil;
import de.unkrig.commons.text.scanner.StatelessScanner;
import de.unkrig.commons.text.scanner.StringScanner;

public final class Scanner {
    private Scanner() {
    }

    public static StringScanner<TokenType> stringScanner() {
        StatelessScanner<TokenType> scanner = new StatelessScanner<TokenType>();
        scanner.addRule("\\s+", TokenType.SPACE);
        scanner.addRule("(?s)/\\*.*?\\*/", TokenType.C_COMMENT);
        scanner.addRule("//.*", TokenType.CPP_COMMENT);
        scanner.addRule("(?:true|false|null|instanceof|new|boolean|byte|short|int|long|float|double|char)(?![\\p{L}\\p{Nd}_$])", TokenType.KEYWORD);
        scanner.addRule("[\\p{L}\\p{Sc}\\p{Pc}\\p{Nl}][\\p{L}\\p{Sc}\\p{Pc}\\p{Nl}\\p{Nd}\\p{Mn}\\p{Mc}]*", TokenType.IDENTIFIER);
        scanner.addRule("<<|>>>|>>|&&|\\?|:|==|=\\*|=~|!=|<=|<|>=|\\|\\||>|!|\\+|-|\\*|/|%|\\(|\\)|\\.|,|\\[|\\]|~|&|\\||\\^", TokenType.OPERATOR);
        scanner.addRule("\\d+\\.\\d*(?:[eE][+\\-]?\\d+)?[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\.\\d+(?:[eE][+\\-]?\\d+)?[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\d+[eE][+\\-]?\\d+[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\d+([eE][+\\-]?\\d+)?[fFdD]", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("0[Xx](?:[0-9a-fA-F]+)(L|l)?", TokenType.INTEGER_LITERAL);
        scanner.addRule("(?:0|[1-9]\\d*|0x\\p{XDigit}+|0[0-7]+)(L|l)?", TokenType.INTEGER_LITERAL);
        scanner.addRule("'(?:\\\\[btnfr\"'\\\\]|\\\\[0-3][0-7][0-7]|\\\\[0-7][0-7]|\\\\[0-7]|[^\\\\'])'", TokenType.CHARACTER_LITERAL);
        scanner.addRule("\"(?:\\\\[btnfr\"'\\\\]|\\\\[0-3][0-7][0-7]|\\\\[0-7][0-7]|\\\\[0-7]|[^\\\\\"])*\"", TokenType.STRING_LITERAL);
        scanner.addRule("'(?:\\\\[btnfr\"'\\\\]|\\\\[0-3][0-7][0-7]|\\\\[0-7][0-7]|\\\\[0-7]|[^\\\\'])*'", TokenType.STRING_LITERAL);
        scanner.addRule(".", TokenType.INVALID_CHARACTER);
        return ScannerUtil.filter(scanner, new Predicate<AbstractScanner.Token<TokenType>>(){

            public boolean evaluate(@Nullable AbstractScanner.Token<TokenType> token) {
                return token == null || ((TokenType)((Object)token.type)).ordinal() > TokenType.END_OF_IGNORABLES.ordinal();
            }
        });
    }

    public static Character decodeCharacterLiteral(String text) throws ScanException {
        return Character.valueOf(Scanner.unescape(text, new int[]{1}));
    }

    public static Object decodeFloatingPointLiteral(String text) {
        int len1 = text.length() - 1;
        char lc = text.charAt(len1);
        return lc == 'd' || lc == 'D' ? Double.parseDouble(text.substring(0, len1)) : (lc == 'f' || lc == 'F' ? (double)Float.parseFloat(text.substring(0, len1)) : Double.parseDouble(text));
    }

    public static Object decodeIntegerLiteral(String text) throws ScanException {
        boolean isLong;
        boolean isHex;
        int from;
        boolean isNegative;
        if (text.charAt(0) == '-') {
            isNegative = true;
            from = 1;
        } else {
            isNegative = false;
            from = 0;
        }
        if (from + 3 < text.length() && text.charAt(from) == '0' && (text.charAt(from + 1) | 0x20) == 120) {
            isHex = true;
            from += 2;
        } else {
            isHex = false;
        }
        int to = text.length();
        if ((text.charAt(to - 1) | 0x20) == 108) {
            --to;
            isLong = true;
        } else {
            isLong = false;
        }
        if (isHex) {
            int i;
            for (i = from; i < to && text.charAt(i) == '0'; ++i) {
            }
            if (isLong) {
                if (to > i + 16) {
                    throw new ScanException("Integer literal '" + text + "' out of range");
                }
                long result = 0L;
                while (i < to) {
                    result = 16L * result + (long)Character.digit(text.charAt(i), 16);
                    ++i;
                }
                return isNegative ? -result : result;
            }
            if (to > i + 8) {
                throw new ScanException("Integer literal '" + text + "' out of range");
            }
            int result = 0;
            while (i < to) {
                result = 16 * result + Character.digit(text.charAt(i), 16);
                ++i;
            }
            return isNegative ? -result : result;
        }
        try {
            int radix = text.charAt(0) == '=' ? 8 : 10;
            return isLong ? (Number)Long.valueOf(text.substring(0, to), radix) : (Number)Integer.valueOf(text, radix);
        }
        catch (NumberFormatException nfe) {
            throw new ScanException("Integer literal '" + text + "' out of range");
        }
    }

    public static String decodeStringLiteral(String text) throws ScanException {
        int len1 = text.length() - 1;
        StringBuilder sb = new StringBuilder();
        int[] off = new int[]{1};
        while (off[0] < len1) {
            sb.append(Scanner.unescape(text, off));
        }
        return sb.toString();
    }

    private static char unescape(String text, int[] offset) throws ScanException {
        int n = offset[0];
        offset[0] = n + 1;
        char c = text.charAt(n);
        if (c != '\\') {
            return c;
        }
        int n2 = offset[0];
        offset[0] = n2 + 1;
        c = text.charAt(n2);
        int idx = "btnfr\"'\\".indexOf(c);
        if (idx != -1) {
            return "\b\t\n\f\r\"'\\".charAt(idx);
        }
        if (c == '0') {
            return '\u0000';
        }
        if (c >= '1' && c <= '7') {
            char result = (char)(c - 48);
            c = text.charAt(offset[0]);
            if (c < '0' || c > '7') {
                return result;
            }
            offset[0] = offset[0] + 1;
            if ((result = (char)(8 * result + (c - 48))) >= ' ') {
                return result;
            }
            c = text.charAt(offset[0]);
            if (c < '0' || c > '7') {
                return result;
            }
            offset[0] = offset[0] + 1;
            return (char)(8 * result + (c - 48));
        }
        throw new ScanException("Invalid escape sequence '\\" + c + "'");
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public static enum TokenType {
        SPACE,
        C_COMMENT,
        CPP_COMMENT,
        END_OF_IGNORABLES,
        KEYWORD,
        IDENTIFIER,
        OPERATOR,
        CHARACTER_LITERAL,
        STRING_LITERAL,
        INTEGER_LITERAL,
        FLOATING_POINT_LITERAL,
        INVALID_CHARACTER;

    }
}

