/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.StringScanner;
import java.util.Collection;

public abstract class AbstractScanner<TT extends Enum<TT>>
implements StringScanner<TT> {
    protected CharSequence cs = "";
    protected int offset;
    protected int previousTokenOffset = -1;

    @Override
    public AbstractScanner<TT> setInput(CharSequence cs) {
        this.cs = cs;
        this.offset = 0;
        this.previousTokenOffset = -1;
        return this;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getPreviousTokenOffset() {
        return this.previousTokenOffset;
    }

    public ProducerWhichThrows<Token<TT>, ScanException> suppress(TT suppressedTokenType) {
        return ProducerUtil.filter((ProducerWhichThrows)this, (Predicate)new Predicate<Token<TT>>((Enum)suppressedTokenType){
            final /* synthetic */ Enum val$suppressedTokenType;
            {
                this.val$suppressedTokenType = enum_;
            }

            public boolean evaluate(Token<TT> token) {
                return token.type != this.val$suppressedTokenType;
            }
        });
    }

    public ProducerWhichThrows<Token<TT>, ScanException> suppress(final Collection<TT> suppressedTokenTypes) {
        return ProducerUtil.filter((ProducerWhichThrows)this, (Predicate)new Predicate<Token<TT>>(){

            public boolean evaluate(Token<TT> token) {
                return !suppressedTokenTypes.contains(token.type);
            }
        });
    }

    public String toString() {
        return "'" + this.cs + "' at offset " + this.previousTokenOffset;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public static class Token<TT extends Enum<TT>> {
        public final TT type;
        public final String text;
        public final String[] captured;
        private static final String[] DEFAULT_CAPTURED = new String[0];

        public Token(TT type, String text) {
            assert (type != null);
            assert (text != null);
            this.type = type;
            this.text = text;
            this.captured = DEFAULT_CAPTURED;
        }

        public Token(TT type, String text, String[] captured) {
            assert (type != null);
            assert (text != null);
            this.type = type;
            this.text = text;
            this.captured = captured;
        }

        public String toString() {
            return this.text;
        }
    }
}

