/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringStream<EX extends Throwable> {
    private static final String NONE;
    private final ProducerWhichThrows<? extends String, ? extends EX> producer;
    @Nullable
    private String current = NONE;
    @Nullable
    private Matcher matcher;
    @Nullable
    private String unexpectedElementExceptionMessagePrefix;

    public StringStream(ProducerWhichThrows<? extends String, ? extends EX> producer) {
        this.producer = producer;
    }

    public StringStream(ProducerWhichThrows<? extends String, ? extends EX> producer, @Nullable String unexpectedElementExceptionMessagePrefix) {
        this.producer = producer;
        this.unexpectedElementExceptionMessagePrefix = unexpectedElementExceptionMessagePrefix;
    }

    public boolean atEnd() throws EX {
        return this.next() == null;
    }

    public String peek() throws EX, UnexpectedElementException {
        String result = this.next();
        if (result == null) {
            throw new UnexpectedElementException(this.prefixMessage("Unexpected end-of-input"));
        }
        return result;
    }

    public boolean peek(String expected) throws EX {
        return expected.equals(this.next());
    }

    public boolean peek(Pattern pattern) throws EX {
        String next = this.next();
        return next != null && (this.matcher = pattern.matcher(next)).matches();
    }

    public boolean peekRead(@Nullable String expected) throws EX {
        if (!ObjectUtil.equals((Object)this.next(), (Object)expected)) {
            return false;
        }
        this.consume();
        return true;
    }

    public boolean peekRead(@Nullable Pattern pattern) throws EX {
        String next = this.next();
        if (next == null) {
            return pattern == null;
        }
        if (pattern == null) {
            return false;
        }
        this.matcher = pattern.matcher(next);
        if (!this.matcher.matches()) {
            return false;
        }
        this.consume();
        return true;
    }

    public int peekRead(String ... expected) throws EX {
        String next = this.next();
        for (int i = 0; i < expected.length; ++i) {
            if (!expected[i].equals(next)) continue;
            this.consume();
            return i;
        }
        return -1;
    }

    public String read() throws UnexpectedElementException, EX {
        String next = this.next();
        if (next == null) {
            throw new UnexpectedElementException(this.prefixMessage("Unexpected end-of-input"));
        }
        this.consume();
        return next;
    }

    public void read(String expected) throws UnexpectedElementException, EX {
        String next = this.next();
        if (next == null) {
            throw new UnexpectedElementException(this.prefixMessage("Unexpected end-of-input"));
        }
        if (!expected.equals(next)) {
            throw new UnexpectedElementException(this.prefixMessage("Expected '" + expected + "' instead of '" + next + "'"));
        }
        this.consume();
    }

    public void read(Pattern pattern) throws EX, UnexpectedElementException {
        String next = this.next();
        if (next == null) {
            throw new UnexpectedElementException(this.prefixMessage("Unexpected end-of-input"));
        }
        this.matcher = pattern.matcher(next);
        Matcher m = this.matcher;
        if (!m.matches()) {
            throw new UnexpectedElementException(this.prefixMessage("Expected '" + pattern + "' instead of '" + next + "'"));
        }
        this.consume();
    }

    public String[] readRest() throws EX {
        String next;
        ArrayList<String> l = new ArrayList<String>();
        while ((next = this.next()) != null) {
            l.add(next);
            this.consume();
        }
        return l.toArray(new String[l.size()]);
    }

    @Nullable
    public String group(int group) {
        Matcher m = this.matcher;
        assert (m != null);
        return m.group(group);
    }

    @Nullable
    private String next() throws EX {
        if (this.current == NONE) {
            this.current = (String)this.producer.produce();
        }
        return this.current;
    }

    private void consume() {
        assert (this.current != NONE);
        this.current = NONE;
    }

    private String prefixMessage(String message) {
        return this.unexpectedElementExceptionMessagePrefix == null ? message : this.unexpectedElementExceptionMessagePrefix + ": " + message;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        NONE = new String("NONE");
    }

    public static class UnexpectedElementException
    extends Exception {
        private static final long serialVersionUID = 6447492090824323597L;

        public UnexpectedElementException(String message) {
            super(message);
        }
    }
}

