/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printer;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.ProxyPrinter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.EnumSet;

public abstract class AbstractPrinter
implements Printer {
    private static final ThreadLocal<AbstractPrinter> THREAD_LOCAL_PRINTER;

    public static AbstractPrinter getContextPrinter() {
        return THREAD_LOCAL_PRINTER.get();
    }

    public static AbstractPrinter fromPrinter(Printer printer) {
        return printer instanceof AbstractPrinter ? (AbstractPrinter)printer : new ProxyPrinter(printer);
    }

    @Override
    public void error(@Nullable String message, @Nullable Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (message != null) {
                pw.print(message);
                pw.print(": ");
            }
            t.printStackTrace(pw);
            pw.flush();
            message = sw.toString().trim();
        }
        this.error(message);
    }

    @Override
    public void error(String pattern, @Nullable Throwable t, Object ... arguments) {
        this.error(AbstractPrinter.format(pattern, arguments), t);
    }

    @Override
    public void error(String pattern, Object ... arguments) {
        this.error(AbstractPrinter.format(pattern, arguments));
    }

    @Override
    public void warn(String pattern, Object ... arguments) {
        this.warn(AbstractPrinter.format(pattern, arguments));
    }

    @Override
    public void info(String pattern, Object ... arguments) {
        this.info(AbstractPrinter.format(pattern, arguments));
    }

    @Override
    public void verbose(String pattern, Object ... arguments) {
        this.verbose(AbstractPrinter.format(pattern, arguments));
    }

    @Override
    public void debug(String pattern, Object ... arguments) {
        this.debug(AbstractPrinter.format(pattern, arguments));
    }

    public final void run(Runnable runnable) {
        this.run(RunnableUtil.asRunnableWhichThrows((Runnable)runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <EX extends Throwable> void run(RunnableWhichThrows<EX> runnable) throws EX {
        AbstractPrinter previousThreadPrinter = AbstractPrinter.setContextPrinter(this);
        try {
            runnable.run();
        }
        finally {
            AbstractPrinter next = AbstractPrinter.setContextPrinter(previousThreadPrinter);
            assert (next == this);
        }
    }

    private static String format(String pattern, Object[] arguments) {
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append(pattern);
            if (arguments.length > 0) {
                sb.append(": ").append(arguments[0]);
                for (int i = 1; i < arguments.length; ++i) {
                    sb.append(", ").append(arguments[i]);
                }
            }
            return sb.toString();
        }
    }

    public final AbstractPrinter redirectError(@Nullable Writer w) {
        return this.redirect(Level.ERROR, w);
    }

    public final AbstractPrinter redirectWarn(@Nullable Writer w) {
        return this.redirect(Level.WARN, w);
    }

    public final AbstractPrinter redirectInfo(@Nullable Writer w) {
        return this.redirect(Level.INFO, w);
    }

    public final AbstractPrinter redirectVerbose(@Nullable Writer w) {
        return this.redirect(Level.VERBOSE, w);
    }

    public final AbstractPrinter redirectDebug(@Nullable Writer w) {
        return this.redirect(Level.DEBUG, w);
    }

    public final AbstractPrinter redirect(final @Nullable Level level, @Nullable Writer writer) {
        if (level == null || writer == null) {
            return this;
        }
        final PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (level == Level.ERROR) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (level == Level.WARN) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (level == Level.INFO) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (level == Level.VERBOSE) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (level == Level.DEBUG) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    public final AbstractPrinter redirect(final @Nullable EnumSet<Level> levels, @Nullable Writer writer) {
        if (levels == null || levels.isEmpty() || writer == null) {
            return this;
        }
        final PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (levels.contains((Object)Level.ERROR)) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (levels.contains((Object)Level.WARN)) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (levels.contains((Object)Level.INFO)) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (levels.contains((Object)Level.VERBOSE)) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (levels.contains((Object)Level.DEBUG)) {
                    pw.println(message);
                } else {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    public final AbstractPrinter redirectError(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> errorConsumer) {
        return this.redirect(Level.ERROR, errorConsumer);
    }

    public final AbstractPrinter redirectWarn(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> warnConsumer) {
        return this.redirect(Level.WARN, warnConsumer);
    }

    public final AbstractPrinter redirectInfo(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> infoConsumer) {
        return this.redirect(Level.INFO, infoConsumer);
    }

    public final AbstractPrinter redirectVerbose(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> verboseConsumer) {
        return this.redirect(Level.VERBOSE, verboseConsumer);
    }

    public final AbstractPrinter redirectDebug(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> debugConsumer) {
        return this.redirect(Level.DEBUG, debugConsumer);
    }

    public final AbstractPrinter redirect(final @Nullable Level level, final @Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> messageConsumer) {
        if (level == null || messageConsumer == null) {
            return this;
        }
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (level == Level.ERROR) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (level == Level.WARN) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (level == Level.INFO) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (level == Level.VERBOSE) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (level == Level.DEBUG) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    public final AbstractPrinter redirect(final @Nullable EnumSet<Level> levels, final @Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> messageConsumer) {
        if (levels == null || levels.isEmpty() || messageConsumer == null) {
            return this;
        }
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (levels.contains((Object)Level.ERROR)) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (levels.contains((Object)Level.WARN)) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (levels.contains((Object)Level.INFO)) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (levels.contains((Object)Level.VERBOSE)) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (levels.contains((Object)Level.DEBUG)) {
                    if (message != null) {
                        messageConsumer.consume((Object)message);
                    }
                } else {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    public final AbstractPrinter discardError(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> errorConsumer) {
        return this.discard(Level.ERROR);
    }

    public final AbstractPrinter discardWarn(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> warnConsumer) {
        return this.discard(Level.WARN);
    }

    public final AbstractPrinter discardInfo(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> infoConsumer) {
        return this.discard(Level.INFO);
    }

    public final AbstractPrinter discardVerbose(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> verboseConsumer) {
        return this.discard(Level.VERBOSE);
    }

    public final AbstractPrinter discardDebug(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> debugConsumer) {
        return this.discard(Level.DEBUG);
    }

    public final AbstractPrinter discard(final @Nullable Level level) {
        if (level == null) {
            return this;
        }
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (level != Level.ERROR) {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (level != Level.WARN) {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (level != Level.INFO) {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (level != Level.VERBOSE) {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (level != Level.DEBUG) {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    public final AbstractPrinter discard(final @Nullable EnumSet<Level> levels) {
        if (levels == null || levels.isEmpty()) {
            return this;
        }
        return new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                if (!levels.contains((Object)Level.ERROR)) {
                    AbstractPrinter.this.error(message);
                }
            }

            @Override
            public void warn(@Nullable String message) {
                if (!levels.contains((Object)Level.WARN)) {
                    AbstractPrinter.this.warn(message);
                }
            }

            @Override
            public void info(@Nullable String message) {
                if (!levels.contains((Object)Level.INFO)) {
                    AbstractPrinter.this.info(message);
                }
            }

            @Override
            public void verbose(@Nullable String message) {
                if (!levels.contains((Object)Level.VERBOSE)) {
                    AbstractPrinter.this.verbose(message);
                }
            }

            @Override
            public void debug(@Nullable String message) {
                if (!levels.contains((Object)Level.DEBUG)) {
                    AbstractPrinter.this.debug(message);
                }
            }
        };
    }

    private static AbstractPrinter setContextPrinter(AbstractPrinter printer) {
        AbstractPrinter previous = THREAD_LOCAL_PRINTER.get();
        THREAD_LOCAL_PRINTER.set(printer);
        return previous;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        THREAD_LOCAL_PRINTER = new InheritableThreadLocal<AbstractPrinter>(){

            @Override
            protected AbstractPrinter initialValue() {
                return Printers.DEFAULT_PRINTER;
            }
        };
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        VERBOSE,
        DEBUG;

    }
}

