/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatefulScanner<TT extends Enum<TT>, S extends Enum<S>>
extends AbstractScanner<TT> {
    @Nullable
    public final EnumSet<S> ANY_STATE = null;
    @Nullable
    public final S REMAIN = null;
    private final List<Rule<TT, S>> defaultStateRules;
    private final Map<S, List<Rule<TT, S>>> nonDefaultStateRules;
    private List<Rule<TT, S>> currentStateRules;

    public StatefulScanner(Class<S> states) {
        this.defaultStateRules = new ArrayList<Rule<TT, S>>();
        this.nonDefaultStateRules = new HashMap<S, List<Rule<TT, S>>>();
        this.currentStateRules = this.defaultStateRules;
        for (Enum state : (Enum[])states.getEnumConstants()) {
            this.nonDefaultStateRules.put(state, new ArrayList());
        }
    }

    public StatefulScanner(StatefulScanner<TT, S> that) {
        this.defaultStateRules = that.defaultStateRules;
        this.nonDefaultStateRules = that.nonDefaultStateRules;
        this.currentStateRules = this.defaultStateRules;
    }

    public void addRule(String regex, TT tokenType) {
        this.addRule(regex, tokenType, this.defaultStateRules);
    }

    public void addRule(String regex, TT tokenType, S nextState) {
        this.addRule(regex, tokenType, this.nonDefaultStateRules.get(nextState));
    }

    public void addRule(S state, String regex, TT tokenType) {
        this.addRule(EnumSet.of(state), regex, tokenType);
    }

    public void addRule(@Nullable EnumSet<S> states, String regex, TT tokenType) {
        Rule<TT, S> rule = new Rule<TT, S>(regex, tokenType, this.defaultStateRules);
        if (states == null) {
            for (List<Rule<TT, S>> rules : this.nonDefaultStateRules.values()) {
                rules.add(rule);
            }
            this.defaultStateRules.add(rule);
        } else {
            for (Enum s : states) {
                this.nonDefaultStateRules.get(s).add(rule);
            }
        }
    }

    public void addRule(S state, String regex, TT tokenType, @Nullable S nextState) {
        this.addRule(EnumSet.of(state), regex, tokenType, nextState);
    }

    public void addRule(@Nullable EnumSet<S> states, String regex, TT tokenType, @Nullable S nextState) {
        if (nextState != this.REMAIN) {
            Rule<TT, S> rule = new Rule<TT, S>(regex, tokenType, this.nonDefaultStateRules.get(nextState));
            if (states == null) {
                for (List<Rule<TT, S>> rules : this.nonDefaultStateRules.values()) {
                    rules.add(rule);
                }
                this.defaultStateRules.add(rule);
            } else {
                for (Enum s : states) {
                    this.nonDefaultStateRules.get(s).add(rule);
                }
            }
        } else if (states == null) {
            for (List<Rule<TT, S>> rules : this.nonDefaultStateRules.values()) {
                rules.add(new Rule<TT, S>(regex, tokenType, rules));
            }
            this.defaultStateRules.add(new Rule<TT, S>(regex, tokenType, this.defaultStateRules));
        } else {
            for (Enum s : states) {
                List<Rule<TT, S>> rules = this.nonDefaultStateRules.get(s);
                rules.add(new Rule<TT, S>(regex, tokenType, rules));
            }
        }
    }

    @Nullable
    public S getCurrentState() {
        if (this.currentStateRules == this.defaultStateRules) {
            return null;
        }
        for (Map.Entry<S, List<Rule<TT, S>>> e : this.nonDefaultStateRules.entrySet()) {
            Enum state = (Enum)e.getKey();
            List<Rule<TT, S>> rules = e.getValue();
            if (rules != this.currentStateRules) continue;
            return (S)state;
        }
        throw new AssertionError(this.currentStateRules);
    }

    public void setCurrentState(@Nullable S newState) {
        this.currentStateRules = newState == null ? this.defaultStateRules : this.nonDefaultStateRules.get(newState);
    }

    @Override
    @Nullable
    public AbstractScanner.Token<TT> produce() throws ScanException {
        int length = this.cs.length();
        if (this.offset == length) {
            return null;
        }
        for (Rule<TT, S> rule : this.currentStateRules) {
            String[] captured;
            Matcher matcher = rule.regex.matcher(this.cs);
            matcher.region(this.offset, length);
            if (!matcher.lookingAt()) continue;
            this.currentStateRules = rule.nextStateRules;
            this.previousTokenOffset = this.offset;
            this.offset = matcher.end();
            int gc = matcher.groupCount();
            if (gc == 0) {
                captured = null;
            } else {
                captured = new String[gc];
                for (int i = 0; i < gc; ++i) {
                    captured[i] = matcher.group(i + 1);
                }
            }
            return new AbstractScanner.Token(rule.tokenType, matcher.group(), captured);
        }
        String message = "Unexpected character \"" + this.cs.charAt(this.offset) + "\" at offset " + this.offset + " of input string \"" + this.cs + "\"";
        if (this.currentStateRules.size() == 1) {
            message = message + "; expected " + this.currentStateRules.get((int)0).tokenType;
        } else if (this.currentStateRules.size() > 1) {
            message = message + "; expected one of " + this.currentStateRules.get((int)0).tokenType;
            for (int i = 1; i < this.currentStateRules.size(); ++i) {
                message = message + ", " + this.currentStateRules.get((int)i).tokenType;
            }
        }
        throw new ScanException(message);
    }

    private void addRule(String regex, TT tokenType, List<Rule<TT, S>> nextRules) {
        Rule<TT, S> rule = new Rule<TT, S>(regex, tokenType, nextRules);
        this.defaultStateRules.add(rule);
    }

    private static class Rule<TT extends Enum<TT>, S extends Enum<S>> {
        final TT tokenType;
        final Pattern regex;
        final List<Rule<TT, S>> nextStateRules;

        Rule(String regex, TT tokenType, List<Rule<TT, S>> nextStateRules) {
            this.regex = Pattern.compile(regex);
            this.tokenType = tokenType;
            this.nextStateRules = nextStateRules;
        }

        public String toString() {
            return ">>" + this.regex + "<< => " + this.tokenType;
        }
    }
}

