/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.TransformingFilterReader;
import de.unkrig.commons.io.TransformingFilterWriter;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Substitutor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternUtil {
    public static final Function<Matcher, String> SYSTEM_PROPERTY_MATCH_REPLACER = new Function<Matcher, String>(){

        @Nullable
        public String call(@Nullable Matcher matcher) {
            assert (matcher != null);
            return System.getProperty(matcher.group(1));
        }
    };

    private PatternUtil() {
    }

    @Deprecated
    public static Function<Matcher, String> constantReplacer(@Nullable String string) {
        return PatternUtil.constantMatchReplacer(string);
    }

    public static Function<Matcher, String> constantMatchReplacer(final @Nullable String string) {
        return new Function<Matcher, String>(){

            @Nullable
            public String call(@Nullable Matcher match) {
                return string;
            }
        };
    }

    @Deprecated
    public static Function<Matcher, String> replacementStringReplacer(String replacementString) {
        return PatternUtil.replacementStringMatchReplacer(replacementString);
    }

    public static Function<Matcher, String> replacementStringMatchReplacer(final String replacementString) {
        return new Function<Matcher, String>(){

            @Nullable
            public String call(@Nullable Matcher matcher) {
                assert (matcher != null);
                StringBuffer result = new StringBuffer();
                int idx = 0;
                while (idx < replacementString.length()) {
                    char c = replacementString.charAt(idx);
                    if (c == '\\') {
                        result.append(replacementString.charAt(++idx));
                        ++idx;
                        continue;
                    }
                    if (c == '$') {
                        String group;
                        int nextDigit;
                        int referenceNumber;
                        if ((referenceNumber = replacementString.charAt(++idx) - 48) < 0 || referenceNumber > 9) {
                            throw new IllegalArgumentException("Illegal group reference");
                        }
                        ++idx;
                        while (idx < replacementString.length() && (nextDigit = replacementString.charAt(idx) - 48) >= 0 && nextDigit <= 9) {
                            int newRefNum = referenceNumber * 10 + nextDigit;
                            if (matcher.groupCount() < newRefNum) break;
                            referenceNumber = newRefNum;
                            ++idx;
                        }
                        if ((group = matcher.group(referenceNumber)) == null) continue;
                        result.append(group);
                        continue;
                    }
                    result.append(c);
                    ++idx;
                }
                return result.toString();
            }
        };
    }

    @Deprecated
    public static Function<Matcher, String> systemPropertyReplacer() {
        return SYSTEM_PROPERTY_MATCH_REPLACER;
    }

    public static long replaceAll(Reader in, Pattern pattern, String replacementString, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, pattern, PatternUtil.replacementStringMatchReplacer(replacementString), out, 8192);
    }

    public static long replaceSystemProperties(Reader in, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, Pattern.compile("\\$\\{([^}]+)}", 8), SYSTEM_PROPERTY_MATCH_REPLACER, out, 4096);
    }

    public static String replaceSome(Matcher matcher, Function<? super Matcher, ? extends CharSequence> matchReplacer) {
        matcher.reset();
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            CharSequence replacement = (CharSequence)matchReplacer.call((Object)matcher);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement.toString()));
            }
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static int replaceSome(Reader in, Pattern pattern, Function<? super Matcher, ? extends CharSequence> matchReplacer, Appendable out, int bufferCapacity) throws IOException {
        Substitutor substitutor = new Substitutor(pattern, matchReplacer);
        IoUtil.copyAndTransform((Reader)in, (Transformer)substitutor, (Appendable)out, (int)bufferCapacity);
        return substitutor.substitutionCount();
    }

    public static Reader replaceAllFilterReader(Reader delegate, Pattern pattern, Function<? super Matcher, ? extends CharSequence> matchReplacer) {
        return TransformingFilterReader.create((Reader)delegate, (Transformer)new Substitutor(pattern, matchReplacer));
    }

    public static Writer replaceAllFilterWriter(Pattern pattern, Function<? super Matcher, ? extends CharSequence> matchReplacer, Appendable delegate) {
        return TransformingFilterWriter.create((Transformer)new Substitutor(pattern, matchReplacer), (Appendable)delegate);
    }

    public static Substitutor substitutor(Pattern pattern, String replacementString) {
        return new Substitutor(pattern, PatternUtil.replacementStringMatchReplacer(replacementString));
    }
}

