/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.IncludeExclude;
import de.unkrig.commons.text.pattern.Pattern2;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Glob
implements Predicate<String> {
    public static final int REPLACEMENT = 0x40000000;
    public static final int INCLUDES_EXCLUDES = Integer.MIN_VALUE;
    public static final Glob ANY = new Glob(){

        @Override
        public boolean matches(String subject) {
            return true;
        }

        public String toString() {
            return "ANY";
        }
    };
    public static final Glob NONE = new Glob(){

        @Override
        public boolean matches(String subject) {
            return false;
        }

        public String toString() {
            return "NONE";
        }
    };

    public abstract boolean matches(String var1);

    public boolean evaluate(@Nullable String subject) {
        return subject != null && this.matches(subject);
    }

    @Nullable
    public String replace(String subject) {
        return this.matches(subject) ? subject : null;
    }

    private static Glob compileWithReplacement(String pattern, int flags) {
        String replacement;
        if ((flags & 0x40000010) == 0x40000000) {
            String[] tmp = Pattern2.parsePatternAndReplacement(pattern);
            pattern = tmp[0];
            replacement = tmp[1];
        } else {
            replacement = null;
        }
        final Glob glob = Glob.compileRegex(Pattern2.compile(pattern, flags), replacement);
        if ((flags | 0x20000000) == 0x20000000) {
            final String pattern2 = pattern;
            return new Glob(){

                @Override
                public boolean matches(String subject) {
                    return glob.matches(subject);
                }

                @Override
                public boolean evaluate(@Nullable String subject) {
                    return glob.evaluate(subject);
                }

                @Override
                @Nullable
                public String replace(String subject) {
                    return glob.replace(subject);
                }

                public String toString() {
                    return replacement == null ? pattern2 : pattern2 + "=" + replacement;
                }
            };
        }
        return glob;
    }

    public static Glob compileRegex(Pattern regex) {
        return Glob.compileRegex(regex, null);
    }

    public static Glob compileRegex(final Pattern regex, final @Nullable String replacementString) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                Matcher matcher = regex.matcher(subject);
                if (subject.isEmpty() || subject.endsWith("/") || subject.endsWith("!")) {
                    return matcher.matches() || matcher.hitEnd();
                }
                block0: while (!matcher.matches()) {
                    int i = subject.length() - 1;
                    while (true) {
                        if (i < 0) {
                            return false;
                        }
                        char c = subject.charAt(i);
                        if (c == '/' || c == '!') {
                            subject = subject.substring(0, i);
                            continue block0;
                        }
                        --i;
                    }
                    break;
                }
                return true;
            }

            @Override
            @Nullable
            public String replace(String subject) {
                Matcher matcher = regex.matcher(subject);
                if ((regex.flags() & 0x20000000) == 0 ? matcher.matches() : matcher.lookingAt()) {
                    StringBuffer sb = new StringBuffer();
                    int matchEnd = matcher.end();
                    matcher.appendReplacement(sb, replacementString == null ? "$0" : replacementString);
                    if (matchEnd == subject.length()) {
                        return sb.toString();
                    }
                    char c = subject.charAt(matchEnd);
                    if (c == '/' || c == '!') {
                        return sb.append(subject.substring(matchEnd)).toString();
                    }
                    return null;
                }
                return null;
            }

            public String toString() {
                return replacementString == null ? regex.toString() : regex + "=" + replacementString;
            }
        };
    }

    public static Glob compile(String pattern) {
        return Glob.compile(pattern, 0);
    }

    public static Glob compile(String pattern, int flags) {
        int idx;
        if ((flags & Integer.MIN_VALUE) == 0) {
            return Glob.compileWithReplacement(pattern, flags);
        }
        IncludeExclude includeExclude = new IncludeExclude();
        if (pattern.startsWith("~")) {
            idx = Pattern2.findMeta(",~", pattern, 1);
            Glob glob = Glob.compileWithReplacement(pattern.substring(1, idx), flags);
            includeExclude.addExclude(glob, true);
        } else {
            idx = Pattern2.findMeta(",~", pattern, 0);
            Glob glob = Glob.compileWithReplacement(pattern.substring(0, idx), flags);
            if (idx == pattern.length()) {
                return glob;
            }
            includeExclude.addInclude(glob, true);
        }
        while (idx != pattern.length()) {
            char c = pattern.charAt(idx++);
            int n = idx;
            idx = Pattern2.findMeta(",~", pattern, idx);
            Glob glob = Glob.compileWithReplacement(pattern.substring(n, idx), flags);
            if (c == ',') {
                includeExclude.addInclude(glob, true);
                continue;
            }
            includeExclude.addExclude(glob, true);
        }
        return includeExclude;
    }

    public static Glob and(final Glob pattern1, final Glob pattern2) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                return pattern1.matches(subject) && pattern2.matches(subject);
            }

            @Override
            @Nullable
            public String replace(String subject) {
                return pattern1.matches(subject) ? pattern2.replace(subject) : null;
            }

            public String toString() {
                return pattern1 + " && " + pattern2;
            }
        };
    }

    public static Glob or(final Glob pattern1, final Glob pattern2) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                return pattern1.matches(subject) || pattern2.matches(subject);
            }

            @Override
            @Nullable
            public String replace(String subject) {
                String replacement = pattern1.replace(subject);
                if (replacement != null) {
                    return replacement;
                }
                return pattern2.replace(subject);
            }

            public String toString() {
                return pattern1 + " || " + pattern2;
            }
        };
    }

    public static Glob and(final Predicate<? super String> predicate, final Glob pattern) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                return predicate.evaluate((Object)subject) && pattern.matches(subject);
            }

            @Override
            @Nullable
            public String replace(String subject) {
                return predicate.evaluate((Object)subject) ? pattern.replace(subject) : null;
            }

            public String toString() {
                return predicate + " && " + pattern;
            }
        };
    }

    public static Glob and(final Glob pattern, final Predicate<? super String> predicate) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                return pattern.matches(subject) && predicate.evaluate((Object)subject);
            }

            @Override
            @Nullable
            public String replace(String subject) {
                String replacement = pattern.replace(subject);
                return replacement != null && predicate.evaluate((Object)subject) ? replacement : null;
            }

            public String toString() {
                return pattern + " && " + predicate;
            }
        };
    }

    public static Glob fromPredicate(final Predicate<? super String> predicate) {
        return new Glob(){

            @Override
            public boolean matches(String subject) {
                return predicate.evaluate((Object)subject);
            }
        };
    }
}

