/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.json;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScannerUtil;
import de.unkrig.commons.text.scanner.StatefulScanner;
import de.unkrig.commons.text.scanner.StringScanner;

public final class JsonScanner {
    private JsonScanner() {
    }

    public static StringScanner<TokenType> rawStringScanner() {
        StatefulScanner<TokenType, State> scanner = new StatefulScanner<TokenType, State>(State.class);
        scanner.addRule("\\s+", TokenType.SPACE);
        scanner.addRule("//.*(?:\r|\r\n|\n)?", TokenType.CXX_COMMENT);
        scanner.addRule("/\\*.*?\\*/", TokenType.SINGLE_LINE_C_COMMENT);
        scanner.addRule("/\\*.*", TokenType.MULTI_LINE_C_COMMENT_BEGINNING, State.IN_MULTI_LINE_C_COMMENT);
        scanner.addRule(State.IN_MULTI_LINE_C_COMMENT, ".*?\\*/", TokenType.MULTI_LINE_C_COMMENT_END);
        scanner.addRule(State.IN_MULTI_LINE_C_COMMENT, ".*", TokenType.MULTI_LINE_C_COMMENT_MIDDLE, State.IN_MULTI_LINE_C_COMMENT);
        scanner.addRule("\\p{Alpha}+", TokenType.KEYWORD);
        scanner.addRule("-?[0-9.][0-9.Ee]*", TokenType.NUMBER);
        scanner.addRule("\"", TokenType.DOUBLE_QUOTE, State.IN_STRING);
        scanner.addRule(State.IN_STRING, "\\\\u\\p{XDigit}\\p{XDigit}\\p{XDigit}\\p{XDigit}", TokenType.STRING_UNICODE_ESCAPE, State.IN_STRING);
        scanner.addRule(State.IN_STRING, "\\\\.", TokenType.STRING_ESCAPE, State.IN_STRING);
        scanner.addRule(State.IN_STRING, "[^\\p{Cntrl}\"\\\\]+", TokenType.STRING_CHARS, State.IN_STRING);
        scanner.addRule(State.IN_STRING, "\"", TokenType.DOUBLE_QUOTE);
        scanner.addRule("[\\{\\}\\[\\]:,]", TokenType.OPERATOR);
        return scanner;
    }

    public static StringScanner<TokenType> stringScanner() {
        return ScannerUtil.filter(JsonScanner.rawStringScanner(), new Predicate<AbstractScanner.Token<TokenType>>(){

            public boolean evaluate(@Nullable AbstractScanner.Token<TokenType> token) {
                return token == null || ((TokenType)((Object)token.type)).ordinal() > TokenType.END_OF_IGNORABLES.ordinal();
            }
        });
    }

    private static enum State {
        IN_MULTI_LINE_C_COMMENT,
        IN_STRING;

    }

    public static enum TokenType {
        SPACE,
        CXX_COMMENT,
        SINGLE_LINE_C_COMMENT,
        MULTI_LINE_C_COMMENT_BEGINNING,
        MULTI_LINE_C_COMMENT_MIDDLE,
        MULTI_LINE_C_COMMENT_END,
        END_OF_IGNORABLES,
        OPERATOR,
        NUMBER,
        KEYWORD,
        DOUBLE_QUOTE,
        STRING_UNICODE_ESCAPE,
        STRING_ESCAPE,
        STRING_CHARS;

    }
}

