/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.expression;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.reflect.ReflectUtil;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.text.expression.AbstractExpression;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionUtil;
import de.unkrig.commons.text.expression.Parser;
import de.unkrig.commons.text.expression.Scanner;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExpressionEvaluator {
    private String[] imports = new String[]{"java.lang"};
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private final Predicate<? super String> isValidVariableName;
    public static final Set<Object> FALSES = new HashSet<Object>();

    public ExpressionEvaluator(Predicate<? super String> isValidVariableName) {
        this.isValidVariableName = isValidVariableName;
    }

    public ExpressionEvaluator(Collection<String> variableNames) {
        this.isValidVariableName = PredicateUtil.contains(variableNames);
    }

    public ExpressionEvaluator(String ... variableNames) {
        this.isValidVariableName = PredicateUtil.contains(Arrays.asList(variableNames));
    }

    public String[] getImports() {
        return (String[])this.imports.clone();
    }

    public ExpressionEvaluator setImports(String[] imports) {
        this.imports = (String[])imports.clone();
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ExpressionEvaluator setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Expression parse(String spec) throws ParseException {
        return this.parser(Scanner.stringScanner().setInput(spec)).parse();
    }

    public Expression parse(ProducerWhichThrows<? extends AbstractScanner.Token<Scanner.TokenType>, ? extends ScanException> tokenProducer) throws ParseException {
        return this.parser(tokenProducer).parse();
    }

    public <EX extends Exception> Parser<Expression, EX> parser(String spec) {
        return this.parser(Scanner.stringScanner().setInput(spec));
    }

    public <EX extends Exception> Parser<Expression, EX> parser(ProducerWhichThrows<? extends AbstractScanner.Token<Scanner.TokenType>, ? extends ScanException> tokenProducer) {
        return new Parser<Expression, EX>(tokenProducer){

            @Override
            protected Expression conditional(final Expression lhs, final Expression mhs, final Expression rhs) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.conditional(lhs.evaluate(variables), mhs.evaluate(variables), rhs.evaluate(variables));
                    }

                    public String toString() {
                        return lhs + " ? " + mhs + " : " + rhs;
                    }
                };
            }

            @Override
            protected Expression unaryOperation(final Parser.UnaryOperator operator, final Expression operand) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.unaryOperation(operator, operand.evaluate(variables));
                    }

                    public String toString() {
                        return operator.toString() + operand;
                    }
                };
            }

            @Override
            protected Expression binaryOperation(final Expression lhs, final Parser.BinaryOperator op, final Expression rhs) {
                switch (op) {
                    case LOGICAL_AND: {
                        return ExpressionUtil.logicalAnd(lhs, rhs);
                    }
                    case LOGICAL_OR: {
                        return ExpressionUtil.logicalOr(lhs, rhs);
                    }
                }
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.binaryOperation(lhs.evaluate(variables), op, rhs.evaluate(variables));
                    }

                    public String toString() {
                        return lhs + " " + (Object)((Object)op) + ' ' + rhs;
                    }
                };
            }

            @Override
            protected Expression methodInvocation(final Expression target, final String methodName, final List<Expression> arguments) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        ArrayList<Object> argumentValues = new ArrayList<Object>(arguments.size());
                        for (Expression argument : arguments) {
                            argumentValues.add(argument.evaluate(variables));
                        }
                        return ExpressionEvaluator.invokeMethod(target.evaluate(variables), methodName, argumentValues);
                    }

                    public String toString() {
                        return target + "." + methodName + '.' + '(' + StringUtil.join((Collection)arguments, (String)", ") + ')';
                    }
                };
            }

            @Override
            protected Expression staticMethodInvocation(final Class<?> target, final String methodName, final List<Expression> arguments) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        ArrayList<Object> argumentValues = new ArrayList<Object>(arguments.size());
                        for (Expression argument : arguments) {
                            argumentValues.add(argument.evaluate(variables));
                        }
                        return ExpressionEvaluator.invokeStaticMethod(target, methodName, argumentValues);
                    }

                    public String toString() {
                        return target.getName() + "." + methodName + '.' + '(' + StringUtil.join((Collection)arguments, (String)", ") + ')';
                    }
                };
            }

            @Override
            protected Expression fieldReference(final Expression target, final String fieldName) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.getAttributeValue(target.evaluate(variables), fieldName);
                    }

                    public String toString() {
                        return target + "." + fieldName;
                    }
                };
            }

            @Override
            protected Expression staticFieldReference(final Class<?> type, final String fieldName) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.getStaticAttributeValue(type, fieldName);
                    }

                    public String toString() {
                        return type.getName() + '.' + fieldName;
                    }
                };
            }

            @Override
            protected Expression parenthesized(final Expression exp) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return exp.evaluate(variables);
                    }

                    public String toString() {
                        return '(' + exp.toString() + ')';
                    }
                };
            }

            @Override
            protected Expression instanceoF(final Expression lhs, final Class<?> rhs) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.isInstanceOf(lhs.evaluate(variables), rhs);
                    }

                    public String toString() {
                        return lhs + " instanceof " + rhs;
                    }
                };
            }

            @Override
            protected Expression newClass(final Class<?> clasS, final List<Expression> arguments) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        ArrayList<Object> argumentValues = new ArrayList<Object>();
                        for (Expression argument : arguments) {
                            argumentValues.add(argument.evaluate(variables));
                        }
                        return ExpressionEvaluator.instantiateClass(clasS, argumentValues);
                    }

                    public String toString() {
                        return "new " + clasS.getName() + '(' + StringUtil.join((Collection)arguments, (String)", ") + ')';
                    }
                };
            }

            @Override
            protected Expression newArray(final Class<?> clasS, final List<Expression> dimensions) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        int n = dimensions.size();
                        int[] dimensionValues = new int[n];
                        for (int i = 0; i < n; ++i) {
                            dimensionValues[i] = ExpressionUtil.evaluateTo((Expression)dimensions.get(i), variables, Integer.class);
                        }
                        return ExpressionEvaluator.newArrayInstance(clasS, dimensionValues);
                    }

                    public String toString() {
                        int brackets = 0;
                        Class<?> c = clasS;
                        while (c.isArray()) {
                            ++brackets;
                            c = c.getComponentType();
                        }
                        StringBuilder sb = new StringBuilder(c.getName());
                        for (Expression dimension : dimensions) {
                            sb.append('[').append(dimension).append(']');
                        }
                        for (int i = 0; i < brackets; ++i) {
                            sb.append("[]");
                        }
                        return sb.toString();
                    }
                };
            }

            @Override
            protected Expression cast(final Class<?> targetClass, final Expression rhs) {
                return new AbstractExpression(){

                    @Override
                    @Nullable
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.cast(targetClass, rhs.evaluate(variables));
                    }

                    public String toString() {
                        return '(' + targetClass.getName() + ") " + rhs;
                    }
                };
            }

            @Override
            protected Expression literal(@Nullable Object o) {
                return ExpressionUtil.constantExpression(o);
            }

            @Override
            protected Expression variableReference(final String variableName) throws ParseException {
                if (!ExpressionEvaluator.this.isValidVariableName.evaluate((Object)variableName)) {
                    throw new ParseException("Unknown variable '" + variableName + "'");
                }
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) {
                        Object value = variables.get((Object)variableName);
                        if (value == null && !variables.containsKey((Object)variableName)) {
                            throw new IllegalStateException("Variable '" + variableName + "' missing");
                        }
                        return value;
                    }

                    public String toString() {
                        return variableName;
                    }
                };
            }

            @Override
            protected Expression arrayAccess(final Expression lhs, final Expression rhs) {
                return new AbstractExpression(){

                    @Override
                    public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                        return ExpressionEvaluator.arrayAccess(lhs.evaluate(variables), rhs.evaluate(variables));
                    }

                    public String toString() {
                        return lhs.toString() + '[' + rhs.toString() + ']';
                    }
                };
            }
        }.setImports(this.imports);
    }

    @Nullable
    public Object evaluate(String spec, final Mapping<String, ?> variables) throws ParseException, EvaluationException {
        return new Parser<Object, EvaluationException>(spec){

            @Override
            protected Object conditional(Object lhs, Object mhs, Object rhs) throws EvaluationException {
                return ExpressionEvaluator.conditional(lhs, mhs, rhs);
            }

            @Override
            protected Object unaryOperation(Parser.UnaryOperator operator, Object operand) throws EvaluationException {
                return ExpressionEvaluator.unaryOperation(operator, operand);
            }

            @Override
            protected Object binaryOperation(Object lhs, Parser.BinaryOperator op, Object rhs) throws EvaluationException {
                return ExpressionEvaluator.binaryOperation(lhs, op, rhs);
            }

            @Override
            protected Object methodInvocation(Object target, String methodName, List<Object> arguments) throws EvaluationException {
                return ExpressionEvaluator.invokeMethod(target, methodName, arguments);
            }

            @Override
            protected Object staticMethodInvocation(Class<?> target, String methodName, List<Object> arguments) throws EvaluationException {
                return ExpressionEvaluator.invokeStaticMethod(target, methodName, arguments);
            }

            @Override
            protected Object fieldReference(Object target, String fieldName) throws EvaluationException {
                return ExpressionEvaluator.getAttributeValue(target, fieldName);
            }

            @Override
            protected Object staticFieldReference(Class<?> type, String fieldName) throws EvaluationException {
                return ExpressionEvaluator.getStaticAttributeValue(type, fieldName);
            }

            @Override
            protected Object parenthesized(Object exp) {
                return exp;
            }

            @Override
            protected Object instanceoF(@Nullable Object lhs, Class<?> rhs) {
                return ExpressionEvaluator.isInstanceOf(lhs, rhs);
            }

            @Override
            protected Object newClass(Class<?> clasS, List<Object> arguments) throws EvaluationException {
                return ExpressionEvaluator.instantiateClass(clasS, arguments);
            }

            @Override
            protected Object newArray(Class<?> clasS, List<Object> dimensions) {
                int n = dimensions.size();
                int[] dimensionValues = new int[n];
                for (int i = 0; i < n; ++i) {
                    dimensionValues[i] = (Integer)dimensions.get(i);
                }
                return ExpressionEvaluator.newArrayInstance(clasS, dimensionValues);
            }

            @Override
            protected Object cast(Class<?> targetClass, Object rhs) throws EvaluationException {
                return ExpressionEvaluator.cast(targetClass, rhs);
            }

            @Override
            protected Object literal(Object o) {
                return o;
            }

            @Override
            protected Object variableReference(String variableName) throws ParseException {
                Object value = variables.get((Object)variableName);
                if (value == null && !variables.containsKey((Object)variableName)) {
                    throw new ParseException("Unknown variable '" + variableName + "'");
                }
                return value;
            }

            @Override
            protected Object arrayAccess(Object lhs, Object rhs) throws EvaluationException {
                return ExpressionEvaluator.arrayAccess(lhs, rhs);
            }
        }.setImports(this.imports).parse();
    }

    private static Object newArrayInstance(Class<?> type, int[] dimensionValues) {
        return Array.newInstance(type, dimensionValues);
    }

    private static boolean isInstanceOf(@Nullable Object value, Class<?> type) {
        return value != null && type.isAssignableFrom(value.getClass());
    }

    private static Object instantiateClass(Class<?> clasS, List<Object> argumentValues) throws EvaluationException {
        try {
            Constructor mostSpecificConstructor = ReflectUtil.getMostSpecificConstructor(clasS, (Class[])ReflectUtil.getTypes(argumentValues));
            return mostSpecificConstructor.newInstance(argumentValues.toArray());
        }
        catch (Exception e) {
            throw (EvaluationException)ExceptionUtil.wrap((String)("Instantiating " + clasS), (Throwable)e, EvaluationException.class);
        }
    }

    @Nullable
    private static Object cast(Class<?> targetClass, @Nullable Object operand) throws EvaluationException {
        if (operand == null) {
            return null;
        }
        if (!targetClass.isAssignableFrom(operand.getClass())) {
            throw new EvaluationException("Cannot cast '" + operand.getClass().getName() + "' to '" + targetClass.getName() + "'");
        }
        return operand;
    }

    @Nullable
    private static Object arrayAccess(Object lhs, Object rhs) throws EvaluationException {
        Object lhsv = ExpressionEvaluator.to(lhs, Object.class);
        Integer rhsv = ExpressionEvaluator.toPrimitive(rhs, Integer.TYPE);
        return Array.get(lhsv, rhsv);
    }

    public static String toString(@Nullable Object subject) {
        return subject == null ? "" : subject.toString();
    }

    @Nullable
    private static Object invokeMethod(@Nullable Object lhsv, String methodName, List<Object> argumentValues) throws EvaluationException {
        Method mostSpecificMethod;
        if (lhsv == null) {
            return null;
        }
        Class[] argumentTypes = ReflectUtil.getTypes(argumentValues);
        Class<?> clasS = lhsv.getClass();
        try {
            mostSpecificMethod = ReflectUtil.getMostSpecificMethod(clasS, (String)methodName, (Class[])argumentTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new EvaluationException(nsme);
        }
        try {
            return mostSpecificMethod.invoke(lhsv, argumentValues.toArray());
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    @Nullable
    private static Object invokeStaticMethod(Class<?> clasS, String methodName, List<Object> argumentValues) throws EvaluationException {
        Method mostSpecificMethod;
        Class[] argumentTypes = ReflectUtil.getTypes(argumentValues);
        try {
            mostSpecificMethod = ReflectUtil.getMostSpecificMethod(clasS, (String)methodName, (Class[])argumentTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new EvaluationException(nsme);
        }
        if (!Modifier.isStatic(mostSpecificMethod.getModifiers())) {
            throw new EvaluationException("Cannot invoke non-static method '" + clasS.getName() + '.' + methodName + "()' in static context");
        }
        try {
            return mostSpecificMethod.invoke(null, argumentValues.toArray());
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    @Nullable
    private static <E extends Exception> Object getAttributeValue(@Nullable Object target, String attributeName) throws EvaluationException {
        if (target == null) {
            return null;
        }
        Class<?> clasS = target.getClass();
        try {
            try {
                return clasS.getField(attributeName).get(target);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    return clasS.getMethod(attributeName, new Class[0]).invoke(target, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return clasS.getMethod(Notations.fromCamelCase(attributeName).prepend("get").toLowerCamelCase(), new Class[0]).invoke(target, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
            }
        }
        catch (Exception e) {
            throw (EvaluationException)ExceptionUtil.wrap((String)("Retrieving attribute '" + attributeName + "' of '" + clasS.getName() + "'"), (Throwable)e, EvaluationException.class);
        }
        throw new EvaluationException("'" + clasS.getName() + "' has no field '" + attributeName + "' nor a method '" + attributeName + "()' or 'get" + attributeName + "()' method");
    }

    @Nullable
    private static <E extends Exception> Object getStaticAttributeValue(Class<?> target, String attributeName) throws EvaluationException {
        try {
            try {
                return target.getField(attributeName).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    return target.getMethod(attributeName, new Class[0]).invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return target.getMethod(Notations.fromCamelCase(attributeName).prepend("get").toLowerCamelCase(), new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
            }
        }
        catch (NullPointerException npe) {
            throw new EvaluationException("Cannot retrieve nonstatic attribute '" + attributeName + "' in static context");
        }
        catch (Exception e) {
            throw (EvaluationException)ExceptionUtil.wrap((String)("Retrieving attribute '" + attributeName + "' of '" + target.getName() + "'"), (Throwable)e, EvaluationException.class);
        }
        throw new EvaluationException("'" + target.getName() + "' has no static field '" + attributeName + "' nor a static method '" + attributeName + "()' or 'get" + ExpressionEvaluator.capitalizeFirstCharacter(attributeName) + "()'");
    }

    private static String capitalizeFirstCharacter(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @Nullable
    private static Object conditional(@Nullable Object lhs, @Nullable Object mhs, @Nullable Object rhs) throws EvaluationException {
        return ExpressionEvaluator.to(lhs, Boolean.class) != false ? mhs : rhs;
    }

    @Nullable
    private static Object unaryOperation(Parser.UnaryOperator operator, @Nullable Object operand) throws EvaluationException {
        switch (operator) {
            case LOGICAL_COMPLEMENT: {
                return !ExpressionEvaluator.toBoolean(operand);
            }
            case MINUS: {
                operand = ExpressionEvaluator.unaryNumericPromotion(operand);
                if (operand == null) {
                    return null;
                }
                Class<?> clazz = operand.getClass();
                if (clazz == Integer.class) {
                    return -((Integer)operand).intValue();
                }
                if (clazz == Long.class) {
                    return -((Long)operand).longValue();
                }
                if (clazz == Float.class) {
                    return Float.valueOf(-((Float)operand).floatValue());
                }
                if (clazz == Double.class) {
                    return -((Double)operand).doubleValue();
                }
                throw new EvaluationException("'" + clazz.getName() + "' operand cannot be negated");
            }
            case BITWISE_COMPLEMENT: {
                operand = ExpressionEvaluator.unaryNumericPromotion(operand);
                if (operand == null) {
                    return null;
                }
                Class<?> clazz = operand.getClass();
                if (clazz == Integer.class) {
                    return ~((Integer)operand).intValue();
                }
                if (clazz == Long.class) {
                    return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                }
                throw new EvaluationException("'" + clazz.getName() + "' operand cannot be complemented");
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    private static Object binaryOperation(@Nullable Object lhsv, Parser.BinaryOperator op, @Nullable Object rhsv) throws EvaluationException {
        Class<?> rhsc;
        lhsv = ExpressionEvaluator.binaryNumericPromotion(lhsv, rhsv);
        rhsv = ExpressionEvaluator.binaryNumericPromotion(rhsv, lhsv);
        Class<?> lhsc = lhsv == null ? null : lhsv.getClass();
        Class<?> clazz = rhsc = rhsv == null ? null : rhsv.getClass();
        if (lhsc == Integer.class && rhsc == Integer.class) {
            int lhsi = (Integer)lhsv;
            int rhsi = (Integer)rhsv;
            switch (op) {
                case BITWISE_OR: {
                    return lhsi | rhsi;
                }
                case BITWISE_XOR: {
                    return lhsi ^ rhsi;
                }
                case BITWISE_AND: {
                    return lhsi & rhsi;
                }
                case LEFT_SHIFT: {
                    return lhsi << rhsi;
                }
                case RIGHT_SHIFT: {
                    return lhsi >> rhsi;
                }
                case RIGHT_USHIFT: {
                    return lhsi >>> rhsi;
                }
                case MULTIPLY: {
                    return lhsi * rhsi;
                }
                case DIVIDE: {
                    return lhsi / rhsi;
                }
                case MODULO: {
                    return lhsi % rhsi;
                }
                case PLUS: {
                    return lhsi + rhsi;
                }
                case MINUS: {
                    return lhsi - rhsi;
                }
            }
        } else if (lhsc == Long.class && rhsc == Long.class) {
            long lhsl = (Long)lhsv;
            long rhsl = (Long)rhsv;
            switch (op) {
                case BITWISE_OR: {
                    return lhsl | rhsl;
                }
                case BITWISE_XOR: {
                    return lhsl ^ rhsl;
                }
                case BITWISE_AND: {
                    return lhsl & rhsl;
                }
                case LEFT_SHIFT: {
                    return lhsl << (int)rhsl;
                }
                case RIGHT_SHIFT: {
                    return lhsl >> (int)rhsl;
                }
                case RIGHT_USHIFT: {
                    return lhsl >>> (int)rhsl;
                }
                case MULTIPLY: {
                    return lhsl * rhsl;
                }
                case DIVIDE: {
                    return lhsl / rhsl;
                }
                case MODULO: {
                    return lhsl % rhsl;
                }
                case PLUS: {
                    return lhsl + rhsl;
                }
                case MINUS: {
                    return lhsl - rhsl;
                }
            }
        } else if (lhsc == Float.class && rhsc == Float.class) {
            float lhsf = ((Float)lhsv).floatValue();
            float rhsf = ((Float)rhsv).floatValue();
            switch (op) {
                case MULTIPLY: {
                    return Float.valueOf(lhsf * rhsf);
                }
                case DIVIDE: {
                    return Float.valueOf(lhsf / rhsf);
                }
                case MODULO: {
                    return Float.valueOf(lhsf % rhsf);
                }
                case PLUS: {
                    return Float.valueOf(lhsf + rhsf);
                }
                case MINUS: {
                    return Float.valueOf(lhsf - rhsf);
                }
            }
        } else if (lhsc == Double.class && rhsc == Double.class) {
            double lhsd = (Double)lhsv;
            double rhsd = (Double)rhsv;
            switch (op) {
                case MULTIPLY: {
                    return lhsd * rhsd;
                }
                case DIVIDE: {
                    return lhsd / rhsd;
                }
                case MODULO: {
                    return lhsd % rhsd;
                }
                case PLUS: {
                    return lhsd + rhsd;
                }
                case MINUS: {
                    return lhsd - rhsd;
                }
            }
        }
        switch (op) {
            case GLOB: {
                return Glob.compile(ExpressionEvaluator.toString(rhsv), -536870912).replace(ExpressionEvaluator.toString(lhsv));
            }
            case REGEX: {
                return Glob.compile(ExpressionEvaluator.toString(rhsv), 0x40000020).replace(ExpressionEvaluator.toString(lhsv));
            }
            case LOGICAL_AND: {
                return ExpressionEvaluator.toBoolean(lhsv) ? rhsv : Boolean.FALSE;
            }
            case LOGICAL_OR: {
                return ExpressionEvaluator.toBoolean(lhsv) ? lhsv : rhsv;
            }
            case BITWISE_OR: {
                return ExpressionEvaluator.toBoolean(lhsv) | ExpressionEvaluator.toBoolean(rhsv);
            }
            case BITWISE_XOR: {
                return ExpressionEvaluator.toBoolean(lhsv) ^ ExpressionEvaluator.toBoolean(rhsv);
            }
            case BITWISE_AND: {
                return ExpressionEvaluator.toBoolean(lhsv) & ExpressionEvaluator.toBoolean(rhsv);
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case RIGHT_USHIFT: {
                throw new EvaluationException("Incompatible types for operator '" + (Object)((Object)op) + "' ('" + ExpressionEvaluator.className(lhsc) + "' and '" + ExpressionEvaluator.className(rhsc) + "')");
            }
            case EQUAL: {
                return ObjectUtil.equals((Object)lhsv, (Object)rhsv);
            }
            case NOT_EQUAL: {
                return !ObjectUtil.equals((Object)lhsv, (Object)rhsv);
            }
            case LESS: {
                return ExpressionEvaluator.compare(lhsv, (Predicate<? super Integer>)PredicateUtil.less((Comparable)Integer.valueOf(0)), rhsv);
            }
            case LESS_EQUAL: {
                return ExpressionEvaluator.compare(lhsv, (Predicate<? super Integer>)PredicateUtil.lessEqual((Comparable)Integer.valueOf(0)), rhsv);
            }
            case GREATER: {
                return ExpressionEvaluator.compare(lhsv, (Predicate<? super Integer>)PredicateUtil.greater((Comparable)Integer.valueOf(0)), rhsv);
            }
            case GREATER_EQUAL: {
                return ExpressionEvaluator.compare(lhsv, (Predicate<? super Integer>)PredicateUtil.greaterEqual((Comparable)Integer.valueOf(0)), rhsv);
            }
            case PLUS: {
                return ExpressionEvaluator.toString(lhsv) + ExpressionEvaluator.toString(rhsv);
            }
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case MINUS: {
                throw new EvaluationException("Incompatible types for operator '" + (Object)((Object)op) + "' ('" + ExpressionEvaluator.className(lhsc) + "' and '" + ExpressionEvaluator.className(rhsc) + "')");
            }
        }
        throw new IllegalStateException();
    }

    private static String className(@Nullable Class<? extends Object> clasS) {
        return clasS == null ? "null" : clasS.getName();
    }

    private static boolean compare(@Nullable Object lhsv, Predicate<? super Integer> condition, @Nullable Object rhsv) throws EvaluationException {
        if (lhsv == null || rhsv == null) {
            return false;
        }
        if (lhsv instanceof Comparable && rhsv instanceof Comparable) {
            return condition.evaluate((Object)((Comparable)lhsv).compareTo(rhsv));
        }
        if (lhsv instanceof CharSequence && rhsv instanceof CharSequence) {
            return condition.evaluate((Object)StringUtil.compareTo((CharSequence)((CharSequence)lhsv), (CharSequence)((CharSequence)rhsv)));
        }
        throw new EvaluationException("Operands '" + lhsv.getClass().getName() + "' and '" + rhsv.getClass().getName() + "' cannot be lexicographically compared");
    }

    @Nullable
    private static Object unaryNumericPromotion(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == Byte.class) {
            return (int)((Byte)value).byteValue();
        }
        if (valueClass == Short.class) {
            return (int)((Short)value).shortValue();
        }
        if (valueClass == Character.class) {
            return (int)((Character)value).charValue();
        }
        return value;
    }

    @Nullable
    protected static Object binaryNumericPromotion(@Nullable Object value, @Nullable Object other) {
        if (value == null || other == null) {
            return value;
        }
        Class<?> valueClass = value.getClass();
        Class<?> otherClass = other.getClass();
        if (valueClass == Byte.class) {
            byte byteValue = (Byte)value;
            if (otherClass == Byte.class) {
                return (int)byteValue;
            }
            if (otherClass == Short.class) {
                return (int)byteValue;
            }
            if (otherClass == Integer.class) {
                return (int)byteValue;
            }
            if (otherClass == Long.class) {
                return (long)byteValue;
            }
            if (otherClass == Float.class) {
                return Float.valueOf(byteValue);
            }
            if (otherClass == Double.class) {
                return (double)byteValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(byteValue);
            }
        } else if (valueClass == Short.class) {
            short shortValue = (Short)value;
            if (otherClass == Byte.class) {
                return (int)shortValue;
            }
            if (otherClass == Short.class) {
                return (int)shortValue;
            }
            if (otherClass == Integer.class) {
                return (int)shortValue;
            }
            if (otherClass == Long.class) {
                return (long)shortValue;
            }
            if (otherClass == Float.class) {
                return Float.valueOf(shortValue);
            }
            if (otherClass == Double.class) {
                return (double)shortValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(shortValue);
            }
        } else if (valueClass == Character.class) {
            char charValue = ((Character)value).charValue();
            if (otherClass == Byte.class) {
                return (int)charValue;
            }
            if (otherClass == Short.class) {
                return (int)charValue;
            }
            if (otherClass == Integer.class) {
                return (int)charValue;
            }
            if (otherClass == Long.class) {
                return (long)charValue;
            }
            if (otherClass == Float.class) {
                return Float.valueOf(charValue);
            }
            if (otherClass == Double.class) {
                return (double)charValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(charValue);
            }
        } else if (valueClass == Integer.class) {
            int intValue = (Integer)value;
            if (otherClass == Long.class) {
                return (long)intValue;
            }
            if (otherClass == Float.class) {
                return Float.valueOf(intValue);
            }
            if (otherClass == Double.class) {
                return (double)intValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(intValue);
            }
        } else if (valueClass == Long.class) {
            long longValue = (Long)value;
            if (otherClass == Float.class) {
                return Float.valueOf(longValue);
            }
            if (otherClass == Double.class) {
                return (double)longValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(longValue);
            }
        } else if (valueClass == Float.class) {
            float floatValue = ((Float)value).floatValue();
            if (otherClass == Double.class) {
                return (double)floatValue;
            }
            if (otherClass == String.class) {
                return String.valueOf(floatValue);
            }
        } else if (valueClass == Double.class) {
            double doubleValue = (Double)value;
            if (otherClass == String.class) {
                return String.valueOf(doubleValue);
            }
        }
        return value;
    }

    @Nullable
    public <T> T evaluateTo(String spec, Mapping<String, ?> variables, Class<T> targetType) throws ParseException, EvaluationException {
        Object o = this.evaluate(spec, variables);
        if (o == null) {
            return null;
        }
        if (!targetType.isAssignableFrom(o.getClass())) {
            throw new EvaluationException("'" + o + "' (type " + o.getClass() + ") is not a " + targetType);
        }
        Object result = o;
        return (T)result;
    }

    public Object evaluateToPrimitive(String spec, Mapping<String, ?> variables, Class<?> targetType) throws ParseException, EvaluationException {
        return ExpressionEvaluator.toPrimitive(this.evaluate(spec, variables), targetType);
    }

    public boolean evaluateToBoolean(@Nullable String spec, Mapping<String, ?> variables) throws ParseException, EvaluationException {
        return spec != null && ExpressionEvaluator.toBoolean(this.evaluate(spec, variables));
    }

    @Nullable
    public static <T> T to(@Nullable Object subject, Class<T> targetType) throws EvaluationException {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return (T)(FALSES.contains(subject) ? Boolean.FALSE : Boolean.TRUE);
        }
        if (subject == null) {
            return null;
        }
        if (targetType == String.class) {
            return (T)subject.toString();
        }
        Class<?> sourceClass = subject.getClass();
        if (targetType.isAssignableFrom(sourceClass)) {
            return (T)subject;
        }
        throw new EvaluationException("Cannot convert '" + sourceClass.getName() + "' to '" + targetType.getName() + "'");
    }

    public static <T> T toPrimitive(@Nullable Object subject, Class<T> targetType) throws EvaluationException {
        Class<Character> wrapperType;
        if (!targetType.isPrimitive()) {
            throw new AssertionError(targetType);
        }
        if (targetType == Boolean.TYPE) {
            return (T)Boolean.valueOf(ExpressionEvaluator.toBoolean(subject));
        }
        if (subject == null) {
            throw new EvaluationException("Cannot convert 'null' to '" + targetType.getName() + "'");
        }
        Class clazz = targetType == Character.TYPE ? Character.class : (targetType == Byte.TYPE ? Byte.class : (targetType == Short.TYPE ? Short.class : (targetType == Integer.TYPE ? Integer.class : (targetType == Long.TYPE ? Long.class : (targetType == Float.TYPE ? Float.class : (wrapperType = targetType == Double.TYPE ? Double.class : (Class)ExceptionUtil.throwAssertionError(targetType)))))));
        if (subject.getClass() != wrapperType) {
            throw new EvaluationException("Cannot convert '" + subject.getClass() + "' to '" + targetType + "'");
        }
        return (T)subject;
    }

    public static boolean toBoolean(@Nullable Object subject) {
        return !FALSES.contains(subject);
    }

    static {
        FALSES.add(null);
        FALSES.add("");
        FALSES.add(Boolean.FALSE);
        FALSES.add((byte)0);
        FALSES.add((short)0);
        FALSES.add(0);
        FALSES.add(0L);
    }
}

