/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.tcpmon;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int i = 0;
        while (i < args.length && (arg = args[i]).startsWith("-")) {
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("A server that accepts connections from clients, creates another connection to a");
                System.out.println("remote server for each accepted connection, and forwards all data from the");
                System.out.println("client to the server and back.");
                System.out.println();
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName() + "");
                System.out.println("        [ <global-option> ... ]");
                System.out.println("        ( [ <local-option> ... ]");
                System.out.println("              <local-port> <remote-server-host-name> <remote-server-port> ) ...");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -nowarn         Suppress all messages except errors");
                System.out.println("  -quiet          Suppress normal output");
                System.out.println("  -verbose        Log verbose messages");
                System.out.println("  -debug          Log verbose and debug messages (repeat to get more output)");
                System.out.println("  -log <level>:<logger>:<handler>:<formatter>:<format>");
                System.out.println("                  Add logging at level FINE on logger 'de.unkrig' to STDERR");
                System.out.println("                  using the FormatFormatter and SIMPLE format, or the given");
                System.out.println("                  arguments which are all optional.");
                System.out.println("Valid <local-option>s are:");
                System.out.println("  -backlog <n>    The maximum queue length for incoming request to connect");
                System.out.println("  -bind-address <address>");
                System.out.println("                  Accept connect requests to only this address");
                System.out.println("  -server-connection-timeout <ms>");
                System.out.println("                  Timeout for creating connections to the remote server");
                System.exit(0);
            }
            if ("-nowarn".equals(arg)) {
                SimpleLogging.setNoWarn();
                continue;
            }
            if ("-quiet".equals(arg)) {
                SimpleLogging.setQuiet();
                continue;
            }
            if ("-verbose".equals(arg)) {
                SimpleLogging.setVerbose();
                continue;
            }
            if ("-debug".equals(arg)) {
                SimpleLogging.setDebug();
                continue;
            }
            if ("-log".equals(arg)) {
                SimpleLogging.configureLoggers((String)args[i++]);
                continue;
            }
            --i;
            break;
        }
        while (i < args.length) {
            String arg2;
            int backlog = 0;
            InetAddress bindAddress = null;
            int serverConnectionTimeout = 0;
            while (i < args.length && (arg2 = args[i]).startsWith("-")) {
                ++i;
                if ("-backlog".equals(arg2)) {
                    backlog = Integer.parseInt(args[i++]);
                    continue;
                }
                if ("-bind-address".equals(arg2)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                if ("-server-connection-timeout".equals(arg2)) {
                    serverConnectionTimeout = Integer.parseInt(args[i++]);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg2 + "'; try '-help'");
                System.exit(1);
            }
            if (i + 3 > args.length) {
                System.err.println("Local port, server host name and/or server port missing; try '-help'.");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            InetSocketAddress serverAddress = InetSocketAddress.createUnresolved(args[i++], Integer.parseInt(args[i++]));
            ThreadUtil.runInBackground((RunnableWhichThrows)new ReverseProxy(endpoint, backlog, serverAddress, Proxy.NO_PROXY, serverConnectionTimeout, new ReverseProxy.ProxyConnectionHandler(){

                @Override
                public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                    ThreadUtil.parallel((RunnableWhichThrows)IoUtil.copyRunnable((InputStream)clientIn, (OutputStream)serverOut), (RunnableWhichThrows)IoUtil.copyRunnable((InputStream)serverIn, (OutputStream)clientOut), (Stoppable)stoppable);
                }
            }), null);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        SimpleLogging.init();
    }
}

