/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.httpd;

import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.http.HttpClientConnectionHandler;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.servlett.FileServlett;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;

public class Httpd
implements RunnableWhichThrows<IOException>,
Stoppable {
    private final TcpServer tcpServer;

    public Httpd(InetSocketAddress endpoint, final String documentRootDirectoryNamePattern) throws IOException {
        this.tcpServer = new TcpServer(endpoint, 0, new HttpClientConnectionHandler(new FileServlett(){

            @Override
            protected File getFile(HttpRequest httpRequest) {
                return new File(documentRootDirectoryNamePattern.replace("{path}", httpRequest.getUri().getPath()));
            }
        }));
    }

    public Httpd(InetSocketAddress endpoint, SSLContext sslContext, final String documentRootDirectoryNamePattern) throws IOException {
        this.tcpServer = new TcpServer(endpoint, 0, sslContext, new HttpClientConnectionHandler(new FileServlett(){

            @Override
            protected File getFile(HttpRequest httpRequest) {
                return new File(documentRootDirectoryNamePattern.replace("{path}", httpRequest.getUri().getPath()));
            }
        }));
    }

    public void run() throws IOException {
        this.tcpServer.run();
    }

    public void stop() {
        this.tcpServer.stop();
    }

    public InetSocketAddress getEndpointAddress() {
        return this.tcpServer.getEndpointAddress();
    }
}

