/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.net.TcpClient;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;

public final class HttpClient
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(HttpClient.class.getName());
    private final TcpClient tcpClient;

    public HttpClient(String host, int port) throws IOException {
        this(InetAddress.getByName(host), port);
    }

    public HttpClient(InetAddress address, int port) throws IOException {
        this.tcpClient = new TcpClient(address, port);
    }

    public HttpResponse call(HttpRequest httpRequest) throws IOException {
        httpRequest.write(this.tcpClient.getOutputStream());
        return HttpResponse.read(this.tcpClient.getInputStream(), httpRequest.getHttpVersion(), httpRequest.getMethod() == HttpRequest.Method.HEAD);
    }

    @Override
    public void close() throws IOException {
        LOGGER.fine("Disposing connection to " + this.tcpClient.getRemoteSocketAddress());
        this.tcpClient.close();
    }
}

