/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.lang.protocol.StoppableUtil;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReverseProxy
implements RunnableWhichThrows<IOException>,
Stoppable {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxy.class.getName());
    private final TcpServer server;

    public ReverseProxy(InetSocketAddress endpoint, int backlog, final InetSocketAddress serverAddress, final Proxy serverConnectionProxy, final int serverConnectionTimeout, final ProxyConnectionHandler proxyConnectionHandler) throws IOException {
        this.server = new TcpServer(endpoint, backlog, new TcpServer.ConnectionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleConnection(InputStream clientIn, OutputStream clientOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, Stoppable stoppable) throws IOException {
                Socket serverConnection = new Socket(serverConnectionProxy);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Connecting with {0}", serverAddress);
                }
                long t = System.currentTimeMillis();
                try {
                    serverConnection.connect(serverAddress, serverConnectionTimeout);
                }
                catch (SocketTimeoutException ste) {
                    LOGGER.log(Level.WARNING, "Connecting with {0} timed out after {1} ms", new Object[]{serverAddress, System.currentTimeMillis() - t});
                    return;
                }
                catch (IOException ioe) {
                    throw (IOException)ExceptionUtil.wrap((String)("Connecting with " + serverAddress), (Throwable)ioe);
                }
                try {
                    InetSocketAddress serverLocalSocketAddress = (InetSocketAddress)serverConnection.getLocalSocketAddress();
                    InetSocketAddress serverRemoteSocketAddress = (InetSocketAddress)serverConnection.getRemoteSocketAddress();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Connected {0} => {1}", new Object[]{serverLocalSocketAddress, serverRemoteSocketAddress});
                    }
                    proxyConnectionHandler.handleConnection(clientIn, clientOut, serverConnection.getInputStream(), serverConnection.getOutputStream(), clientLocalSocketAddress, clientRemoteSocketAddress, serverLocalSocketAddress, serverRemoteSocketAddress, StoppableUtil.toStoppable((Socket)serverConnection));
                }
                finally {
                    try {
                        serverConnection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public InetSocketAddress getEndpointAddress() {
        return this.server.getEndpointAddress();
    }

    public void run() throws IOException {
        this.server.run();
    }

    public void stop() {
        this.server.stop();
    }

    public static interface ProxyConnectionHandler {
        @NotNullByDefault(value=false)
        public void handleConnection(@NotNull InputStream var1, @NotNull OutputStream var2, @NotNull InputStream var3, @NotNull OutputStream var4, @NotNull InetSocketAddress var5, @NotNull InetSocketAddress var6, @NotNull InetSocketAddress var7, @NotNull InetSocketAddress var8, @NotNull Stoppable var9) throws IOException;
    }
}

