/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.telnet;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        Socket socket;
        String arg;
        int i;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if ("-help".equals(arg)) {
                System.out.println("Creates a TCP connection to a server and forwards STDIN/STDOUT to that connection.");
                System.out.println();
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName() + " -help");
                System.out.println("  java " + Main.class.getName() + " <server-host-name> <server-port> )");
                System.exit(0);
                continue;
            }
            System.err.println("Unknown command line option '" + arg + "'; try '-help'.");
            System.exit(1);
        }
        if (i + 2 != args.length) {
            System.err.println("Server host name and/or server port missing; try '-help'");
            System.exit(1);
        }
        String hostName = args[i++];
        int port = Integer.parseInt(args[i++]);
        try {
            socket = new Socket(hostName, port);
        }
        catch (IOException ioe) {
            throw (IOException)ExceptionUtil.wrap((String)("Connecting to '" + hostName + "':" + port), (Throwable)ioe);
        }
        OutputStream socketOutputStream = socket.getOutputStream();
        InputStream socketInputStream = socket.getInputStream();
        ThreadUtil.runInBackground((RunnableWhichThrows)IoUtil.copyRunnable((InputStream)socketInputStream, (OutputStream)System.out), null);
        ThreadUtil.runInForeground((RunnableWhichThrows)IoUtil.copyRunnable((InputStream)System.in, (OutputStream)socketOutputStream));
        socket.close();
    }

    static {
        SimpleLogging.init();
    }
}

