/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.ftpserver;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.net.ftp.FtpServer;
import de.unkrig.commons.net.ftp.ftplett.FileFtplett;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int i = 0;
        while (i < args.length && (arg = args[i]).startsWith("-")) {
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName());
                System.out.println("        [ <global-option> ... ]");
                System.out.println("        ( [ <local-option> ... ] <local-port> ) ...");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -nowarn         Suppress all messages except errors");
                System.out.println("  -quiet          Suppress normal output");
                System.out.println("  -verbose        Log verbose messages");
                System.out.println("  -debug          Log verbose and debug messages (repeat to get more output)");
                System.out.println("  -log <level>:<logger>:<handler>:<formatter>:<format>");
                System.out.println("                  Add logging at level FINE on logger 'de.unkrig' to STDERR");
                System.out.println("                  using the FormatFormatter and SIMPLE format, or the given");
                System.out.println("                  arguments which are all optional.");
                System.out.println("Valid <local-option>s are:");
                System.out.println("  -backlog <n>    The maximum queue length for incoming request to connect");
                System.out.println("  -bind-address <address>");
                System.out.println("                  Accept connect requests to only this address");
                System.exit(0);
                continue;
            }
            if ("-nowarn".equals(arg)) {
                SimpleLogging.setNoWarn();
                continue;
            }
            if ("-quiet".equals(arg)) {
                SimpleLogging.setQuiet();
                continue;
            }
            if ("-verbose".equals(arg)) {
                SimpleLogging.setVerbose();
                continue;
            }
            if ("-debug".equals(arg)) {
                SimpleLogging.setDebug();
                continue;
            }
            if (!"-log".equals(arg)) break;
            SimpleLogging.configureLoggers((String)args[i++]);
        }
        while (i < args.length) {
            String arg2;
            int backlog = 0;
            InetAddress bindAddress = null;
            while (i < args.length && (arg2 = args[i]).startsWith("-")) {
                ++i;
                if ("-backlog".equals(arg2)) {
                    backlog = Integer.parseInt(args[i++]);
                    continue;
                }
                if ("-bind-address".equals(arg2)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg2 + "'; try '-help'");
                System.exit(1);
            }
            if (i + 1 > args.length) {
                System.err.println("Local port missing; try '-help'");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            ThreadUtil.runInBackground((RunnableWhichThrows)new FtpServer(endpoint, backlog, new FileFtplett(new File("."))), null);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        SimpleLogging.init();
    }
}

