/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.servlett;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.AbstractServlett;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.Base64;
import java.io.IOException;

public class HttpAuthenticationServlett
extends AbstractServlett {
    private final String realm;
    private final String userName;
    private final String password;

    public HttpAuthenticationServlett(String realm, String userName, String password) {
        this.realm = realm;
        this.userName = userName;
        this.password = password;
    }

    @Override
    @Nullable
    public HttpResponse handleRequest(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) {
        String userPass;
        String s = httpRequest.getHeader("Authorization");
        if (s == null) {
            HttpResponse httpResponse = HttpResponse.response(HttpResponse.Status.UNAUTHORIZED);
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            return httpResponse;
        }
        if (!s.startsWith("Basic ")) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Unexpected authentication scheme");
        }
        try {
            userPass = new String(Base64.base64ToByteArray((String)s.substring(6)));
        }
        catch (Exception e) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "BASE64 encoding error: " + e);
        }
        int idx = userPass.indexOf(58);
        if (idx == -1) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Basic-credentials lack a colon");
        }
        String userName = userPass.substring(0, idx);
        String password = userPass.substring(idx + 1);
        if (!userName.equals(this.userName) || !password.equals(this.password)) {
            HttpResponse httpResponse = HttpResponse.response(HttpResponse.Status.UNAUTHORIZED, "Invalid user name or password");
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            return httpResponse;
        }
        return null;
    }
}

