/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.io.PercentEncodingInputStream;
import de.unkrig.commons.io.PercentEncodingOutputStream;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.net.http.HttpMessage;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.net.http.MessageHeader;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequest
extends HttpMessage {
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("(\\p{Alpha}+) ([^ ]+)(?: HTTP/(\\d+\\.\\d+))?");
    private Method method;
    private String httpVersion;
    private URI uri;
    private boolean uriQueryValid;
    @Nullable
    private List<Map.Entry<String, String>> parameterList = new ArrayList<Map.Entry<String, String>>();
    @Nullable
    private Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();

    public static HttpRequest read(InputStream in) throws IOException, InvalidHttpMessageException {
        URI uri;
        String requestLine = HttpMessage.readLine(in);
        LOGGER.fine(">>> " + requestLine);
        Matcher matcher = REQUEST_LINE_PATTERN.matcher(requestLine);
        if (!matcher.matches()) {
            LOGGER.warning("Invalid request line '" + requestLine + "'");
            throw new IOException("Invalid request line");
        }
        Method method = Method.valueOf(matcher.group(1));
        try {
            uri = new URI(matcher.group(2));
        }
        catch (URISyntaxException use) {
            throw new InvalidHttpMessageException(use);
        }
        String httpVersion = matcher.group(3);
        if (httpVersion == null) {
            httpVersion = "0.9";
        }
        return new HttpRequest(method, uri, httpVersion, in);
    }

    public HttpRequest(Method method, URI uri, String httpVersion, InputStream in) throws IOException {
        super(in, true, method == Method.POST || method == Method.PUT);
        this.method = method;
        this.httpVersion = httpVersion;
        this.uri = uri;
        this.uriQueryValid = true;
        this.parameterList = null;
        this.parameterMap = null;
    }

    public HttpRequest(Method method, URI uri, String httpVersion) {
        super(method == Method.POST || method == Method.PUT);
        this.method = method;
        this.httpVersion = httpVersion;
        this.uri = uri;
        this.uriQueryValid = true;
        this.parameterList = null;
        this.parameterMap = null;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public URI getUri() {
        if (!this.uriQueryValid) {
            if (this.parameterList != null) {
                this.updateUriFromParameterList();
            }
            this.uriQueryValid = true;
        }
        return this.uri;
    }

    public final void setUri(URI uri) {
        this.uri = uri;
        this.uriQueryValid = true;
        this.parameterList = null;
        this.parameterMap = null;
    }

    public List<Map.Entry<String, String>> getParameterList() throws IOException {
        if (this.parameterList == null) {
            this.updateParameterListFromQueryOrBody();
            this.parameterMap = null;
        }
        return Collections.unmodifiableList(this.parameterList);
    }

    public void setParameterList(Iterable<Map.Entry<String, String>> parameters) {
        List<Map.Entry<String, String>> pl = this.parameterList;
        if (pl == null) {
            pl = this.parameterList = new ArrayList<Map.Entry<String, String>>();
        } else {
            pl.clear();
        }
        for (Map.Entry<String, String> e : parameters) {
            pl.add(HttpRequest.entry(e.getKey(), e.getValue()));
        }
        this.uriQueryValid = false;
        this.parameterMap = null;
    }

    @Nullable
    public String[] getParameter(String name) throws IOException {
        this.getParameterMap();
        List<String> l = this.getParameterMap().get(name);
        return l == null ? null : l.toArray(new String[l.size()]);
    }

    public void addParameter(String name, String value) throws IOException {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) throws IOException {
        List<Map.Entry<String, String>> pl = this.getParameterList();
        for (String value : values) {
            pl.add(HttpRequest.entry(name, value));
        }
        Map<String, List<String>> pm = this.getParameterMap();
        List<String> l = pm.get(name);
        if (l == null) {
            l = new ArrayList<String>();
            pm.put(name, l);
        }
        for (String value : values) {
            l.add(value);
        }
        if (this.method != Method.POST && this.method != Method.PUT) {
            this.uriQueryValid = false;
        }
    }

    public void setParameter(String name, String value) throws IOException {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) throws IOException {
        this.getParameterMap();
        List<String> l = this.getParameterMap().get(name);
        if (l == null) {
            this.addParameter(name, values);
            return;
        }
        l.clear();
        for (String value : values) {
            l.add(value);
        }
        List<Map.Entry<String, String>> pl = this.getParameterList();
        Iterator<Map.Entry<String, String>> it = pl.iterator();
        while (it.hasNext()) {
            if (!it.next().getKey().equals(name)) continue;
            it.remove();
        }
        for (String value : values) {
            pl.add(HttpRequest.entry(name, value));
        }
        if (this.method != Method.POST && this.method != Method.PUT) {
            this.uriQueryValid = false;
        }
    }

    private void updateParameterListFromQueryOrBody() throws IOException {
        String query;
        if (this.method == Method.POST || this.method == Method.PUT) {
            query = IoUtil.readAll((Reader)new InputStreamReader(this.removeBody().inputStream(), this.getCharset()));
        } else {
            assert (this.uriQueryValid);
            query = this.uri.getQuery();
        }
        this.parameterList = new ArrayList<Map.Entry<String, String>>();
        ArrayList<Map.Entry<String, String>> pl = this.parameterList;
        pl.addAll(HttpRequest.decodeParameters(query));
    }

    private void updateUriFromParameterList() {
        block3: {
            List<Map.Entry<String, String>> pl = this.parameterList;
            assert (pl != null);
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), HttpRequest.encodeParameters(pl), this.uri.getFragment());
            }
            catch (URISyntaxException use) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Updating URI", use);
            }
        }
    }

    private Map<String, List<String>> getParameterMap() throws IOException {
        Map<String, List<String>> pm = this.parameterMap;
        if (pm != null) {
            return pm;
        }
        pm = this.parameterMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> e : this.getParameterList()) {
            String key = e.getKey();
            String value = e.getValue();
            List<String> l = pm.get(key);
            if (l == null) {
                l = new ArrayList<String>();
                pm.put(key, l);
            }
            l.add(value);
        }
        return pm;
    }

    @Nullable
    private static String encodeParameters(List<Map.Entry<String, String>> parameterList) {
        ByteArrayOutputStream baos;
        Iterator<Map.Entry<String, String>> it = parameterList.iterator();
        if (!it.hasNext()) {
            return null;
        }
        try {
            baos = new ByteArrayOutputStream();
            PercentEncodingOutputStream peos = new PercentEncodingOutputStream((OutputStream)baos);
            while (true) {
                Map.Entry<String, String> e = it.next();
                new OutputStreamWriter((OutputStream)peos, CHARSET_UTF_8).write(e.getKey());
                peos.writeUnencoded(61);
                new OutputStreamWriter((OutputStream)peos, CHARSET_UTF_8).write(e.getValue());
                if (it.hasNext()) {
                    peos.writeUnencoded(38);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Decoding parameters", ioe);
            }
            return null;
        }
        String result = new String(baos.toByteArray(), 0);
        return result;
    }

    private static List<Map.Entry<String, String>> decodeParameters(@Nullable String s) throws IOException {
        if (s == null) {
            return Collections.emptyList();
        }
        int len = s.length();
        byte[] bytes = new byte[len];
        s.getBytes(0, len, bytes, 0);
        return HttpRequest.decodeParameters(bytes);
    }

    private static List<Map.Entry<String, String>> decodeParameters(byte[] bytes) throws IOException {
        int len = bytes.length;
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        int off = 0;
        while (off < len) {
            int to;
            for (to = off; to < len && bytes[to] != 61 && bytes[to] != 38; ++to) {
            }
            String key = HttpRequest.percentDecode(bytes, off, to - off);
            if (to == len) {
                result.add(HttpRequest.entry(key, ""));
                break;
            }
            if (bytes[to] == 38) {
                result.add(HttpRequest.entry(key, ""));
                off = to + 1;
                continue;
            }
            for (to = off = to + 1; to < len && bytes[to] != 38; ++to) {
            }
            String value = HttpRequest.percentDecode(bytes, off, to - off);
            result.add(HttpRequest.entry(key, value));
            if (to == len) break;
            off = to + 1;
        }
        return result;
    }

    @NotNullByDefault(value=false)
    private static Map.Entry<String, String> entry(final String key, final String value) {
        return new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private static String percentDecode(byte[] bytes, int off, int len) throws IOException {
        PercentEncodingInputStream is = new PercentEncodingInputStream((InputStream)new ByteArrayInputStream(bytes, off, len));
        try {
            return IoUtil.readAll((Reader)new InputStreamReader((InputStream)is, CHARSET_UTF_8));
        }
        catch (MalformedInputException mie) {
            return IoUtil.readAll((Reader)new InputStreamReader((InputStream)is, CHARSET_ISO_8859_1));
        }
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void write(OutputStream out) throws IOException {
        String requestLine = (Object)((Object)this.method) + " " + this.uri;
        if (!"0.9".equals(this.httpVersion)) {
            requestLine = requestLine + " HTTP/" + this.httpVersion;
        }
        LOGGER.fine("<<< " + requestLine);
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("ASCII"));
        w.write(requestLine + "\r\n");
        ((Writer)w).flush();
        this.writeHeadersAndBody("<<< ", out);
    }

    public static void read(final ReadableByteChannel in, final Multiplexer multiplexer, final ConsumerWhichThrows<HttpRequest, IOException> requestConsumer) throws IOException {
        ConsumerWhichThrows<String, IOException> requestLineConsumer = new ConsumerWhichThrows<String, IOException>(){

            public void consume(String requestLine) throws IOException {
                URI uri;
                Matcher matcher = REQUEST_LINE_PATTERN.matcher(requestLine);
                if (!matcher.matches()) {
                    HttpMessage.LOGGER.warning("Invalid request line '" + requestLine + "'");
                    throw new InvalidHttpMessageException("Invalid request line");
                }
                final Method method = Method.valueOf(matcher.group(1));
                try {
                    uri = new URI(matcher.group(2));
                }
                catch (URISyntaxException use) {
                    throw new InvalidHttpMessageException(use);
                }
                final String httpVersion = matcher.group(3) == null ? "0.9" : matcher.group(3);
                HttpMessage.readHeaders(in, multiplexer, new ConsumerWhichThrows<List<MessageHeader>, IOException>(){

                    public void consume(List<MessageHeader> headers) throws IOException {
                        final HttpRequest httpRequest = new HttpRequest(method, uri, httpVersion);
                        if (method == Method.POST || method == Method.PUT) {
                            httpRequest.readBody(in, multiplexer, new RunnableWhichThrows<IOException>(){

                                public void run() throws IOException {
                                    requestConsumer.consume((Object)httpRequest);
                                }
                            });
                        } else {
                            requestConsumer.consume((Object)httpRequest);
                        }
                    }
                });
            }
        };
        HttpMessage.readLine(in, multiplexer, requestLineConsumer);
    }

    public static enum Method {
        GET,
        POST,
        HEAD,
        PUT;

    }
}

