/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerUtil;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.http.HttpClient;
import de.unkrig.commons.net.http.HttpClientConnectionHandler;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.net.http.servlett.AbstractServlett;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class HttpProxy
implements RunnableWhichThrows<IOException>,
Stoppable {
    private static final Logger LOGGER = Logger.getLogger(HttpProxy.class.getName());
    private final TcpServer tcpServer;
    private AtomicInteger requestCount = new AtomicInteger();
    private static final TransformerWhichThrows<? super HttpRequest, HttpRequest, IOException> REQUEST_IDENTITY = TransformerUtil.asTransformerWhichThrows((Transformer)TransformerUtil.identity());
    private static final TransformerWhichThrows<? super HttpResponse, HttpResponse, IOException> RESPONSE_IDENTITY = TransformerUtil.asTransformerWhichThrows((Transformer)TransformerUtil.identity());

    public HttpProxy(InetSocketAddress endpoint, InetSocketAddress remoteAddress) throws IOException {
        this(endpoint, remoteAddress.getHostName(), remoteAddress.getPort(), REQUEST_IDENTITY, RESPONSE_IDENTITY);
    }

    public HttpProxy(InetSocketAddress endpoint, String remoteHost, int remotePort) throws IOException {
        this(endpoint, remoteHost, remotePort, REQUEST_IDENTITY, RESPONSE_IDENTITY);
    }

    public HttpProxy(InetSocketAddress endpoint, InetSocketAddress remoteAddress, TransformerWhichThrows<? super HttpRequest, HttpRequest, IOException> requestTransformer, TransformerWhichThrows<? super HttpResponse, HttpResponse, IOException> responseTransformer) throws IOException {
        this(endpoint, remoteAddress.getHostName(), remoteAddress.getPort(), requestTransformer, responseTransformer);
    }

    public HttpProxy(InetSocketAddress endpoint, final String remoteHost, final int remotePort, final TransformerWhichThrows<? super HttpRequest, HttpRequest, IOException> requestTransformer, final TransformerWhichThrows<? super HttpResponse, HttpResponse, IOException> responseTransformer) throws IOException {
        this.tcpServer = new TcpServer(endpoint, 0, new HttpClientConnectionHandler(){

            @Override
            public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddess, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws IOException, InvalidHttpMessageException {
                final HttpClient httpClient = new HttpClient(remoteHost, remotePort);
                this.setServlett(new AbstractServlett(){

                    @Override
                    public HttpResponse getOrPost(HttpRequest request, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
                        int requestNumber = HttpProxy.this.requestCount.incrementAndGet();
                        request.setHeader("Host", remoteHost);
                        LOGGER.fine("Forwarding request #" + requestNumber + ":");
                        HttpResponse httpResponse = httpClient.call((HttpRequest)requestTransformer.transform((Object)request));
                        LOGGER.fine("Forwarding response #" + requestNumber + ":");
                        return (HttpResponse)responseTransformer.transform((Object)httpResponse);
                    }

                    @Override
                    public void close() throws IOException {
                        httpClient.close();
                    }
                });
                while (true) {
                    this.processRequests(in, out, stoppable);
                }
            }
        });
    }

    public void run() throws IOException {
        this.tcpServer.run();
    }

    public void stop() {
        this.tcpServer.stop();
    }

    public InetSocketAddress getEndpointAddress() {
        return this.tcpServer.getEndpointAddress();
    }
}

