/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.net.ftp.FtpServer;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FtpClient {
    private static final Logger LOGGER = Logger.getLogger(FtpClient.class.getName());
    private final ProducerWhichThrows<String, IOException> controlIn;
    private final ConsumerWhichThrows<String, IOException> controlOut;
    private final InetAddress controlLocalAddress;
    private int dataConnectionAcceptTimeout = 20000;
    private DataTransferMode dataTransferMode = DataTransferMode.ACTIVE;
    @Nullable
    private InetSocketAddress passiveDataRemoteSocketAddress;
    @Nullable
    private ServerSocket activeDataConnectionServerSocket;

    public FtpClient(InputStream controlIn, OutputStream controlOut, InetAddress controlLocalAddress) throws IOException {
        this.controlIn = LineUtil.lineProducerISO8859_1((InputStream)controlIn);
        this.controlOut = LineUtil.lineConsumerISO8859_1((OutputStream)controlOut);
        this.controlLocalAddress = controlLocalAddress;
        this.receiveReply();
    }

    public void setDataConnectionAcceptTimeout(int dataConnectionAcceptTimeout) {
        this.dataConnectionAcceptTimeout = dataConnectionAcceptTimeout;
    }

    public void login(String user, String password) throws IOException {
        this.sendCommand(FtpServer.CommandCode.USER, user);
        if (this.receiveReply(230, 331) == 331) {
            this.sendCommand(FtpServer.CommandCode.PASS, password);
            this.receiveReply(230, 202);
        }
    }

    public void changeWorkingDirectory(String directory) throws IOException {
        this.sendCommand(FtpServer.CommandCode.CWD, directory);
        this.receiveReply(250);
    }

    public void passive() throws IOException {
        ServerSocket adcss = this.activeDataConnectionServerSocket;
        if (adcss != null) {
            adcss.close();
            this.activeDataConnectionServerSocket = null;
        }
        this.sendCommand(FtpServer.CommandCode.PASV);
        String response = this.receiveReply(227);
        Matcher matcher = Pattern.compile(".*?(\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+).*").matcher(response);
        if (!matcher.matches()) {
            throw new IOException("Invalid response '" + response + "' to PASV received");
        }
        this.passiveDataRemoteSocketAddress = new InetSocketAddress(InetAddress.getByAddress(new byte[]{(byte)Integer.parseInt(matcher.group(1)), (byte)Integer.parseInt(matcher.group(2)), (byte)Integer.parseInt(matcher.group(3)), (byte)Integer.parseInt(matcher.group(4))}), 256 * Integer.parseInt(matcher.group(5)) + Integer.parseInt(matcher.group(6)));
        this.dataTransferMode = DataTransferMode.PASSIVE;
    }

    public void active(int port) throws IOException {
        ServerSocket adcss = this.activeDataConnectionServerSocket;
        if (adcss != null) {
            adcss.close();
            this.activeDataConnectionServerSocket = null;
        }
        adcss = this.activeDataConnectionServerSocket = new ServerSocket(port, 1, this.controlLocalAddress);
        adcss.setSoTimeout(this.dataConnectionAcceptTimeout);
        byte[] address = this.controlLocalAddress.getAddress();
        port = adcss.getLocalPort();
        this.sendCommand(FtpServer.CommandCode.PORT, (0xFF & address[0]) + "," + (0xFF & address[1]) + "," + (0xFF & address[2]) + "," + (0xFF & address[3]) + "," + (0xFF & port >> 8) + "," + (0xFF & port));
        this.receiveReply(200);
        this.dataTransferMode = DataTransferMode.ACTIVE;
    }

    public InputStream retrieve(String fileName) throws IOException {
        this.sendCommand(FtpServer.CommandCode.TYPE, "I");
        this.receiveReply(200);
        final Socket dataSocket = this.dataConnection();
        this.sendCommand(FtpServer.CommandCode.RETR, fileName);
        return new FilterInputStream(dataSocket.getInputStream()){

            @Override
            public void close() throws IOException {
                FtpClient.this.receiveReply(new int[]{226, 250});
                LOGGER.fine("File retrieval complete, closing data connection");
                super.close();
                dataSocket.close();
            }
        };
    }

    public void dispose() {
        ServerSocket adcss = this.activeDataConnectionServerSocket;
        if (adcss != null) {
            LOGGER.fine("Closing active data connection server socket");
            try {
                adcss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.activeDataConnectionServerSocket = null;
        }
    }

    private Socket dataConnection() throws IOException {
        switch (this.dataTransferMode) {
            case ACTIVE: {
                if (this.activeDataConnectionServerSocket == null) {
                    this.active(0);
                }
                ServerSocket adcss = this.activeDataConnectionServerSocket;
                assert (adcss != null);
                LOGGER.fine("Accepting data connection on '" + adcss.getLocalSocketAddress() + "'");
                return adcss.accept();
            }
            case PASSIVE: {
                InetSocketAddress pdrsa = this.passiveDataRemoteSocketAddress;
                assert (pdrsa != null);
                LOGGER.fine("Creating data connection to '" + pdrsa + "'");
                return new Socket(pdrsa.getAddress(), pdrsa.getPort());
            }
        }
        throw new IllegalStateException();
    }

    private void sendCommand(FtpServer.CommandCode commandCode) throws IOException {
        String line = commandCode.toString();
        LOGGER.fine(">>> " + line);
        this.controlOut.consume((Object)line);
    }

    private void sendCommand(FtpServer.CommandCode commandCode, String argument) throws IOException {
        String line = (Object)((Object)commandCode) + " " + argument;
        LOGGER.fine(">>> " + line);
        this.controlOut.consume((Object)line);
    }

    private String receiveReply(int statusCode) throws IOException {
        Reply reply = this.receiveReply();
        if (reply.statusCode == statusCode) {
            return reply.text;
        }
        throw new IOException("Expected reply '" + reply + "'");
    }

    private int receiveReply(int ... statusCodes) throws IOException {
        Reply reply = this.receiveReply();
        for (int statusCode : statusCodes) {
            if (reply.statusCode != statusCode) continue;
            return statusCode;
        }
        throw new IOException("Expected reply with on of status codes " + Arrays.toString(statusCodes) + " instead of '" + reply + "'");
    }

    private Reply receiveReply() throws IOException {
        String statusText;
        int statusCode;
        do {
            String line;
            if ((line = (String)this.controlIn.produce()) == null) {
                LOGGER.fine("Socket end-of-input");
                throw new EOFException();
            }
            LOGGER.fine("Received reply '" + line + "'");
            Matcher matcher = Pattern.compile("(\\d\\d\\d)([ \\-])+(.*)").matcher(line);
            if (!matcher.matches()) {
                throw new IOException("Invalid reply '" + line + "' received");
            }
            statusCode = Integer.parseInt(matcher.group(1));
            statusText = matcher.group(3);
            if (!"-".equals(matcher.group(2))) continue;
            do {
                if ((line = (String)this.controlIn.produce()) != null) continue;
                LOGGER.fine("Socket end-of-input in the middle of a multi-line reply");
                throw new IOException("Socket end-of-input in the middle of a multi-line reply");
            } while (!line.startsWith(matcher.group(1)));
        } while (statusCode < 200);
        return new Reply(statusCode, statusText);
    }

    private static final class Reply {
        final int statusCode;
        final String text;

        Reply(int statusCode, String text) {
            this.statusCode = statusCode;
            this.text = text;
        }

        public String toString() {
            return this.statusCode + " " + this.text;
        }
    }

    private static enum DataTransferMode {
        ACTIVE,
        PASSIVE;

    }
}

