/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UrlConnections {
    private static final Logger LOGGER;
    public static final Charset HTTP_DEFAULT_CHARSET;

    private UrlConnections() {
    }

    public static URLConnection followRedirects2(HttpURLConnection httpConn) throws IOException {
        LOGGER.log(Level.FINE, "followRedirects2({0})", httpConn);
        int attempt = 0;
        while (true) {
            if (attempt == 10) {
                throw new IOException("Giving up after " + attempt + " REDIRECTs (last location was '" + httpConn.getURL() + "')");
            }
            try {
                int fixedContentLength;
                URL url;
                Set<Map.Entry<String, List<String>>> requestProperties = httpConn.getRequestProperties().entrySet();
                int responseCode = httpConn.getResponseCode();
                if (responseCode < 300) {
                    return httpConn;
                }
                if (responseCode >= 400) {
                    throw UrlConnections.toException(httpConn, null);
                }
                String location = httpConn.getHeaderField("Location");
                if (location == null) {
                    throw new IOException("Response with code " + responseCode + " lacks the 'Location:' header field");
                }
                try {
                    url = new URL(httpConn.getURL(), location);
                }
                catch (MalformedURLException mue) {
                    throw new IOException("Invalid redirection location '" + location + "'", mue);
                }
                URLConnection conn2 = url.openConnection();
                if (responseCode == 303) {
                    return conn2;
                }
                conn2.setAllowUserInteraction(httpConn.getAllowUserInteraction());
                conn2.setConnectTimeout(httpConn.getConnectTimeout());
                conn2.setDefaultUseCaches(httpConn.getDefaultUseCaches());
                conn2.setDoInput(httpConn.getDoInput());
                conn2.setDoOutput(httpConn.getDoOutput());
                conn2.setIfModifiedSince(httpConn.getIfModifiedSince());
                conn2.setReadTimeout(httpConn.getReadTimeout());
                conn2.setUseCaches(httpConn.getUseCaches());
                for (Map.Entry<String, List<String>> e : requestProperties) {
                    for (String v : e.getValue()) {
                        conn2.addRequestProperty(e.getKey(), v);
                    }
                }
                if (!(conn2 instanceof HttpURLConnection)) {
                    return conn2;
                }
                HttpURLConnection httpConn2 = (HttpURLConnection)conn2;
                int chunkLength = UrlConnections.getChunkLength(httpConn);
                if (chunkLength != -1) {
                    httpConn2.setChunkedStreamingMode(chunkLength);
                }
                if ((fixedContentLength = UrlConnections.getFixedContentLength(httpConn)) != -1) {
                    httpConn2.setFixedLengthStreamingMode(fixedContentLength);
                }
                httpConn2.setInstanceFollowRedirects(httpConn.getInstanceFollowRedirects());
                httpConn2.setRequestMethod(httpConn.getRequestMethod());
                httpConn = httpConn2;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, null, e);
                throw UrlConnections.toException(httpConn, e);
            }
            ++attempt;
        }
    }

    public static IOException toException(HttpURLConnection httpConn, @Nullable Throwable cause) throws IOException {
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 404 && cause == null) {
            return new FileNotFoundException(httpConn.getURL().toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(httpConn.getRequestMethod()).append(" ").append(httpConn.getURL()).append('\n');
        sb.append(responseCode).append(" ").append(httpConn.getResponseMessage()).append('\n');
        InputStream errorStream = httpConn.getErrorStream();
        if (errorStream != null) {
            sb.append(IoUtil.readAll((Reader)new InputStreamReader(errorStream, Charset.forName("ISO-8859-1"))));
        }
        return new IOException(sb.toString(), cause);
    }

    private static int getFixedContentLength(HttpURLConnection httpConn) {
        try {
            return (Integer)HttpURLConnection.class.getDeclaredField("fixedContentLength").get(httpConn);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int getChunkLength(HttpURLConnection httpConn) {
        try {
            return (Integer)HttpURLConnection.class.getDeclaredField("chunkLength").get(httpConn);
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(UrlConnections.class.getName());
        HTTP_DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    }
}

