/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.ftpmon;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.net.ftp.DataConnectionProxy;
import de.unkrig.commons.net.ftp.FtpReverseProxy;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Main {
    static {
        SimpleLogging.init();
    }

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) break;
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName());
                System.out.println("        [ <global-option> ... ]");
                System.out.println("        ( [ <local-option> ... ]");
                System.out.println("              <local-port> <remote-server-host-name> <remote-server-port> ) ...");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -data-connection-port <port>");
                System.out.println("                  Use exactly this passive port for data connection forwarding");
                System.out.println("                  (allows for at most one data connection at a time).");
                System.out.println("  -data-connection-port <first>-<last>");
                System.out.println("                  Use the given range for the passive port for data connection");
                System.out.println("                  forwarding.");
                System.out.println("  -nowarn         Suppress all messages except errors");
                System.out.println("  -quiet          Suppress normal output");
                System.out.println("  -verbose        Log verbose messages");
                System.out.println("  -debug          Log verbose and debug messages (repeat to get more output)");
                System.out.println("  -log <level>:<logger>:<handler>:<formatter>:<format>");
                System.out.println("                  Add logging at level FINE on logger 'de.unkrig' to STDERR");
                System.out.println("                  using the FormatFormatter and SIMPLE format, or the given");
                System.out.println("                  arguments which are all optional.");
                System.out.println("Valid <local-option>s are:");
                System.out.println("  -backlog <n>    The maximum queue length for incoming request to connect");
                System.out.println("  -bind-address <address>");
                System.out.println("                  Accept connect requests to only this address");
                System.out.println("  -server-connection-timeout <ms>");
                System.out.println("                  Timeout for creating connections to the remote server");
                System.exit(0);
                continue;
            }
            if ("-data-connection-port".equals(arg)) {
                Matcher m = Pattern.compile("(\\d+)(?:-(\\d+))?").matcher(args[i++]);
                if (!m.matches()) {
                    System.err.println("Invalid argument to '-data-connection-port'; try '-help'");
                    System.exit(1);
                }
                int firstDataConnectionPort = Integer.parseInt(m.group(1));
                int lastDataConnectionPort = m.group(2) == null ? firstDataConnectionPort : Integer.parseInt(m.group(2));
                DataConnectionProxy.setLocalPortRange(firstDataConnectionPort, lastDataConnectionPort);
                continue;
            }
            if ("-nowarn".equals(arg)) {
                SimpleLogging.setNoWarn();
                continue;
            }
            if ("-quiet".equals(arg)) {
                SimpleLogging.setQuiet();
                continue;
            }
            if ("-verbose".equals(arg)) {
                SimpleLogging.setVerbose();
                continue;
            }
            if ("-debug".equals(arg)) {
                SimpleLogging.setDebug();
                continue;
            }
            if (!"-log".equals(arg)) break;
            SimpleLogging.configureLoggers((String)args[i++]);
        }
        while (i < args.length) {
            int backlog = 0;
            InetAddress bindAddress = null;
            int serverConnectionTimeout = 0;
            while (i < args.length) {
                String arg = args[i];
                if (!arg.startsWith("-")) break;
                ++i;
                if ("-backlog".equals(arg)) {
                    backlog = Integer.parseInt(args[i++]);
                    continue;
                }
                if ("-bind-address".equals(arg)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                if ("-server-connection-timeout".equals(arg)) {
                    serverConnectionTimeout = Integer.parseInt(args[i++]);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg + "'; try '-help'");
                System.exit(1);
            }
            if (i + 3 > args.length) {
                System.err.println("Local port, remote server host name and/or remote server port missing; try '-help'");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            InetSocketAddress serverAddress = new InetSocketAddress(args[i++], Integer.parseInt(args[i++]));
            ThreadUtil.runInBackground((RunnableWhichThrows)new FtpReverseProxy(endpoint, backlog, serverAddress, serverConnectionTimeout), null);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

