/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.security;

import de.unkrig.commons.net.X509Util;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class KeyStores {
    private KeyStores() {
    }

    public static KeyStore loadKeyStore(@Nullable File keyStoreFile, @Nullable char[] keyStorePassword) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream is = new FileInputStream(keyStoreFile != null ? keyStoreFile : new File(String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts"));
        try {
            keyStore.load(is, keyStorePassword);
        }
        finally {
            ((InputStream)is).close();
        }
        return keyStore;
    }

    public static SSLContext getSslContext(KeyStore keyStore, char[] keyStorePassword, @Nullable String serverAlias) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        if (serverAlias != null) {
            keyManagers = new KeyManager[]{X509Util.selectServerAlias((X509KeyManager)keyManagers[0], serverAlias)};
        }
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }
}

