/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@NotNullByDefault(value=false)
public class ChunkedInputStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getLogger(ChunkedInputStream.class.getName());
    int available;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == -1) {
            return -1;
        }
        return 0xFF & b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (off < 0 || off > b.length) {
            throw new IllegalArgumentException("off");
        }
        if (len < 0 || off + len > b.length) {
            throw new IllegalArgumentException("len");
        }
        if (this.available == -1) {
            return -1;
        }
        LOGGER.log(Level.FINER, "{0} byte(s) available; len={1}", new Object[]{this.available, len});
        if (this.available == 0) {
            int idx;
            String line = this.readLine();
            if (line.length() == 0) {
                line = this.readLine();
            }
            if ((idx = line.indexOf(59)) != -1) {
                line = line.substring(0, idx);
            }
            try {
                this.available = Integer.parseInt(line, 16);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Invalid chunk size field '" + line + "'");
            }
            if (this.available < 0) {
                throw new IOException("Negative chunk size field '" + line + "'");
            }
            if (this.available == 0) {
                LOGGER.log(Level.FINER, "End-of-input");
                this.available = -1;
                return -1;
            }
            LOGGER.log(Level.FINER, "{0} more byte(s) available", this.available);
        }
        if (len > this.available) {
            len = this.available;
        }
        int result = super.read(b, off, len);
        this.available -= result;
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        byte[] skipBuffer = new byte[4096];
        long remaining = n;
        while (remaining > 0L) {
            int count = this.read(skipBuffer, 0, (int)Math.min((long)skipBuffer.length, remaining));
            if (count < 0) break;
            remaining -= (long)count;
        }
        return n - remaining;
    }

    @Override
    public int available() {
        return this.available;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.in.read()) == -1) {
                throw new EOFException();
            }
            if (c == 13) {
                c = this.in.read();
                if (c != 10) {
                    throw new IOException("CR is not followed by NL, but by " + c);
                }
                return sb.toString();
            }
            sb.append((char)c);
        }
    }
}

