/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.io.FixedLengthInputStream;
import de.unkrig.commons.io.FixedLengthOutputStream;
import de.unkrig.commons.io.HexOutputStream;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.io.WriterOutputStream;
import de.unkrig.commons.io.XMLFormatterWriter;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.net.http.MessageHeader;
import de.unkrig.commons.net.http.ParametrizedHeaderValue;
import de.unkrig.commons.net.http.io.ChunkedInputStream;
import de.unkrig.commons.net.http.io.ChunkedOutputStream;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class HttpMessage {
    static final Logger LOGGER = Logger.getLogger(HttpMessage.class.getName());
    private static final Pattern HEADER_PATTERN = Pattern.compile("([ -~&&[^()<>@,;:\\\\/\\[\\]?={} \\t]]+)\\s*:\\s*(.*?)\\s*");
    private static final DateFormat[] HEADER_DATE_FORMATS;
    private final List<MessageHeader> headers = new ArrayList<MessageHeader>();
    public static final Body NO_BODY;
    public static final Body EMPTY_BODY;
    private Body body = NO_BODY;
    private static final Charset DEFAULT_CHARSET;

    static {
        DateFormat[] dateFormatArray = HEADER_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.ENGLISH), new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.ENGLISH), new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH)};
        int n = HEADER_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat df = dateFormatArray[n2];
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            ++n2;
        }
        NO_BODY = new Body(){

            @Override
            public String string(Charset charset) {
                throw new UnsupportedOperationException("NO_BODY");
            }

            @Override
            public InputStream inputStream() {
                throw new UnsupportedOperationException("NO_BODY");
            }

            @Override
            public void write(OutputStream stream) {
                throw new UnsupportedOperationException("NO_BODY");
            }

            @Override
            public void dispose() {
            }
        };
        EMPTY_BODY = new Body(){

            @Override
            public String string(Charset charset) {
                return "";
            }

            @Override
            public InputStream inputStream() {
                return IoUtil.EMPTY_INPUT_STREAM;
            }

            @Override
            public void write(OutputStream stream) {
            }

            @Override
            public void dispose() {
            }
        };
        DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    }

    protected HttpMessage(boolean hasBody) {
        this.body = hasBody ? EMPTY_BODY : NO_BODY;
    }

    protected HttpMessage(InputStream in, boolean hasHeaders, boolean hasBody) throws IOException {
        if (hasHeaders) {
            String line = HttpMessage.readLine(in);
            while (line.length() > 0) {
                String headerLine = line;
                while ((line = HttpMessage.readLine(in)).length() != 0 && " \t".indexOf(line.charAt(0)) != -1) {
                    headerLine = String.valueOf(headerLine) + "\r\n" + line;
                }
                LOGGER.fine(">>> " + headerLine);
                Matcher matcher = HEADER_PATTERN.matcher(headerLine);
                if (!matcher.matches()) {
                    throw new IOException("Invalid HTTP header line '" + headerLine + "'");
                }
                this.headers.add(new MessageHeader(matcher.group(1), matcher.group(2)));
            }
        }
        if (hasBody) {
            long cl;
            final ConsumerUtil.Produmer rawByteCount = ConsumerUtil.store();
            final ConsumerUtil.Produmer decodedByteCount = ConsumerUtil.store();
            if (LOGGER.isLoggable(Level.FINE)) {
                in = IoUtil.wye((InputStream)in, (OutputStream)IoUtil.lengthWritten((Consumer)ConsumerUtil.cumulate((Consumer)rawByteCount, (long)0L)));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                ParametrizedHeaderValue phv;
                boolean isXml = false;
                LOGGER.fine("Reading message body");
                String contentType = this.getHeader("Content-Type");
                if (contentType != null && "text/xml".equalsIgnoreCase((phv = new ParametrizedHeaderValue(contentType)).getToken())) {
                    isXml = true;
                }
                Writer logWriter = LogUtil.logWriter((Logger)LOGGER, (Level)Level.FINE, (String)">>> ");
                in = IoUtil.wye((InputStream)in, (OutputStream)(isXml ? new WriterOutputStream((Writer)new XMLFormatterWriter(logWriter)) : new HexOutputStream(logWriter)));
            }
            if ((cl = this.getLongHeader("Content-Length")) != -1L) {
                in = new FixedLengthInputStream(in, cl);
            } else {
                String tes = this.getHeader("Transfer-Encoding");
                if (tes != null) {
                    if (!"chunked".equalsIgnoreCase(tes)) {
                        throw new IOException("Message with unsupported transfer encoding '" + tes + "' received");
                    }
                    LOGGER.fine("Reading message with chunked contents");
                    in = new ChunkedInputStream(in);
                } else {
                    LOGGER.fine("Reading message with streaming contents");
                }
            }
            if ("gzip".equalsIgnoreCase(this.getHeader("Content-Encoding"))) {
                in = new GZIPInputStream(in);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                in = IoUtil.wye((InputStream)in, (OutputStream)IoUtil.lengthWritten((Consumer)ConsumerUtil.cumulate((Consumer)decodedByteCount, (long)0L)));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                in = IoUtil.onEndOfInput((InputStream)in, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.fine("Message body size was " + NumberFormat.getInstance().format(rawByteCount.produce()) + " (raw) " + NumberFormat.getInstance().format(decodedByteCount.produce()) + " (decoded)");
                    }
                });
            }
            this.setBody(HttpMessage.body(in));
        }
    }

    public void addHeader(String name, String value) {
        this.headers.add(new MessageHeader(name, value));
    }

    public void addHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void addHeader(String name, long value) {
        this.addHeader(name, Long.toString(value));
    }

    public void addHeader(String name, Date value) {
        this.addHeader(name, HEADER_DATE_FORMATS[0].format(value));
    }

    public void setHeader(String name, String value) {
        for (MessageHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            header.setValue(value);
            return;
        }
        this.headers.add(new MessageHeader(name, value));
    }

    public void setHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setHeader(String name, long value) {
        this.setHeader(name, Long.toString(value));
    }

    public void setHeader(String name, Date value) {
        this.setHeader(name, HEADER_DATE_FORMATS[0].format(value));
    }

    public void removeHeader(String name) {
        Iterator<MessageHeader> it = this.headers.iterator();
        while (it.hasNext()) {
            MessageHeader h = it.next();
            if (!h.getName().equalsIgnoreCase(name)) continue;
            it.remove();
        }
    }

    @Nullable
    public final String getHeader(String name) {
        for (MessageHeader mh : this.headers) {
            if (!mh.getName().equalsIgnoreCase(name)) continue;
            return mh.getValue();
        }
        return null;
    }

    public int getIntHeader(String name) throws IOException {
        String s = this.getHeader(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("'" + name + "' message header has invalid value '" + s + "'");
            }
        }
        return -1;
    }

    public final long getLongHeader(String name) throws IOException {
        String s = this.getHeader(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("'" + name + "' message header has invalid value '" + s + "'");
            }
        }
        return -1L;
    }

    @Nullable
    public Date getDateHeader(String name) throws IOException {
        String s = this.getHeader(name);
        if (s == null) {
            return null;
        }
        DateFormat[] dateFormatArray = HEADER_DATE_FORMATS;
        int n = HEADER_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat df = dateFormatArray[n2];
            try {
                return df.parse(s);
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw new IOException("Cannot parse date header '" + name + ": " + s + "'");
    }

    public String[] getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (MessageHeader mh : this.headers) {
            if (!mh.getName().equalsIgnoreCase(name)) continue;
            values.add(mh.getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    public List<MessageHeader> getHeaders() {
        return this.headers;
    }

    public Body removeBody() {
        Body result = this.body;
        this.body = NO_BODY;
        return result;
    }

    public static Body body(String text, final Charset charset) {
        return new Body(text){
            @Nullable
            String text2;
            {
                this.text2 = string;
            }

            @Override
            public String string(Charset charset2) {
                String result = this.text2;
                if (result == null) {
                    throw new IllegalStateException();
                }
                this.text2 = null;
                return result;
            }

            @Override
            public InputStream inputStream() throws IOException {
                if (this.text2 == null) {
                    throw new IllegalStateException();
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new OutputStreamWriter((OutputStream)baos, charset).write(this.text2);
                this.text2 = null;
                return new ByteArrayInputStream(baos.toByteArray());
            }

            @Override
            public void write(OutputStream stream) throws IOException {
                if (this.text2 == null) {
                    throw new IllegalStateException();
                }
                OutputStreamWriter w = new OutputStreamWriter(stream, charset);
                w.write(this.text2);
                w.flush();
                this.text2 = null;
            }

            @Override
            public void dispose() {
                this.text2 = null;
            }
        };
    }

    public static Body body(InputStream in) {
        return new Body(in){
            @Nullable
            InputStream in2;
            {
                this.in2 = inputStream;
            }

            @Override
            public String string(Charset charset) throws IOException {
                InputStream in3 = this.in2;
                if (in3 == null) {
                    throw new IllegalStateException();
                }
                String result = IoUtil.readAll((Reader)new InputStreamReader(in3, charset));
                try {
                    in3.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in2 = null;
                return result;
            }

            @Override
            public InputStream inputStream() {
                InputStream in3 = this.in2;
                if (in3 == null) {
                    throw new IllegalStateException();
                }
                this.in2 = null;
                return in3;
            }

            @Override
            public void write(OutputStream stream) throws IOException {
                InputStream in3 = this.in2;
                if (in3 == null) {
                    throw new IllegalStateException();
                }
                IoUtil.copy((InputStream)in3, (OutputStream)stream);
                try {
                    in3.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in2 = null;
            }

            @Override
            public void dispose() {
                InputStream in3 = this.in2;
                if (in3 != null) {
                    try {
                        IoUtil.skipAll((InputStream)in3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        in3.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.in2 = null;
            }
        };
    }

    public static Body body(File file) throws FileNotFoundException {
        return HttpMessage.body(new FileInputStream(file));
    }

    public static Body body(ConsumerWhichThrows<OutputStream, IOException> writer) {
        return new Body(writer){
            @Nullable
            ConsumerWhichThrows<OutputStream, IOException> writer2;
            {
                this.writer2 = consumerWhichThrows;
            }

            @Override
            public String string(Charset charset) throws IOException {
                ConsumerWhichThrows<OutputStream, IOException> w3 = this.writer2;
                if (w3 == null) {
                    throw new IllegalStateException();
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                w3.consume((Object)baos);
                this.writer2 = null;
                return IoUtil.readAll((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), charset));
            }

            @Override
            public InputStream inputStream() throws IOException {
                ConsumerWhichThrows<OutputStream, IOException> w3 = this.writer2;
                if (w3 == null) {
                    throw new IllegalStateException();
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                w3.consume((Object)baos);
                this.writer2 = null;
                return new ByteArrayInputStream(baos.toByteArray());
            }

            @Override
            public void write(OutputStream stream) throws IOException {
                ConsumerWhichThrows<OutputStream, IOException> w3 = this.writer2;
                if (w3 == null) {
                    throw new IllegalStateException();
                }
                w3.consume((Object)stream);
                this.writer2 = null;
            }

            @Override
            public void dispose() {
                this.writer2 = null;
            }
        };
    }

    public void setBody(Body body) {
        this.body.dispose();
        this.body = body;
    }

    public Charset getCharset() {
        String charsetName;
        ParametrizedHeaderValue phv;
        String token;
        String ct = this.getHeader("Content-Type");
        if (ct != null && ((token = (phv = new ParametrizedHeaderValue(ct)).getToken()).startsWith("text/") || "application/x-www-form-urlencoded".equalsIgnoreCase(token)) && (charsetName = phv.getParameter("charset")) != null) {
            try {
                return Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return DEFAULT_CHARSET;
    }

    protected void writeHeadersAndBody(final String prefix, final OutputStream out) throws IOException {
        if (this.body == NO_BODY) {
            this.writeHeaders(prefix, out);
            return;
        }
        String tes = this.getHeader("Transfer-Encoding");
        if (tes != null) {
            if (!"chunked".equalsIgnoreCase(tes)) {
                throw new IOException("Message with unsupported transfer encoding '" + tes + "' received");
            }
            LOGGER.fine("Writing message with chunked contents");
            this.writeHeaders(prefix, out);
            ChunkedOutputStream cos = new ChunkedOutputStream(IoUtil.unclosableOutputStream((OutputStream)out));
            this.writeBody(prefix, cos);
            ((OutputStream)cos).close();
            return;
        }
        long contentLength = this.getLongHeader("Content-Length");
        if (contentLength >= 0L) {
            this.writeHeaders(prefix, out);
            FixedLengthOutputStream flos = new FixedLengthOutputStream(IoUtil.unclosableOutputStream((OutputStream)out), contentLength);
            this.writeBody(prefix, (OutputStream)flos);
            flos.close();
            return;
        }
        final byte[] buffer = new byte[4000];
        final int[] count = new int[1];
        this.writeBody(prefix, new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b, int off, int len) throws IOException {
                if (count[0] == -1) {
                    out.write(b, off, len);
                } else if (count[0] + len > buffer.length) {
                    HttpMessage.this.writeHeaders(prefix, out);
                    out.write(buffer, 0, count[0]);
                    count[0] = -1;
                    out.write(b, off, len);
                } else {
                    System.arraycopy(b, off, buffer, count[0], len);
                    count[0] = count[0] + len;
                }
            }
        });
        if ((long)count[0] == -1L) {
            out.close();
            return;
        }
        this.setHeader("Content-Length", count[0]);
        this.writeHeaders(prefix, out);
        out.write(buffer, 0, count[0]);
    }

    private void writeBody(String prefix, OutputStream out) throws IOException {
        String ct;
        boolean isXml;
        GZIPOutputStream finishable = null;
        if ("gzip".equalsIgnoreCase(this.getHeader("Content-Encoding"))) {
            LOGGER.fine(String.valueOf(prefix) + "GZIP-encoded contents");
            finishable = new GZIPOutputStream(out);
            out = finishable;
        }
        boolean bl = isXml = (ct = this.getHeader("Content-Type")) != null && ct.indexOf("text/xml") != -1;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.valueOf(prefix) + "Writing message body:");
            Writer lw = LogUtil.logWriter((Logger)LOGGER, (Level)Level.FINE, (String)prefix);
            out = IoUtil.tee((OutputStream[])new OutputStream[]{out, isXml ? new WriterOutputStream((Writer)new XMLFormatterWriter(lw)) : new HexOutputStream(lw)});
        }
        this.body.write(out);
        if (finishable != null) {
            finishable.finish();
        }
        out.flush();
    }

    private void writeHeaders(String prefix, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("ASCII"));
        for (MessageHeader header : this.getHeaders()) {
            LOGGER.fine(String.valueOf(prefix) + header.getName() + ": " + header.getValue());
            w.write(String.valueOf(header.getName()) + ": " + header.getValue() + "\r\n");
        }
        w.write("\r\n");
        ((Writer)w).flush();
    }

    public static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                throw new EOFException();
            }
            if (c == 13) {
                c = in.read();
                if (c != 10) {
                    throw new IOException("LF instead of " + c + " expected after CR");
                }
                in.available();
                return new String(baos.toByteArray(), "ISO-8859-1");
            }
            baos.write(c);
        }
    }

    public static void readLine(final ReadableByteChannel in, final Multiplexer multiplexer, final ConsumerWhichThrows<String, IOException> lineConsumer) throws IOException {
        RunnableWhichThrows<IOException> lineParser = new RunnableWhichThrows<IOException>(){
            final ByteBuffer buffer = ByteBuffer.allocate(1);
            final ByteArrayOutputStream line = new ByteArrayOutputStream();
            int state;

            public void run() throws IOException {
                this.buffer.rewind();
                in.read(this.buffer);
                byte b = this.buffer.get(0);
                switch (this.state) {
                    case 0: {
                        if (b == 13) {
                            this.state = 1;
                            break;
                        }
                        this.line.write(b);
                        break;
                    }
                    case 1: {
                        if (b != 10) {
                            throw new InvalidHttpMessageException("HTTP header line: CR is not followed by LF, but '" + (0xFF & b) + "'");
                        }
                        lineConsumer.consume((Object)new String(this.line.toByteArray(), "ISO-8859-1"));
                        return;
                    }
                }
                multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)this);
            }
        };
        multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)lineParser);
    }

    public static void readHeaders(final ReadableByteChannel in, final Multiplexer multiplexer, final ConsumerWhichThrows<List<MessageHeader>, IOException> consumer) throws IOException {
        HttpMessage.readLine(in, multiplexer, new ConsumerWhichThrows<String, IOException>(){
            @Nullable
            String headerLine;
            final List<MessageHeader> headers = new ArrayList<MessageHeader>();

            public void consume(String line) throws IOException {
                if (" \t".indexOf(line.charAt(0)) != -1) {
                    if (this.headerLine == null) {
                        throw new InvalidHttpMessageException("Unexpected leading continuation line '" + line + "'");
                    }
                    this.headerLine = String.valueOf(this.headerLine) + "\r\n" + line;
                    HttpMessage.readLine(in, multiplexer, this);
                    return;
                }
                LOGGER.fine(">>> " + this.headerLine);
                Matcher matcher = HEADER_PATTERN.matcher(this.headerLine);
                if (!matcher.matches()) {
                    throw new InvalidHttpMessageException("Invalid HTTP header line '" + this.headerLine + "'");
                }
                this.headers.add(new MessageHeader(matcher.group(1), matcher.group(2)));
                if (line.length() == 0) {
                    consumer.consume(this.headers);
                    return;
                }
                this.headerLine = line;
                HttpMessage.readLine(in, multiplexer, this);
            }
        });
    }

    protected void readBody(ReadableByteChannel in, Multiplexer multiplexer, final RunnableWhichThrows<IOException> finished) throws IOException {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        RunnableWhichThrows<IOException> runnable = new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                InputStream in = new ByteArrayInputStream(buffer.toByteArray());
                if ("gzip".equalsIgnoreCase(HttpMessage.this.getHeader("Content-Encoding"))) {
                    LOGGER.fine("GZIP-encoded content");
                    in = new GZIPInputStream(in);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    ParametrizedHeaderValue phv;
                    boolean isXml = false;
                    LOGGER.fine("Reading message body");
                    String contentType = HttpMessage.this.getHeader("Content-Type");
                    if (contentType != null && "text/xml".equalsIgnoreCase((phv = new ParametrizedHeaderValue(contentType)).getToken())) {
                        isXml = true;
                    }
                    Writer logWriter = LogUtil.logWriter((Logger)LOGGER, (Level)Level.FINE, (String)">>> ");
                    in = IoUtil.wye((InputStream)in, (OutputStream)(isXml ? new WriterOutputStream((Writer)new XMLFormatterWriter(logWriter)) : new HexOutputStream(logWriter)));
                }
                HttpMessage.this.setBody(HttpMessage.body(in));
                finished.run();
            }
        };
        long cl = this.getLongHeader("Content-Length");
        if (cl != -1L) {
            HttpMessage.read(in, multiplexer, cl, buffer, runnable);
        } else {
            String tes = this.getHeader("Transfer-Encoding");
            if (tes != null) {
                if (!"chunked".equalsIgnoreCase(tes)) {
                    throw new IOException("Message with unsupported transfer encoding '" + tes + "' received");
                }
                LOGGER.fine("Reading chunked contents");
                HttpMessage.readChunked(in, multiplexer, buffer, runnable);
            } else {
                LOGGER.fine("Reading streaming contents");
                HttpMessage.read(in, multiplexer, buffer, runnable);
            }
        }
    }

    private static void readChunked(final ReadableByteChannel in, final Multiplexer multiplexer, final OutputStream buffer, final RunnableWhichThrows<IOException> finished) throws IOException {
        new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                final 11 chunkReader = this;
                HttpMessage.readLine(in, multiplexer, new ConsumerWhichThrows<String, IOException>(){

                    public void consume(String line) throws IOException {
                        long available;
                        if (line.length() == 0) {
                            HttpMessage.readLine(in, multiplexer, this);
                            return;
                        }
                        int idx = line.indexOf(59);
                        if (idx != -1) {
                            line = line.substring(0, idx);
                        }
                        try {
                            available = Long.parseLong(line, 16);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IOException("Invalid chunk size field '" + line + "'");
                        }
                        if (available < 0L) {
                            throw new IOException("Negative chunk size field '" + line + "'");
                        }
                        if (available == 0L) {
                            finished.run();
                            return;
                        }
                        HttpMessage.read(in, multiplexer, available, buffer, (RunnableWhichThrows<IOException>)chunkReader);
                    }
                });
            }
        }.run();
    }

    private static void read(final ReadableByteChannel in, final Multiplexer multiplexer, final OutputStream os, final RunnableWhichThrows<IOException> finished) throws IOException {
        multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){
            final ByteBuffer buffer = ByteBuffer.allocate(8192);

            public void run() throws IOException {
                this.buffer.rewind();
                int r = in.read(this.buffer);
                if (r == -1) {
                    finished.run();
                    return;
                }
                os.write(this.buffer.array(), 0, r);
                multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)this);
            }
        });
    }

    private static void read(final ReadableByteChannel in, final Multiplexer multiplexer, long n, final OutputStream os, final RunnableWhichThrows<IOException> finished) throws IOException {
        if (n == 0L) {
            finished.run();
            return;
        }
        multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(n){
            int count;
            final ByteBuffer buffer;
            {
                this.count = (int)l;
                this.buffer = ByteBuffer.allocate(8192);
            }

            public void run() throws IOException {
                this.buffer.rewind();
                this.buffer.limit(Math.min(this.count, this.buffer.capacity()));
                int r = in.read(this.buffer);
                if (r == -1) {
                    throw new EOFException();
                }
                os.write(this.buffer.array(), 0, r);
                this.count -= r;
                if (this.count == 0) {
                    finished.run();
                    return;
                }
                multiplexer.register((SelectableChannel)((Object)in), 1, (RunnableWhichThrows)this);
            }
        });
    }

    public static interface Body {
        public String string(Charset var1) throws IOException;

        public InputStream inputStream() throws IOException;

        public void write(OutputStream var1) throws IOException;

        public void dispose();
    }
}

