/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.math;

import de.unkrig.commons.lang.protocol.Producer;
import java.util.Arrays;

public final class Sequences {
    private static final long[] M = new long[]{7L, 13L, 31L, 61L, 127L, 251L, 509L, 1021L, 2039L, 4093L, 8191L, 16381L, 32749L, 65521L, 131071L, 262139L, 524287L, 1048573L, 0x1FFFF7L, 0x3FFFFDL, 0x7FFFF1L, 0xFFFFFDL, 33554393L, 0x3FFFFFBL, 134217689L, 0xFFFFFC7L, 0x1FFFFFFDL, 0x3FFFFFDDL, Integer.MAX_VALUE, 0xFFFFFFFBL, 0x1FFFFFFF7L, 17179869143L, 34359738337L, 0xFFFFFFFFBL, 137438953447L, 0x3FFFFFFFD3L, 0x7FFFFFFFF9L, 0xFFFFFFFFA9L, 2199023255531L, 0x3FFFFFFFFF5L, 0x7FFFFFFFFC7L, 0xFFFFFFFFFEFL, 35184372088777L, 70368744177643L, 140737488355213L, 0xFFFFFFFFFFC5L, 0xFFFFFFFFFFC5L, 1125899906842597L, 0x7FFFFFFFFFF7FL, 0xFFFFFFFFFFFD1L, 0x1FFFFFFFFFFF91L, 0x3FFFFFFFFFFFDFL, 36028797018963913L, 0xFFFFFFFFFFFFFBL, 0x1FFFFFFFFFFFFF3L, 288230376151711717L, 576460752303423433L, 0xFFFFFFFFFFFFFA3L, 0x1FFFFFFFFFFFFFFFL, 4611686018427387847L, 0x7FFFFFFFFFFFFFE7L, Long.MAX_VALUE};
    private static final long[] A = new long[]{5L, 7L, 11L, 31L, 23L, 33L, 35L, 65L, 995L, 209L, 884L, 572L, 219L, 17364L, 43165L, 92717L, 283741L, 380985L, 360889L, 914334L, 653276L, 6423135L, 25907312L, 26590841L, 45576512L, 246049789L, 520332806L, 771645345L, 1583458089L, 1588635695L, 7425194315L, 5295517759L, 3124199165L, 49865143810L, 76886758244L, 17838542566L, 61992693052L, 1038914804222L, 140245111714L, 2214813540776L, 4928052325348L, 6307617245999L, 25933916233908L, 63975993200055L, 72624924005429L, 49235258628958L, 265609885904224L, 1087141320185010L, 349044191547257L, 4359287924442956L, 2082839274626558L, 9131148267933071L, 33266544676670489L, 4595551687825993L, 75953708294752990L, 101565695086122187L, 346764851511064641L, 561860773102413563L, 1351750484049952003L, 2774243619903564593L, 4645906587823291368L};

    private Sequences() {
    }

    public static Producer<Long> randomSequence(long period) {
        return Sequences.randomSequence(System.nanoTime(), period);
    }

    public static Producer<Long> randomSequence(long seed, final long period) {
        if (period < 0L) {
            throw new IllegalArgumentException();
        }
        int idx = Arrays.binarySearch(M, period + 1L);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (idx == M.length) {
            --idx;
        }
        long m = M[idx];
        long a = A[idx];
        final Producer<Long> lcg = Sequences.multiplicativeCongruentialGenerator(seed, m, a);
        return new Producer<Long>(){

            public Long produce() {
                long result;
                while ((result = (Long)lcg.produce() - 1L) >= period) {
                }
                return result;
            }
        };
    }

    public static Producer<Long> randomSequence(long seed, final long min, long max) {
        final Producer<Long> delegate = Sequences.randomSequence(seed, max - min);
        return new Producer<Long>(){

            public Long produce() {
                return (Long)delegate.produce() + min;
            }
        };
    }

    public static Producer<Long> linearCongruentialGenerator(long seed, final long m, final long a, final long c) {
        return new Producer<Long>(seed){
            long x;
            {
                this.x = l;
            }

            public Long produce() {
                this.x = (a * this.x + c) % m;
                return this.x;
            }
        };
    }

    public static Producer<Long> multiplicativeCongruentialGenerator(long seed, final long m, final long a) {
        return new Producer<Long>(seed){
            long x;
            {
                this.x = 1L + (Long.MAX_VALUE & l) % (l2 - 1L);
            }

            public Long produce() {
                this.x = a * this.x % m;
                return this.x;
            }
        };
    }
}

