/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4.runner.internal;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public final class RemoteTestClassRunnerClient {
    private RemoteTestClassRunnerClient() {
    }

    public static void main(String[] args) throws Exception {
        RemoteTestClassRunnerClient.run(System.in, System.out);
    }

    public static void run(InputStream fromMaster, OutputStream toMaster) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(fromMaster);
        ObjectOutputStream oos = new ObjectOutputStream(toMaster);
        try {
            RemoteTestClassRunnerClient.run(ois, oos);
        }
        catch (Exception e) {
            oos.writeObject(e);
        }
        oos.flush();
    }

    public static void run(ObjectInputStream ois, final ObjectOutputStream oos) throws Exception {
        ParentRunner runner;
        String testClassName = (String)ois.readObject();
        String runnerClassName = (String)ois.readObject();
        final String nameSuffix = (String)ois.readObject();
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        Class<?> clasS = scl.loadClass(testClassName);
        try {
            try {
                runner = (ParentRunner)scl.loadClass(runnerClassName).getConstructor(Class.class).newInstance(clasS);
            }
            catch (InvocationTargetException ite) {
                Throwable tt = ite.getTargetException();
                if (tt instanceof Exception) {
                    throw (Exception)tt;
                }
                throw ite;
            }
        }
        catch (InitializationError ie) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("clasS=" + clasS.getName());
            pw.println("Causes are:");
            for (Throwable cause : ie.getCauses()) {
                cause.printStackTrace(pw);
            }
            pw.flush();
            throw new Exception(sw.toString(), ie);
        }
        catch (Exception e) {
            throw new Exception("clasS=" + clasS.getName(), e);
        }
        RunNotifier runNotifier = new RunNotifier();
        @NotNullByDefault(value=false)
        class MyRunListener
        extends RunListener {
            MyRunListener() {
            }

            public void testRunStarted(Description description) throws Exception {
                this.callBack("fireTestRunStarted", Description.class, this.fixDescription(description));
            }

            public void testRunFinished(Result result) throws Exception {
                this.callBack("fireTestRunFinished", Result.class, result);
            }

            public void testStarted(Description description) throws Exception {
                this.callBack("fireTestStarted", Description.class, this.fixDescription(description));
            }

            public void testFinished(Description description) throws Exception {
                this.callBack("fireTestFinished", Description.class, this.fixDescription(description));
            }

            public void testFailure(Failure failure) throws Exception {
                this.callBack("fireTestFailure", Failure.class, this.fixFailure(failure));
            }

            public void testIgnored(Description description) throws Exception {
                this.callBack("fireTestIgnored", Description.class, this.fixDescription(description));
            }

            private Failure fixFailure(Failure failure) {
                return new Failure(this.fixDescription(failure.getDescription()), failure.getException());
            }

            private Description fixDescription(Description desc) {
                Collection ac = desc.getAnnotations();
                Description result = Description.createSuiteDescription((String)(desc.getDisplayName() + nameSuffix), (Serializable)((Object)(desc.getDisplayName() + nameSuffix)), ac == null ? null : ac.toArray(new Annotation[ac.size()]));
                return result;
            }

            public void testAssumptionFailure(Failure failure) {
                try {
                    this.callBack("fireTestAssumptionFailure", Failure.class, failure);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }

            private void callBack(String methodName, Class<?> parameterType, Object argument) throws Exception {
                oos.writeObject(methodName);
                oos.writeObject(new Class[]{parameterType});
                oos.writeObject(new Object[]{argument});
                oos.flush();
            }
        }
        runNotifier.addListener((RunListener)new MyRunListener());
        while (true) {
            ois.readObject();
            runner.run(runNotifier);
            oos.writeObject(null);
            oos.flush();
        }
    }
}

