/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.List;
import org.junit.Assert;

public final class AssertString {
    private AssertString() {
    }

    public static void assertContains(String expectedInfix, String actual) {
        AssertString.assertContains(null, expectedInfix, actual);
    }

    public static void assertContains(@Nullable String message, String expectedInfix, String actual) {
        if (!actual.contains(expectedInfix)) {
            Assert.fail((String)((message == null ? "[" : message + ": [") + expectedInfix + "] is not contained in [" + actual + "]"));
        }
    }

    public static void assertContains(List<String> expectedInfixes, List<String> actuals) {
        AssertString.assertContains(null, expectedInfixes, actuals);
    }

    public static void assertContains(@Nullable String message, List<String> expectedInfixes, List<String> actuals) {
        for (int i = 0; i < expectedInfixes.size() && i < actuals.size(); ++i) {
            String expectedInfix = expectedInfixes.get(i);
            String actual = actuals.get(i);
            AssertString.assertContains((message == null ? "Element " : message + ": Element ") + i, expectedInfix, actual);
        }
        if (expectedInfixes.size() != actuals.size()) {
            Assert.fail((String)((message == null ? "Expected " : message + ": Expected ") + expectedInfixes.size() + " strings, but got " + actuals.size()));
        }
    }
}

