/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4.runner;

import de.unkrig.commons.junit4.runner.JavaHome;
import de.unkrig.commons.junit4.runner.internal.RemoteTestClassRunner;
import de.unkrig.commons.junit4.runner.internal.RemoteTestClassRunnerClient;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;

public class JreTestClassRunner
extends ParentRunner<Runner> {
    private final ParentRunner<?> delegate;
    private final String name;

    public JreTestClassRunner(Class<?> clasS) throws Exception {
        this(clasS, null, clasS.getAnnotation(JavaHome.class).value());
    }

    public JreTestClassRunner(Class<?> clasS, @Nullable ParentRunner<?> runWith, String javaHome) throws Exception {
        super(clasS);
        String classpath = System.getProperty("java.class.path");
        assert (classpath != null);
        this.name = "[JAVA_HOME=" + javaHome + "]";
        ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/java.exe", "-classpath", classpath, RemoteTestClassRunnerClient.class.getName(), "[JAVA_HOME=" + javaHome + "]");
        Process p = pb.start();
        this.delegate = new RemoteTestClassRunner(clasS, (Runner)runWith, this.name, p.getOutputStream(), p.getInputStream());
    }

    protected String getName() {
        return this.name;
    }

    @NotNullByDefault(value=false)
    protected Description describeChild(Runner child) {
        assert (child == this.delegate);
        return child.getDescription();
    }

    @NotNullByDefault(value=false)
    protected void runChild(Runner child, RunNotifier notifier) {
        assert (child == this.delegate);
        child.run(notifier);
    }

    protected List<Runner> getChildren() {
        return Collections.singletonList(this.delegate);
    }
}

