/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io.pipe;

import de.unkrig.commons.io.pipe.AbstractPipe;
import java.io.IOException;

public abstract class AbstractRingBuffer
extends AbstractPipe {
    private final long capacity;
    private long head = -1L;
    private long tail;

    public AbstractRingBuffer(long capacity) {
        this.capacity = capacity;
    }

    protected abstract void get(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void put(byte[] var1, int var2, int var3, long var4) throws IOException;

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.head == -1L) {
            return 0;
        }
        if (this.head == this.tail) {
            long av = this.capacity - this.head;
            if ((long)len < av) {
                this.get(this.head, buf, off, len);
                this.head += (long)len;
            } else if ((long)len >= this.capacity) {
                this.get(this.head, buf, off, (int)av);
                this.get(0L, buf, off + (int)av, (int)(this.capacity - av));
                this.head = -1L;
                len = (int)this.capacity;
            } else {
                this.get(this.head, buf, off, (int)av);
                this.get(0L, buf, off + (int)av, len - (int)av);
                this.head = (long)len - av;
            }
            return len;
        }
        if (this.tail > this.head) {
            long av = this.tail - this.head;
            if ((long)len < av) {
                this.get(this.head, buf, off, len);
                this.head += (long)len;
                return len;
            }
            this.get(this.head, buf, off, (int)av);
            this.head = -1L;
            return (int)av;
        }
        long av = this.capacity - this.head;
        if ((long)len < av) {
            this.get(this.head, buf, off, len);
            this.head += (long)len;
            return len;
        }
        if ((long)len < av + this.tail) {
            this.get(this.head, buf, off, (int)av);
            this.get(0L, buf, off + (int)av, len - (int)av);
            this.head = (long)len - av;
            return len;
        }
        this.get(this.head, buf, off, (int)av);
        this.get(0L, buf, off + (int)av, (int)this.tail);
        this.head = -1L;
        return (int)(av + this.tail);
    }

    @Override
    public final int write(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.head == -1L) {
            if ((long)len > this.capacity) {
                len = (int)this.capacity;
            }
            this.put(buf, off, len, 0L);
            this.head = 0L;
            this.tail = len;
            return len;
        }
        if (this.tail > this.head) {
            long av = this.capacity - this.tail;
            if ((long)len < av) {
                this.put(buf, off, len, this.tail);
                this.tail += (long)len;
                return len;
            }
            if ((long)len == av) {
                this.put(buf, off, len, this.tail);
                this.tail = 0L;
                return len;
            }
            if ((long)len > av + this.head) {
                this.put(buf, off, (int)av, this.tail);
                this.put(buf, off + (int)av, (int)this.head, 0L);
                this.tail = this.head;
                return (int)(av + this.head);
            }
            this.put(buf, off, (int)av, this.tail);
            this.put(buf, off + (int)av, (int)((long)len - av), 0L);
            this.tail = (long)len - av;
            return len;
        }
        long av = this.head - this.tail;
        if ((long)len > av) {
            len = (int)av;
        }
        this.put(buf, off, len, this.tail);
        this.tail += (long)len;
        return len;
    }

    @Override
    public final boolean isEmpty() {
        return this.head == -1L;
    }

    @Override
    public final boolean isFull() {
        return this.head == this.tail;
    }
}

