/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ClassLoaders;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class IoUtil {
    private static final Logger LOGGER;
    private static final ExecutorService EXECUTOR_SERVICE;
    public static final InputStream EMPTY_INPUT_STREAM;
    public static final OutputStream NULL_OUTPUT_STREAM;
    public static final InputStream ZERO_INPUT_STREAM;
    private static final long[] THRESHOLDS;

    private IoUtil() {
    }

    @Nullable
    public static URL findOnPath(@Nullable File[] path, String resourceName) throws IOException {
        if (path == null) {
            return null;
        }
        for (File directoryOrArchiveFile : path) {
            if (directoryOrArchiveFile.isDirectory()) {
                File file = new File(directoryOrArchiveFile, resourceName);
                if (!file.isFile()) continue;
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    AssertionError ae = new AssertionError((Object)resourceName);
                    ((Throwable)((Object)ae)).initCause(mue);
                    throw ae;
                }
            }
            if (!directoryOrArchiveFile.isFile()) continue;
            URL url = new URL("jar", null, directoryOrArchiveFile.toURI() + "!/" + resourceName);
            try {
                url.openConnection().connect();
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
            return url;
        }
        return null;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw (IOException)ExceptionUtil.wrap((String)(count + " bytes copied so far"), (Throwable)ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        try {
            long count = IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
            if (closeInputStream) {
                inputStream.close();
            }
            if (closeOutputStream) {
                outputStream.close();
            }
            return count;
        }
        catch (IOException ioe) {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public static RunnableWhichThrows<IOException> copyRunnable(final InputStream in, final OutputStream out) {
        return new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                IoUtil.copy(in, out);
            }
        };
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, false, writer, false);
    }

    public static long copy(Reader reader, boolean closeReader, Writer writer, boolean closeWriter) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        try {
            while (true) {
                LOGGER.log(Level.FINEST, "About to ''read(char[{0}])''", buffer.length);
                int n = reader.read(buffer);
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", n);
                if (n == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(char[{0}])''", n);
                writer.write(buffer, 0, n);
                LOGGER.log(Level.FINEST, "'write()' returned");
            }
            writer.flush();
            if (closeReader) {
                reader.close();
            }
            if (closeWriter) {
                writer.close();
            }
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw (IOException)ExceptionUtil.wrap((String)(count + " characters copied so far"), (Throwable)ioe);
        }
    }

    public static long copy(Reader reader, OutputStream outputStream, Charset charset) throws IOException {
        return IoUtil.copy(reader, new OutputStreamWriter(outputStream, charset));
    }

    public static long copy(Readable r, Appendable a) throws IOException {
        int n;
        CharBuffer cb = CharBuffer.allocate(4096);
        long count = 0L;
        while ((n = r.read(cb)) != -1) {
            cb.flip();
            a.append(cb);
            count += (long)n;
            cb.clear();
        }
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile, boolean append) throws IOException {
        try {
            return IoUtil.copy(inputStream, closeInputStream, new FileOutputStream(outputFile, append), true);
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static long copy(Reader reader, boolean closeReader, File outputFile, boolean append, Charset outputCharset) throws IOException {
        try {
            long count = IoUtil.copy(reader, closeReader, new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, append), outputCharset), true);
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static long copy(File inputFile, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        FileInputStream is;
        try {
            is = new FileInputStream(inputFile);
        }
        catch (IOException ioe) {
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        return IoUtil.copy((InputStream)is, true, outputStream, closeOutputStream);
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            return IoUtil.copy(inputStream, closeInputStream, os, true);
        }
        catch (IOException ioe) {
            if (!outputFile.delete()) {
                throw new IOException("Cannot delete '" + outputFile + "'");
            }
            throw ioe;
        }
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile, CollisionStrategy collisionStrategy) throws IOException {
        if (!outputFile.exists()) {
            return IoUtil.copy(inputStream, closeInputStream, outputFile);
        }
        switch (collisionStrategy) {
            case LEAVE_OLD: {
                if (closeInputStream) {
                    inputStream.close();
                }
                return -1L;
            }
            case OVERWRITE: {
                return IoUtil.copy(inputStream, closeInputStream, outputFile);
            }
            case IO_EXCEPTION: {
                throw new IOException("File \"" + outputFile + "\" already exists");
            }
            case IO_EXCEPTION_IF_DIFFERENT: {
                if (!IoUtil.isContentIdentical(inputStream, outputFile)) {
                    throw new IOException("File \"" + outputFile + "\" already exists with non-identical content");
                }
                if (closeInputStream) {
                    inputStream.close();
                }
                return -1L;
            }
        }
        throw new AssertionError((Object)collisionStrategy);
    }

    public static long copy(File inputFile, File outputFile) throws IOException {
        return IoUtil.copy((InputStream)new FileInputStream(inputFile), true, outputFile);
    }

    public static long copy(File inputFile, File outputFile, CollisionStrategy collisionStrategy) throws IOException {
        if (!outputFile.exists()) {
            return IoUtil.copy(inputFile, outputFile);
        }
        switch (collisionStrategy) {
            case LEAVE_OLD: {
                return -1L;
            }
            case OVERWRITE: {
                return IoUtil.copy(inputFile, outputFile);
            }
            case IO_EXCEPTION: {
                throw new IOException("File \"" + outputFile + "\" already exists");
            }
            case IO_EXCEPTION_IF_DIFFERENT: {
                if (!IoUtil.isContentIdentical(inputFile, outputFile)) {
                    throw new IOException("File \"" + outputFile + "\" already exists with non-identical content");
                }
                return -1L;
            }
        }
        throw new AssertionError((Object)collisionStrategy);
    }

    public static void copyTree(File source, File destination, CollisionStrategy collisionStrategy) throws IOException {
        if (source.isFile()) {
            IoUtil.copy(source, destination, collisionStrategy);
            return;
        }
        boolean destinationDirectoryAlreadyExisted = destination.exists();
        if (!destinationDirectoryAlreadyExisted && !destination.mkdir()) {
            throw new IOException(destination.toString());
        }
        try {
            for (String memberName : source.list()) {
                IoUtil.copyTree(new File(source, memberName), new File(destination, memberName), collisionStrategy);
            }
        }
        catch (IOException ioe) {
            if (!destinationDirectoryAlreadyExisted) {
                destination.delete();
            }
            throw ioe;
        }
        catch (RuntimeException re) {
            if (!destinationDirectoryAlreadyExisted) {
                destination.delete();
            }
            throw re;
        }
    }

    public static void copyTree(URL source, File destination, CollisionStrategy collisionStrategy) throws IOException {
        Map rs = ClassLoaders.getSubresourcesOf((URL)source, (String)"", (boolean)true);
        if (rs.isEmpty()) {
            return;
        }
        if (rs.size() == 1) {
            IoUtil.copy(((URL)rs.values().iterator().next()).openStream(), true, destination, collisionStrategy);
            return;
        }
        IoUtil.copySubtree(rs, "", destination, collisionStrategy);
    }

    private static void copySubtree(Map<String, URL> rs, String namePrefix, File destinationDirectory, CollisionStrategy collisionStrategy) throws IOException {
        assert (rs.get(namePrefix) != null);
        if (!destinationDirectory.mkdir()) {
            throw new IOException("Could not create destination directory \"" + destinationDirectory + "\"");
        }
        for (Map.Entry<String, URL> e : rs.entrySet()) {
            String name = e.getKey();
            URL location = e.getValue();
            if (!name.startsWith(namePrefix)) continue;
            int npl = namePrefix.length();
            if (name.length() == npl) continue;
            int idx = name.indexOf(47, npl);
            if (idx == -1) {
                IoUtil.copy(location.openStream(), true, new File(destinationDirectory, name.substring(npl)));
                continue;
            }
            if (idx != name.length() - 1) continue;
            IoUtil.copySubtree(rs, name, new File(destinationDirectory, name.substring(npl)), collisionStrategy);
        }
    }

    public static ConsumerWhichThrows<OutputStream, IOException> copyFrom(final InputStream inputStream) {
        return new ConsumerWhichThrows<OutputStream, IOException>(){

            public void consume(OutputStream os) throws IOException {
                IoUtil.copy(inputStream, os);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContentIdentical(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fis1 = new FileInputStream(file1);
        try {
            boolean result = IoUtil.isContentIdentical((InputStream)fis1, file2);
            ((InputStream)fis1).close();
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                ((InputStream)fis1).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isContentIdentical(InputStream stream, File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            boolean result = IoUtil.isContentIdentical(stream, fis);
            ((InputStream)fis).close();
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (Exception exception) {}
        }
    }

    private static boolean isContentIdentical(InputStream stream1, InputStream stream2) throws IOException {
        int n1;
        byte[] buffer1 = new byte[4096];
        byte[] buffer2 = new byte[4096];
        while ((n1 = stream1.read(buffer1)) != -1) {
            int off = 0;
            while (off < n1) {
                int n2 = stream2.read(buffer2, off, n1 - off);
                if (n2 == -1) {
                    return false;
                }
                while (n2 > 0) {
                    if (buffer2[off] != buffer1[off]) {
                        return false;
                    }
                    --n2;
                    ++off;
                }
            }
        }
        return true;
    }

    @NotNullByDefault(value=false)
    public static OutputStream tee(final OutputStream ... delegates) {
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                IOException caughtIOException = null;
                for (OutputStream delegate : delegates) {
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            @Override
            public void flush() throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.flush();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.write(b, off, len);
                }
            }

            @Override
            public void write(int b) throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.write(b);
                }
            }
        };
    }

    public static InputStream wye(InputStream in, final OutputStream out) {
        return new FilterInputStream(in){

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1) {
                    out.flush();
                } else {
                    out.write(b);
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count > 0) {
                    out.write(b, off, count);
                }
                if (count == 0) {
                    out.flush();
                }
                return count;
            }

            @Override
            public int available() throws IOException {
                out.flush();
                return this.in.available();
            }
        };
    }

    public static long writeAndCount(ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents, OutputStream outputStream) throws IOException {
        ConsumerUtil.Produmer count = ConsumerUtil.store();
        writeContents.consume((Object)IoUtil.tee(outputStream, IoUtil.lengthWritten((Consumer<? super Integer>)ConsumerUtil.cumulate((Consumer)count, (long)0L))));
        Long result = (Long)count.produce();
        return result == null ? 0L : result;
    }

    public static void parallel(WritingRunnable[] writingRunnables, Writer writer) {
        List<Callable<Void>> callables = IoUtil.toCallables(writingRunnables, writer);
        try {
            EXECUTOR_SERVICE.invokeAll(callables);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private static List<Callable<Void>> toCallables(WritingRunnable[] writingRunnables, final Writer writer) {
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(writingRunnables.length + 1);
        final ArrayList<PipedReader> readers = new ArrayList<PipedReader>(writingRunnables.length);
        callables.add(new Callable<Void>(){

            @Override
            @Nullable
            public Void call() throws Exception {
                for (Reader reader : readers) {
                    IoUtil.copy(reader, writer);
                }
                return null;
            }
        });
        for (final WritingRunnable wr : writingRunnables) {
            final PipedWriter pw = new PipedWriter();
            try {
                readers.add(new PipedReader(pw));
            }
            catch (IOException ioe) {
                throw (AssertionError)((Object)ExceptionUtil.wrap((String)"Should never throw an IOException if the argument is a 'fresh' PipedWriter", (Throwable)ioe, AssertionError.class));
            }
            callables.add(new Callable<Void>(){

                @Override
                @Nullable
                public Void call() throws Exception {
                    try {
                        wr.run(pw);
                        Void void_ = null;
                        return void_;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, null, e);
                        throw e;
                    }
                    catch (Error e) {
                        LOGGER.log(Level.SEVERE, null, e);
                        throw e;
                    }
                    finally {
                        try {
                            pw.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        return callables;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtil.copy(is, baos);
        return baos.toByteArray();
    }

    public static String readAll(InputStream inputStream, Charset charset, boolean closeInputStream) throws IOException {
        StringWriter sw = new StringWriter();
        IoUtil.copy(new InputStreamReader(inputStream, charset), closeInputStream, sw, false);
        return sw.toString();
    }

    public static long skip(InputStream inputStream, long n) throws IOException {
        long result;
        long skipped;
        for (result = 0L; result < n; result += skipped) {
            skipped = inputStream.skip(n - result);
            if (skipped != 0L) continue;
            return result;
        }
        return result;
    }

    public static long skipAll(InputStream inputStream) throws IOException {
        long result = 0L;
        long skipped;
        while ((skipped = inputStream.skip(Long.MAX_VALUE)) != 0L) {
            result += skipped;
        }
        return result;
    }

    public static OutputStream split(final ProducerWhichThrows<? extends OutputStream, ? extends IOException> delegates, final Producer<? extends Long> byteCountLimits) throws IOException {
        return new OutputStream(){
            private OutputStream delegate;
            private long delegateByteCount;
            {
                this.delegate = (OutputStream)AssertionUtil.notNull((Object)delegates.produce(), (String)"'delegates' produced <null>");
                this.delegateByteCount = (Long)AssertionUtil.notNull((Object)byteCountLimits.produce(), (String)"'byteCountLimits' produced <null>");
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public synchronized void write(@Nullable byte[] b, int off, int len) throws IOException {
                while ((long)len > this.delegateByteCount) {
                    this.delegate.write(b, off, (int)this.delegateByteCount);
                    this.delegate.close();
                    off = (int)((long)off + this.delegateByteCount);
                    len = (int)((long)len - this.delegateByteCount);
                    this.delegate = (OutputStream)AssertionUtil.notNull((Object)delegates.produce(), (String)"'delegates' produced <null>");
                    this.delegateByteCount = (Long)AssertionUtil.notNull((Object)byteCountLimits.produce(), (String)"'byteCountLimits' produced <null>");
                }
                this.delegate.write(b, off, len);
                this.delegateByteCount -= (long)len;
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
            }
        };
    }

    public static InputStream constantInputStream(final byte b) {
        return new InputStream(){

            @Override
            public int read() {
                return 0;
            }

            @Override
            public int read(@Nullable byte[] buf, int off, int len) {
                Arrays.fill(buf, off, len, b);
                return len;
            }
        };
    }

    public static InputStream unclosableInputStream(InputStream delegate) {
        return new FilterInputStream(delegate){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream unclosableOutputStream(OutputStream delegate) {
        return new FilterOutputStream(delegate){

            @Override
            public void close() {
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }
        };
    }

    public static void fill(OutputStream outputStream, byte b, long count) throws IOException {
        byte[] ba;
        if (count > 8192L) {
            ba = new byte[8192];
            if (b != 0) {
                Arrays.fill(ba, b);
            }
            do {
                outputStream.write(ba);
            } while ((count -= 8192L) > 8192L);
        }
        ba = new byte[(int)count];
        Arrays.fill(ba, b);
        outputStream.write(ba);
    }

    public static InputStream byteProducerInputStream(final ProducerWhichThrows<? extends Byte, ? extends IOException> delegate) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                Byte b = (Byte)delegate.produce();
                return b != null ? 0xFF & b : -1;
            }
        };
    }

    public static InputStream byteProducerInputStream(Producer<? extends Byte> delegate) {
        return IoUtil.byteProducerInputStream((ProducerWhichThrows<? extends Byte, ? extends IOException>)ProducerUtil.asProducerWhichThrows(delegate));
    }

    public static InputStream randomInputStream(long seed) {
        return IoUtil.byteProducerInputStream((Producer<? extends Byte>)ProducerUtil.randomByteProducer((long)seed));
    }

    public static OutputStream byteConsumerOutputStream(final ConsumerWhichThrows<? super Byte, ? extends IOException> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                delegate.consume((Object)((byte)b));
            }
        };
    }

    public static String readAll(Reader reader) throws IOException {
        return IoUtil.readAll(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(Reader reader, boolean closeReader) throws IOException {
        char[] buf = new char[4096];
        StringBuilder sb = new StringBuilder();
        try {
            int n;
            while ((n = reader.read(buf)) != -1) {
                sb.append(buf, 0, n);
            }
            if (closeReader) {
                reader.close();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static InputStream deleteOnClose(InputStream delegate, final File file) {
        return new FilterInputStream(delegate){

            @Override
            public void close() throws IOException {
                super.close();
                file.delete();
            }
        };
    }

    public static OutputStream[] compareOutput(final int n, Runnable whenIdentical, Runnable whenNotIdentical) {
        abstract class ChecksumOutputStream
        extends OutputStream {
            private final Checksum checksum = new CRC32();
            private long count;
            protected final long[] checksums = new long[IoUtil.access$100().length];
            protected int idx;
            private boolean closed;

            ChecksumOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                if (this.count == THRESHOLDS[this.idx]) {
                    this.pushChecksum();
                }
                this.checksum.update(b);
                ++this.count;
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                assert (b != null);
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                while (this.count + (long)len > THRESHOLDS[this.idx]) {
                    int part = (int)Math.min(Integer.MAX_VALUE, THRESHOLDS[this.idx] - this.count);
                    this.checksum.update(b, off, part);
                    this.count = THRESHOLDS[this.idx];
                    this.pushChecksum();
                    off += part;
                    len -= part;
                }
                this.checksum.update(b, off, len);
                this.count += (long)len;
            }

            private void pushChecksum() {
                this.checksums[this.idx] = this.checksum.getValue();
                this.checksumWasPushed(this.idx);
                ++this.idx;
            }

            abstract void checksumWasPushed(int var1);

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.pushChecksum();
                this.closed = true;
                this.wasClosed();
            }

            abstract void wasClosed();
        }
        OutputStream[] result = new ChecksumOutputStream[n];
        for (int i = 0; i < n; ++i) {
            result[i] = new ChecksumOutputStream((ChecksumOutputStream[])result, whenNotIdentical, whenIdentical){
                final /* synthetic */ ChecksumOutputStream[] val$result;
                final /* synthetic */ Runnable val$whenNotIdentical;
                final /* synthetic */ Runnable val$whenIdentical;
                {
                    this.val$result = checksumOutputStreamArray;
                    this.val$whenNotIdentical = runnable;
                    this.val$whenIdentical = runnable2;
                }

                @Override
                void checksumWasPushed(int idx) {
                    for (int i = 0; i < n; ++i) {
                        if (this.val$result[i].idx != idx + 1 || this.val$result[i].checksums[idx] == this.checksums[idx]) continue;
                        this.val$whenNotIdentical.run();
                        return;
                    }
                }

                @Override
                void wasClosed() {
                    for (int i = 0; i < n; ++i) {
                        if (!this.val$result[i].closed) {
                            return;
                        }
                        if (this.val$result[i].idx == this.idx && this.val$result[i].checksums[this.idx - 1] == this.checksums[this.idx - 1]) continue;
                        this.val$whenNotIdentical.run();
                        return;
                    }
                    this.val$whenIdentical.run();
                }
            };
        }
        return result;
    }

    public static OutputStream lengthWritten(final Consumer<? super Integer> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                delegate.consume((Object)1);
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
                delegate.consume((Object)len);
            }
        };
    }

    public static Reader asReader(final CharSequence cs) {
        return new Reader(){
            int pos;

            @Override
            public int read() {
                return this.pos >= cs.length() ? -1 : (int)cs.charAt(this.pos++);
            }

            @Override
            public int read(@Nullable char[] cbuf, int off, int len) {
                assert (cbuf != null);
                if (len <= 0) {
                    return 0;
                }
                if (this.pos >= cs.length()) {
                    return -1;
                }
                int end = cs.length();
                if (this.pos + len > end) {
                    len = end - this.pos;
                } else {
                    end = this.pos + len;
                }
                int i = this.pos;
                while (i < end) {
                    cbuf[off++] = cs.charAt(i++);
                }
                return len;
            }

            @Override
            public void close() {
            }
        };
    }

    public static void copyResource(ClassLoader classLoader, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(Class<?> clasS, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = clasS.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(final ClassLoader classLoader, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(classLoader, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    public static void copyResource(final Class<?> clasS, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(clasS, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <EX extends Throwable> void asFile(InputStream inputStream, boolean closeInputStream, @Nullable String prefix, @Nullable String suffix, @Nullable File directory, ConsumerWhichThrows<? super File, ? extends EX> delegate) throws IOException, EX {
        File temporaryFile = File.createTempFile(prefix, suffix, directory);
        try {
            temporaryFile.deleteOnExit();
            IoUtil.copy(inputStream, closeInputStream, temporaryFile);
            delegate.consume((Object)temporaryFile);
            temporaryFile.delete();
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            temporaryFile.delete();
        }
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, Charset charset, ConsumerWhichThrows<? super PrintWriter, ? extends EX> printer) throws IOException, EX {
        IoUtil.outputFilePrintWriter(file, charset, printer, false);
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, final Charset charset, final ConsumerWhichThrows<? super PrintWriter, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        final boolean[] hasError = new boolean[1];
        IoUtil.outputFileOutputStream(file, new ConsumerWhichThrows<OutputStream, EX>(){

            public void consume(OutputStream os) throws Throwable {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, charset));
                delegate.consume((Object)pw);
                hasError[0] = pw.checkError();
            }
        }, createMissingParentDirectories);
        if (hasError[0]) {
            throw new IOException();
        }
    }

    public static <EX extends Throwable> void outputFileOutputStream(File file, final ConsumerWhichThrows<? super OutputStream, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        class IORuntimeException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IOException ioe;

            IORuntimeException(IOException ioe) {
                this.ioe = ioe;
            }
        }
        try {
            IoUtil.outputFile(file, new ConsumerWhichThrows<File, EX>(){

                public void consume(File file) throws Throwable {
                    try {
                        FileOutputStream os = new FileOutputStream(file);
                        try {
                            delegate.consume((Object)os);
                        }
                        catch (RuntimeException re) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw re;
                        }
                        catch (Error e) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw e;
                        }
                        catch (Throwable t) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Throwable tmp = t;
                            throw tmp;
                        }
                        ((OutputStream)os).close();
                    }
                    catch (IOException ioe) {
                        throw new IORuntimeException(ioe);
                    }
                }
            }, createMissingParentDirectories);
        }
        catch (IORuntimeException iore) {
            throw iore.ioe;
        }
    }

    public static <EX extends Throwable> void outputFile(File file, ConsumerWhichThrows<? super File, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        if (createMissingParentDirectories) {
            IoUtil.createMissingParentDirectoriesFor(file);
        }
        File newFile = new File(file.getParentFile(), "." + file.getName() + ".new");
        try {
            delegate.consume((Object)newFile);
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete existing file \"" + file + "\"");
            }
            if (!newFile.renameTo(file)) {
                throw new IOException("Could not rename \"" + newFile + "\" to \"" + file + "\"");
            }
        }
        catch (RuntimeException re) {
            newFile.delete();
            throw re;
        }
        catch (Error e) {
            newFile.delete();
            throw e;
        }
        catch (Throwable t) {
            newFile.delete();
            Throwable tmp = t;
            throw tmp;
        }
    }

    public static void createMissingParentDirectoriesFor(File file) throws IOException {
        File parentDirectory = file.getParentFile();
        if (parentDirectory == null) {
            return;
        }
        if (!parentDirectory.isDirectory() && !parentDirectory.mkdirs()) {
            throw new IOException("Cannot create directory \"" + parentDirectory + "\"");
        }
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copyAvailable(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L && inputStream.available() > 0) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) {
                    throw new IllegalStateException("EOI despite available()");
                }
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw (IOException)ExceptionUtil.wrap((String)(count + " bytes copied so far"), (Throwable)ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    public static InputStream onEndOfInput(InputStream delegate, final Runnable runnable) {
        return new FilterInputStream(delegate){
            boolean hadEndOfInput;

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return count;
            }
        };
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(IoUtil.class.getName());
        EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(3 * Runtime.getRuntime().availableProcessors(), ThreadUtil.DAEMON_THREAD_FACTORY);
        EMPTY_INPUT_STREAM = new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(@Nullable byte[] buf, int off, int len) {
                return -1;
            }
        };
        NULL_OUTPUT_STREAM = new OutputStream(){

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
            }

            @Override
            public void write(int b) {
            }
        };
        ZERO_INPUT_STREAM = IoUtil.constantInputStream((byte)0);
        THRESHOLDS = new long[126];
        long x = 2L;
        int i = 0;
        while (i < THRESHOLDS.length) {
            IoUtil.THRESHOLDS[i++] = x;
            IoUtil.THRESHOLDS[i++] = x + (x >> 1);
            x <<= 1;
        }
    }

    public static interface WritingRunnable {
        public void run(Writer var1) throws Exception;
    }

    public static enum CollisionStrategy {
        LEAVE_OLD,
        OVERWRITE,
        IO_EXCEPTION,
        IO_EXCEPTION_IF_DIFFERENT;

    }
}

