/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@NotNullByDefault(value=false)
public class FixedLengthOutputStream
extends FilterOutputStream {
    private long remaining;

    public FixedLengthOutputStream(OutputStream out, long n) {
        super(out);
        this.remaining = n;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.remaining) {
            throw new IOException("Attempt to write " + ((long)len - this.remaining) + " more bytes than allowed");
        }
        this.out.write(b, off, len);
        this.remaining -= (long)len;
    }

    @Override
    public void close() throws IOException {
        if (this.remaining > 0L) {
            throw new IOException("Stream closed when " + this.remaining + " bytes were unwritten");
        }
        this.out.close();
    }
}

