/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;

@NotNullByDefault(value=false)
public class FileBufferedChannel
implements WritableByteChannel {
    private final Multiplexer multiplexer;
    private final SelectableChannel delegate;
    private final FileChannel buffer;
    private final File file;
    private final RunnableWhichThrows<IOException> flusher = new RunnableWhichThrows<IOException>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            while (true) {
                long n;
                if ((n = FileBufferedChannel.this.buffer.transferTo(FileBufferedChannel.this.head, FileBufferedChannel.this.tail - FileBufferedChannel.this.head, (WritableByteChannel)((Object)FileBufferedChannel.this.delegate))) == 0L) {
                    FileBufferedChannel.this.multiplexer.register(FileBufferedChannel.this.delegate, 4, (RunnableWhichThrows<IOException>)FileBufferedChannel.this.flusher);
                    return;
                }
                FileBufferedChannel fileBufferedChannel = FileBufferedChannel.this;
                synchronized (fileBufferedChannel) {
                    FileBufferedChannel fileBufferedChannel2 = FileBufferedChannel.this;
                    fileBufferedChannel2.head = fileBufferedChannel2.head + n;
                    if (FileBufferedChannel.this.head == FileBufferedChannel.this.tail) {
                        if (!FileBufferedChannel.this.open) {
                            FileBufferedChannel.this.buffer.close();
                            FileBufferedChannel.this.file.delete();
                        }
                        return;
                    }
                }
            }
        }
    };
    private boolean open = true;
    private long head;
    private long tail;

    public FileBufferedChannel(Multiplexer multiplexer, SelectableChannel delegate) throws IOException {
        this.multiplexer = multiplexer;
        this.delegate = delegate;
        this.file = File.createTempFile("prefix", "suffix");
        this.file.deleteOnExit();
        this.buffer = new RandomAccessFile(this.file, "rw").getChannel();
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int n = this.buffer.write(src);
        if (n == 0) {
            return 0;
        }
        boolean flusherRegistered = this.head != this.tail;
        this.tail += (long)n;
        if (!flusherRegistered) {
            this.flusher.run();
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.head == this.tail) {
            this.buffer.close();
            this.file.delete();
        }
    }

    public synchronized long transferFrom(ReadableByteChannel src, long count) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long n = this.buffer.transferFrom(src, this.tail, count);
        if (n == 0L) {
            return 0L;
        }
        boolean flusherRegistered = this.head != this.tail;
        this.tail += n;
        if (!flusherRegistered) {
            this.flusher.run();
        }
        return n;
    }
}

