/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.CharFilter;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;

public class CharFilterWriter
extends FilterWriter {
    private final Thread worker;
    @Nullable
    private IOException charFilterIOException;
    @Nullable
    private RuntimeException charFilterRuntimeException;

    public CharFilterWriter(final CharFilter<?> charFilter, final Writer out) {
        super(new PipedWriter());
        PipedReader pr;
        try {
            pr = new PipedReader((PipedWriter)this.out);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.worker = new Thread("CharFilterWriter"){

            @Override
            public void run() {
                try {
                    charFilter.run(pr, out);
                }
                catch (IOException ioe) {
                    CharFilterWriter.this.charFilterIOException = ioe;
                }
                catch (RuntimeException re) {
                    CharFilterWriter.this.charFilterRuntimeException = re;
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        };
        this.worker.start();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new char[]{(char)b}, 0, 1);
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(char[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.charFilterIOException != null) {
            throw (IOException)ExceptionUtil.wrap((String)"CharFilterReader", (Throwable)this.charFilterIOException);
        }
        if (this.charFilterRuntimeException != null) {
            throw (RuntimeException)ExceptionUtil.wrap((String)"CharFilterReader", (Throwable)this.charFilterRuntimeException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this.charFilterIOException != null) {
            throw (IOException)ExceptionUtil.wrap((String)"CharFilterReader", (Throwable)this.charFilterIOException);
        }
        if (this.charFilterRuntimeException != null) {
            throw (RuntimeException)ExceptionUtil.wrap((String)"CharFilterReader", (Throwable)this.charFilterRuntimeException);
        }
    }
}

